      SUBROUTINE ZERRGE( PATH, NUNIT )
*
*  -- LAPACK test routine (version 2.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
      IMPLICIT NONE
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  ZERRGE tests the error exits for the COMPLEX*16 routines
*  for general matrices.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX
      PARAMETER          ( NMAX = 4 )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, INFO, J, NRHS, IW, LW
      DOUBLE PRECISION   ANRM, CCOND, RCOND
*     ..
*     .. Local Arrays ..
      INTEGER            IP( NMAX ), IN( 100 )
      DOUBLE PRECISION   R( NMAX ), R1( NMAX ), R2( NMAX )
      COMPLEX*16         A( NMAX, NMAX ), AF( NMAX, NMAX ), B( NMAX ),
     $                   W( 2*NMAX ), X( NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      EXTERNAL           LSAMEN
*     ..
*     .. External Subroutines ..
      EXTERNAL ALAESM, CHKXER, ZGBCON, ZGBEQU, ZGBRFS, ZGBTF2, ZGBTRF,
     $         ZGBTRS, LA_TEST_ZGECON, LA_TEST_ZGEEQU, LA_TEST_ZGERFS,
     $         ZGETF2, LA_TEST_ZGETRF, LA_TEST_ZGETRI, LA_TEST_ZGETRS
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, DCMPLX
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = DCMPLX( 1.D0 / DBLE( I+J ),
     $                  -1.D0 / DBLE( I+J ) )
            AF( I, J ) = DCMPLX( 1.D0 / DBLE( I+J ),
     $                   -1.D0 / DBLE( I+J ) )
   10    CONTINUE
         B( J ) = 0.D0
         R1( J ) = 0.D0
         R2( J ) = 0.D0
         W( J ) = 0.D0
         X( J ) = 0.D0
         IP( J ) = J
   20 CONTINUE
      OK = .TRUE.
*
*     Test error exits of the routines that use the LU decomposition
*     of a general matrix.
*
      IF( LSAMEN( 2, C2, 'GE' ) ) THEN
*
*        ZGETRF
*
         SRNAMT = 'ZGETRF'
         INFOT = 2
         INFO = 201
         CALL LA_TEST_ZGETRF( NMAX, NMAX, A, NMAX, IP, INFO )
         CALL CHKXER( 'SGETRF', INFOT, NOUT, LERR, OK )
*
*        ZGETF2
*
         SRNAMT = 'ZGETF2'
         INFOT = 1
         CALL ZGETF2( -1, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGETF2', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGETF2( 0, -1, A, 1, IP, INFO )
         CALL CHKXER( 'ZGETF2', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGETF2( 2, 1, A, 1, IP, INFO )
         CALL CHKXER( 'ZGETF2', INFOT, NOUT, LERR, OK )
*
*        ZGETRI
*
         SRNAMT = 'ZGETRI'
         DO I = 1, 2
            IN(I) = 1
         END DO
         DO I = 1, 2
            INFOT = I
            DO J = 1, IN(I)
               INFO = J + 100*I
               CALL LA_TEST_ZGETRI( NMAX, A, NMAX, IP, W, LW, INFO )
               CALL CHKXER( 'ZGETRI', INFOT, NOUT, LERR, OK )
            END DO
         END DO
*
*        ZGETRS
*
         SRNAMT = 'ZGETRS'
         DO I = 1, 4
            IN(I) = 1
         END DO
         DO I = 1, 4
            INFOT = I
            DO J = 1, IN(I)
               DO NRHS = 1, 2
                  INFO = J + 100*I
                  CALL LA_TEST_ZGETRS( 'N', NMAX, NRHS, A, NMAX,
     $                 IP, B, NMAX, INFO )
                  CALL CHKXER( 'ZGETRS', INFOT, NOUT, LERR, OK )
               END DO
            END DO
         END DO
*
*        ZGERFS
*
         SRNAMT = 'ZGERFS'
         DO I = 1, 8
            IN(I) = 1
         END DO
         IN(2) = 2
         IN(5) = 2
         DO I = 1, 8
            INFOT = I
            DO J = 1, IN(I)
               DO NRHS = 1, 2
                  INFO = J + 100*I
                  CALL LA_TEST_ZGERFS( 'N', NMAX, NRHS, A, NMAX, AF,
     $                 NMAX, IP, B, NMAX, X, NMAX, R1, R2, W, IW, INFO )
                  CALL CHKXER( 'ZGERFS', INFOT, NOUT, LERR, OK )
               END DO
            END DO
         END DO
*
*        ZGECON
*
         SRNAMT = 'ZGECON'
         DO I = 1, 4
            IN(I) = 1
         END DO
         IN(4) = 2
         DO I = 1, 4
            IF( I.NE.3 ) THEN
               INFOT = I
               DO J = 1, IN(I)
                  INFO = J + 100*I
                  CALL LA_TEST_ZGECON( 'I', NMAX, A, NMAX, ANRM, RCOND,
     $                 W, IW, INFO )
                  CALL CHKXER( 'ZGECON ', INFOT, NOUT, LERR, OK )
               END DO
            END IF
         END DO
*
*        ZGEEQU
*
         SRNAMT = 'ZGEEQU'
         DO I = 2, 3
            IN(I) = 1
         END DO
         DO I = 2, 3
            INFOT = I
            DO J = 1, IN(I)
               INFO = J + 100*I
               CALL LA_TEST_ZGEEQU( NMAX, NMAX+1, A, NMAX, R1, R2,
     $              RCOND, CCOND, ANRM, INFO )
               CALL CHKXER( 'ZGEEQU', INFOT, NOUT, LERR, OK )
            END DO
         END DO
*
*     Test error exits of the routines that use the LU decomposition
*     of a general band matrix.
*
      ELSE IF( LSAMEN( 2, C2, 'GB' ) ) THEN
*
*        ZGBTRF
*
         SRNAMT = 'ZGBTRF'
         INFOT = 1
         CALL ZGBTRF( -1, 0, 0, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTRF', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBTRF( 0, -1, 0, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTRF', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBTRF( 1, 1, -1, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTRF', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBTRF( 1, 1, 0, -1, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTRF', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZGBTRF( 2, 2, 1, 1, A, 3, IP, INFO )
         CALL CHKXER( 'ZGBTRF', INFOT, NOUT, LERR, OK )
*
*        ZGBTF2
*
         SRNAMT = 'ZGBTF2'
         INFOT = 1
         CALL ZGBTF2( -1, 0, 0, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTF2', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBTF2( 0, -1, 0, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTF2', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBTF2( 1, 1, -1, 0, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTF2', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBTF2( 1, 1, 0, -1, A, 1, IP, INFO )
         CALL CHKXER( 'ZGBTF2', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZGBTF2( 2, 2, 1, 1, A, 3, IP, INFO )
         CALL CHKXER( 'ZGBTF2', INFOT, NOUT, LERR, OK )
*
*        ZGBTRS
*
         SRNAMT = 'ZGBTRS'
         INFOT = 1
         CALL ZGBTRS( '/', 0, 0, 0, 1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBTRS( 'N', -1, 0, 0, 1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBTRS( 'N', 1, -1, 0, 1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBTRS( 'N', 1, 0, -1, 1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZGBTRS( 'N', 1, 0, 0, -1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZGBTRS( 'N', 2, 1, 1, 1, A, 3, IP, B, 2, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ZGBTRS( 'N', 2, 0, 0, 1, A, 1, IP, B, 1, INFO )
         CALL CHKXER( 'ZGBTRS', INFOT, NOUT, LERR, OK )
*
*        ZGBRFS
*
         SRNAMT = 'ZGBRFS'
         INFOT = 1
         CALL ZGBRFS( '/', 0, 0, 0, 0, A, 1, AF, 1, IP, B, 1, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBRFS( 'N', -1, 0, 0, 0, A, 1, AF, 1, IP, B, 1, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBRFS( 'N', 1, -1, 0, 0, A, 1, AF, 1, IP, B, 1, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBRFS( 'N', 1, 0, -1, 0, A, 1, AF, 1, IP, B, 1, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZGBRFS( 'N', 1, 0, 0, -1, A, 1, AF, 1, IP, B, 1, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZGBRFS( 'N', 2, 1, 1, 1, A, 2, AF, 4, IP, B, 2, X, 2, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ZGBRFS( 'N', 2, 1, 1, 1, A, 3, AF, 3, IP, B, 2, X, 2, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ZGBRFS( 'N', 2, 0, 0, 1, A, 1, AF, 1, IP, B, 1, X, 2, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
         INFOT = 14
         CALL ZGBRFS( 'N', 2, 0, 0, 1, A, 1, AF, 1, IP, B, 2, X, 1, R1,
     $                R2, W, R, INFO )
         CALL CHKXER( 'ZGBRFS', INFOT, NOUT, LERR, OK )
*
*        ZGBCON
*
         SRNAMT = 'ZGBCON'
         INFOT = 1
         CALL ZGBCON( '/', 0, 0, 0, A, 1, IP, ANRM, RCOND, W, R, INFO )
         CALL CHKXER( 'ZGBCON', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBCON( '1', -1, 0, 0, A, 1, IP, ANRM, RCOND, W, R, INFO )
         CALL CHKXER( 'ZGBCON', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBCON( '1', 1, -1, 0, A, 1, IP, ANRM, RCOND, W, R, INFO )
         CALL CHKXER( 'ZGBCON', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBCON( '1', 1, 0, -1, A, 1, IP, ANRM, RCOND, W, R, INFO )
         CALL CHKXER( 'ZGBCON', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZGBCON( '1', 2, 1, 1, A, 3, IP, ANRM, RCOND, W, R, INFO )
         CALL CHKXER( 'ZGBCON', INFOT, NOUT, LERR, OK )
*
*        ZGBEQU
*
         SRNAMT = 'ZGBEQU'
         INFOT = 1
         CALL ZGBEQU( -1, 0, 0, 0, A, 1, R1, R2, RCOND, CCOND, ANRM,
     $                INFO )
         CALL CHKXER( 'ZGBEQU', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGBEQU( 0, -1, 0, 0, A, 1, R1, R2, RCOND, CCOND, ANRM,
     $                INFO )
         CALL CHKXER( 'ZGBEQU', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGBEQU( 1, 1, -1, 0, A, 1, R1, R2, RCOND, CCOND, ANRM,
     $                INFO )
         CALL CHKXER( 'ZGBEQU', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGBEQU( 1, 1, 0, -1, A, 1, R1, R2, RCOND, CCOND, ANRM,
     $                INFO )
         CALL CHKXER( 'ZGBEQU', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZGBEQU( 2, 2, 1, 1, A, 2, R1, R2, RCOND, CCOND, ANRM,
     $                INFO )
         CALL CHKXER( 'ZGBEQU', INFOT, NOUT, LERR, OK )
      END IF
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of ZERRGE
*
      END
