(* pairs is the number of couples (rational function,costant) *)

pairs=1;

(* prec is the precision to be used in the computation *)

prec=16;

(* eps is the precision to be used in computing if two zeros are different
or not *)

eps=10^(-8);


(* rf is an array containing the rational functions;it ALWAYS starts from
index  1 *)
(* The following is the stability function of the Runge--Kutta--Nystrom  
 method (4.3) of the paper
 Van der Houwen P.J., Sommeijer B.P.
   Diagonally implicit Runge--Kutta Nystr\"om methods for oscillatory
   problems,  SIAM J. Num. Anal.26, 414--429, 1989. 
  having the following Butcher array

        1/2  |  1/12-Sqrt[15]/60       0
             |
        1/2  |  Sqrt[15]/60          1/12-Sqrt[15]/60
             |
       _________________________________________________
             |        0                  1/2
             |        0                  1
        *)



rf[1] = (-2*(360 - 120*z - 12*Sqrt[15]*z - 11*z^2 + 5*Sqrt[15]*z^2))/
  (-360 - 60*z + 12*Sqrt[15]*z - 4*z^2 + Sqrt[15]*z^2)


(* cv is an array containing the constants values; it ALWAYS starts from
index 1 *)

cv[1]=2;


(* printing = 1 enable plotting the graph of the intervals of stability;  *)
(* printing = 0 disable plotting the graph of the intervals of stability;  *)
(* if the computation ends up with an unlimited interval, the graph is not
plotted  *)
(* the intervals ranges are printed anyway  *)



printing = 1;

(* the height  is a value such that the line y = height is the last line
used when plotting *)
(* the stability intervals; of course may be that the user chooses a value
which is     *)
(* lower than the actual maximum of the rational functions
            *)

height = 5;

(* stepx is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value *)
(* will produce a slower but more accurate plot *)

stepx = 0.2;

(* stepy is the step along the x axe to be used when plotting; an higher
value *)
(* will produce a faster but less accurate plot, a lower value  *)
(* will produce a slower but more accurate plot *)


stepy = 0.2;


