c Primal-dual method with supernodal cholesky factorization
c               Version 2.11 (1996 December)
c  Written by Cs. Meszaros, MTA SzTAKI, Budapest, Hungary
c        Questions, remarks to the e-mail address:
c               meszaros@lutra.sztaki.hu
c
c  All rights reserved ! Free for academic and research use only !
c  Commercial users are required to purchase a software license.
c
c Related publications:
c
c    Meszaros, Cs.: Fast Cholesky Factorization for Interior Point Methods
c       of Linear Programming. Computers & Mathematics with Applications,
c       Vol. 31. No.4/5 (1996) pp. 49-51.
c
c    Meszaros, Cs.: The "inexact" minimum local fill-in ordering algorithm.
c       Working Paper WP 95-7, Computer and Automation Institute, Hungarian
c       Academy of Sciences
c
c    Maros I., Meszaros Cs.: The Role of the Augmented System in Interior
c       Point Methods.  European Journal of Operations Researches
c       (submitted)
c
c
c It is the main of the code.
c Here you can change the ammount of memory used by the program
c by setting the parameter relmxx. The total amount of memory
c used is then (14*relmxx) bytes. For example, in  64 Mbyte
c systems set relmxx=4500000.
c
c
c ===========================================================================
c
      program bpmain
c
      integer*4 relmxx,intmxx
      parameter (relmxx=    12500000)
      parameter (intmxx = 1.5*relmxx)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 intmax,relmax,fixn,dropn
      integer*4 intmap(25),relmap(25)
      integer*4 code,iter,corect
      real*8    realmem(relmxx),opt,addobj
      integer*4 intmem(intmxx)
      integer*4 infile,oufile,sfile,outlev,fnzmax,fnzmin,nn,minmax
      character*99 buff
      real*8    bigbou,big
      character*8 objnam
      integer*4 t1,t2,tf
c
      common/bigarray/ realmem,intmem
c
      common/factor/ tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
      real*8         tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
c
      common/sprnod/ psupn,ssupn,maxsnz
      integer*4      psupn,ssupn,maxsnz
c
      common/toler/ tsdir,topt1,topt2,tfeas1,tfeas2,feas1,feas2,
     x              pinfs,dinfs,inftol,maxiter
      real*8        tsdir,topt1,topt2,tfeas1,tfeas2,feas1,feas2,
     x              pinfs,dinfs,inftol
      integer*4     maxiter
c
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c
      common/itref/ tresx,tresy,maxref
      real*8        tresx,tresy
      integer*4     maxref
c
      common/ascal/ objnor,rhsnor,scdiff,scpass,scalmet
      real*8        objnor,rhsnor,scdiff
      integer*4     scpass,scalmet
c
      common/predp/ ccstop,barset,bargrw,barmin,mincor,maxcor,inibar
      real*8        ccstop,barset,bargrw,barmin
      integer*4     mincor,maxcor,inibar

      common/predc/ target,tsmall,tlarge,center,corstp,mincc,maxcc
      real*8        target,tsmall,tlarge,center,corstp
      integer*4     mincc,maxcc
c
      common/param/ palpha,dalpha
      real*8        palpha,dalpha
c
      common/drop/  tfixvar,tfixslack,slklim
      real*8        tfixvar,tfixslack,slklim
c
      common/initv/ prmin,upmax,dumin,stamet,safmet,premet,regul
      real*8        prmin,upmax,dumin
      integer*4     stamet,safmet,premet,regul
c
      common/mscal/ varadd,slkadd,scfree
      real*8        varadd,slkadd,scfree
c
      common/setden/ maxdense,densgap,setlam,denslen
      real*8         maxdense,densgap
      integer*4      setlam,denslen
c
      common/compl/ climit,ccorr
      real*8        climit,ccorr
c
      common/timex/ act
      integer*4     act
c
      common/logprt/ loglog,lfile
      integer*4      loglog,lfile


      act=0
      big=1.0d+30
c
c toleranciak es parameterek
c
      maxdense  = 0.15d+0
      densgap   = 3.00d+0
      setlam    = 0
      supdens   = 250.0d+0
      denslen   = 10
c
      varadd    = 1.0d-12
      slkadd    = 1.0d+16
      scfree    = 1.1d-06
c
      tpiv1     = 1.0d-03
      tpiv2     = 1.0d-08
      tabs      = 1.0d-12
      trabs     = 1.0d-15
      lam       = 1.0d-05
      tfind     = 25.0d+0
      order     = 2.0d+0
c
      psupn     =  3
      ssupn     =  4
      maxsnz    = 9999999
c
      tsdir     = 1.0d-16
      topt1     = 1.0d-08
      topt2     = 1.0d-16
      tfeas1    = 1.0d-07
      tfeas2    = 1.0d-07
      feas1     = 1.0d-02
      feas2     = 1.0d-02
      pinfs     = 1.0d-06
      dinfs     = 1.0d-06
      inftol    = 1.0d+04
      maxiter   = 99
c
      tplus     = 1.0d-11
      tzer      = 1.0d-35
c
      tresx     = 1.0d-09
      tresy     = 1.0d-09
      maxref    = 5
c
      objnor    = 1.0d+2
      rhsnor    = 0.0d+0
      scdiff    = 1.0d+0
      scalmet   = 2
      scpass    = 5
c
      ccstop    = 1.01d+00
      barset    = 2.50d-01
      bargrw    = 1.00d+02
      barmin    = 1.00d-10
      mincor    = 1
      maxcor    = 1
      inibar    = 0
c
      target    = 9.0d-02
      tsmall    = 2.0d-01
      tlarge    = 2.0d+01
      center    = 5.0d+00
      corstp    = 1.01d+00
      mincc     = 0
      maxcc     = 9
c
      palpha    = 0.999d+0
      dalpha    = 0.999d+0
c
      tfixvar   = 1.0d-16
      tfixslack = 1.0d-16
      slklim    = 1.0d-16
c
      prmin    =   100.0d+0
      upmax    = 50000.0d+0
      dumin    =   100.0d+0
      stamet   = 2
      safmet   =-3
      premet   = 511
      regul    = 0
c
      climit   = 1.0d-00
      ccorr    = 1.0d-05
c
      intmax=intmxx
      relmax=relmxx
      infile=25
      oufile=26
      sfile =27
      lfile =29
      loglog= 1
      outlev= 0
c
      write(*,'(1x)')
      write(*,'(30x,a)')'BPMPD Version 2.11'
      write(*,'(17x,a)')'Written by Cs. Meszaros, MTA SzTAKI, Budapest'
      write(*,'(1x)')
c
      call finput (intmap,relmap,realmem,intmem,infile,oufile,intmax,
     x relmax,addobj,outlev,bigbou,big,nn,sfile,minmax,objnam)
      n1=n+1
c
      call timer(t1)
      call solver(
     x realmem(relmap( 1)),realmem(relmap( 2)),realmem(relmap( 3)),
     x realmem(relmap( 4)),realmem(relmap( 5)),realmem(relmap( 6)),
     x realmem(relmap( 7)),realmem(relmap( 8)),realmem(relmap( 9)),
     x realmem(relmap(10)),realmem(relmap(11)),realmem(relmap(12)),
     x realmem(relmap(13)),realmem(relmap(14)),realmem(relmap(15)),
     x realmem(relmap(16)),realmem(relmap(17)),realmem(relmap(18)),
     x realmem(relmap(19)),realmem(relmap(20)),realmem(relmap(21)),
     x realmem(relmap(22)),realmem(relmap(23)),realmem(relmap(24)),
     x intmem(intmap( 1)),intmem(intmap( 2)),intmem(intmap( 3)),
     x intmem(intmap( 4)),intmem(intmap( 5)),intmem(intmap( 6)),
     x intmem(intmap( 7)),intmem(intmap( 8)),intmem(intmap( 9)),
     x intmem(intmap(10)),intmem(intmap(11)),intmem(intmap(12)),
     x intmem(intmap(13)),intmem(intmap(14)),
     x code,opt,iter,corect,fixn,dropn,fnzmax,fnzmin,addobj,
     x bigbou,big,tf)
      call timer(t2)
      t1=t2-t1
c
c
c
      call mpsout(m,nn,nz,oufile,sfile,code,opt,
     x realmem(relmap(5)),realmem(relmap(6)),realmem(relmap(4)+nn),
     x realmem(relmap(3)),realmem(relmap(4)),realmem(relmap(2)),
     x intmem(intmap(2)),realmem(relmap(7)),
     x intmem(intmap(6)),intmem(intmap(6)+n),realmem(relmap(20)),
     x intmem(intmap(3)),intmem(intmap(13)),realmem(relmap(24)),
     x intmem(intmap(11)),intmem(intmap(11)+n),
     x iter,corect,outlev,minmax,big,objnam,t1,tf)
c
c
c
      write(buff,9)
      call mprnt(buff)
      if(code.le.1)then
         write(buff,5)
         call mprnt(buff)
      else if(code.eq.2)then
         write(buff,6)opt
         call mprnt(buff)
      else if(code.eq.3)then
         write(buff,7)
         call mprnt(buff)
      else if(code.eq.4)then
         write(buff,8)
         call mprnt(buff)
      endif
c
    5 format(1x,'Execution stopped.')
    6 format(1x,'OPTIMAL SOLUTION.       OBJECTIVE  =',d18.10)
    7 format(1x,'Problem is dual infeasibile (or badly scaled).')
    8 format(1x,'Problem is primal infeasibile (or badly scaled).')
    9 format(1x)
   10 format(1x,'TOTAL SOLUTION TIME  =',F12.2,' sec.')
      write(buff,9)
      opt=dble(t1)
      write(buff,10)(opt/100.0d+0)
      call mprnt(buff)
      close(oufile)
      stop
      end
