c Primal-dual method with supernodal cholesky factorization
c               Version 2.11 (1996 December)
c  Written by Cs. Meszaros, MTA SzTAKI, Budapest, Hungary
c           e-mail: meszaros@lutra.sztaki.hu
c                      see "bpmain.f"
c
c code=-2 General memory limit (no solution)
c code=-1 Memory limit during iterations
c code= 0
c code= 1 No optimum
c code= 2 Otimal solution
c code= 3 Primal Infeasible
c code= 4 Dual Infeasible
c
c ===========================================================================
c
      subroutine phas12(
     x obj,rhs,bounds,diag,odiag,xs,dxs,dxsn,up,dspr,ddspr,
     x ddsprn,dsup,ddsup,ddsupn,dv,ddv,ddvn,nonzeros,prinf,upinf,duinf,
     x vartyp,slktyp,colpnt,ecolpnt,count,vcstat,pivots,invprm,
     x snhead,nodtyp,inta1,rowidx,rindex,
     x rwork1,iwork1,iwork2,iwork3,iwork4,iwork5,
     x code,opt,iter,corect,fixn,dropn,active,fnzmax,fnzmin,addobj,
     x scobj,factim,mn2)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      common/mscal/ varadd,slkadd,scfree
      real*8        varadd,slkadd,scfree
c
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c
      common/param/ palpha,dalpha
      real*8        palpha,dalpha
c
      common/factor/ tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
      real*8         tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
c
      common/toler/ tsdir,topt1,topt2,tfeas1,tfeas2,feas1,feas2,
     x              pinfs,dinfs,inftol,maxiter
      real*8        tsdir,topt1,topt2,tfeas1,tfeas2,feas1,feas2,
     x              pinfs,dinfs,inftol
      integer*4     maxiter
c
      common/initv/ prmin,upmax,dumin,stamet,safmet,premet,regul
      real*8        prmin,upmax,dumin
      integer*4     stamet,safmet,premet,regul
c
      integer*4 fixn,dropn,active,code,iter,corect,fnzmin,fnzmax,mn2
      real*8  addobj,scobj,opt
c
      common/predp/ ccstop,barset,bargrw,barmin,mincor,maxcor,inibar
      real*8        ccstop,barset,bargrw,barmin
      integer*4     mincor,maxcor,inibar
c
      common/predc/ target,tsmall,tlarge,center,corstp,mincc,maxcc
      real*8        target,tsmall,tlarge,center,corstp
      integer*4     mincc,maxcc

      common/itref/ tresx,tresy,maxref
      real*8        tresx,tresy
      integer*4     maxref
c
      real*8 obj(n),rhs(m),bounds(mn),diag(mn),odiag(mn),xs(mn),
     x dxs(mn),dxsn(mn),up(mn),dspr(mn),ddspr(mn),ddsprn(mn),dsup(mn),
     x ddsup(mn),ddsupn(mn),dv(m),ddv(m),ddvn(m),nonzeros(cfree),
     x prinf(m),upinf(mn),duinf(mn),rwork1(mn)

      integer*4 vartyp(n),slktyp(m),colpnt(n1),ecolpnt(mn),count(mn),
     x vcstat(mn),pivots(mn),invprm(mn),snhead(mn),nodtyp(mn),
     x inta1(mn),rowidx(cfree),rindex(rfree),factim,
     x iwork1(mn2),iwork2(mn2),iwork3(mn2),iwork4(mn2),iwork5(mn2)
c
c ---------------------------------------------------------------------------
c
      integer*4 i,j,err,factyp,pphase,dphase,t1,t2,opphas,odphas
      real*8 pinf,dinf,uinf,prelinf,drelinf,popt,dopt,cgap,
     x prstpl,dustpl,barpar,oper,maxstp,pinfrd,dinfrd,objerr,nonopt,
     x oprelinf,odrelinf,opinf,odinf,ocgap
      integer*4 corr,corrc,barn,fxp,fxd,fxu,nropt
      character*99 buff,sbuff
      character*1 wmark
c
c to save parameters
c
      integer*4 maxcco,mxrefo
      real*8 lamo,spdeno,bargro,topto
c
c --------------------------------------------------------------------------
c
 101  format(1x,' ')
 102  format(1x,'It-PC   P.Inf   D.Inf  U.Inf   Actions           ',
     x 'P.Obj           D.Obj  Barpar')
 103  format(1x,'------------------------------------------------',
     x '------------------------------')
 104  format(1x,I2,a1,I1,I1,' ',1PD7.1,' ',1PD7.1,' ',1PD6.0,
     x ' ',I2,' ',I3,' ',I3,' ',1PD15.8,' ',1PD15.8,' ',1PD6.0)
c
c Saving parameters
c
      maxcco=maxcc
      mxrefo=maxref
      lamo=lam
      spdeno=supdens
      bargro=bargrw
      topto=topt1
c
c Include dummy ranges if requested
c
      if(regul.gt.0)then
        do i=1,m
          if(slktyp(i).eq.0)then
            slktyp(i)=-1
            bounds(i+n)=0.0d+0
          endif
        enddo
      endif
c
c Other initialization
c
      nropt=0
      factim=0
      wmark='-'
      fxp=0
      fxd=0
      fxu=0
c
      call stlamb(colpnt,vcstat,rowidx,inta1,fixn,dropn,factyp)
      call timer(t1)
      j=0
      do i=1,n
        if((vcstat(i).gt.-2).and.(vartyp(i).eq.0))j=j+1
      enddo
      if((j.gt.0).and.(scfree.lt.tzer))factyp=1
c
c Initial scaling matrix (diagonal)
c
      call fscale (vcstat,diag,odiag,vartyp,slktyp)
      do i=1,m
        dv(i)=0.0d+0
      enddo

ccc      i=2*rfree
ccc      j=400
ccc      call paintmat(m,n,nz,i,rowidx,colpnt,rindex,j,'matrix01.pic')

c
c Initial factorization
c
      fnzmax=0
      if(factyp.eq.1)then
        call ffactor(ecolpnt,vcstat,colpnt,rowidx,
     x  iwork4,pivots,count,nonzeros,diag,
     x  iwork1,iwork1(mn+1),iwork2,iwork2(mn+1),inta1,iwork5,
     x  iwork5(mn+1),iwork3,iwork3(mn+1),iwork4(mn+1),rindex,
     x  rwork1,fixn,dropn,fnzmax,fnzmin,active,oper,xs,slktyp,code)
        if(code.ne.0)goto 999
        call supnode(ecolpnt,count,rowidx,vcstat,pivots,snhead,
     x  invprm,nodtyp)
      else
c
c minimum local fill-in ordering
c
        i=int(tfind)
        if(order.lt.1.5)i=0
        if(order.lt.0.5)i=-1
        call symmfo(inta1,pivots,ecolpnt,vcstat,
     x  colpnt,rowidx,nodtyp,rindex,iwork3,invprm,
     x  count,snhead,iwork1,iwork1(mn+1),iwork2,iwork2(mn+1),
     x  iwork4,iwork4(mn+1),iwork3(mn+1),iwork5,iwork5(mn+1),
     x  nonzeros,fnzmax,oper,i,rwork1,code)
        if(code.ne.0)goto 999
        call supnode(ecolpnt,count,rowidx,vcstat,pivots,snhead,
     x  invprm,nodtyp)
        popt=trabs
        trabs=tabs
        call nfactor(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,err,rwork1,iwork2,iwork2(mn+1),dropn,slktyp,
     x  snhead,iwork3,invprm,nodtyp,dv,odiag)
        trabs=popt
      endif
      fnzmin=fnzmax
c
c Compute centrality and iterative refinement power
c
      if(fnzmin.eq.0)fnzmin=1
      cgap=oper/fnzmin/10.0d+0
      j=0
  78  if(cgap.ge.1.0d+0)then
        cgap=cgap/2
        j=j+1
        goto 78
      endif
      if(j.eq.0)j=1
      if(maxcc.le.0d+0)then
        maxcc=-maxcc
      else
        if(j.le.maxcc)maxcc=j
      endif
      if(mincc.gt.maxcc)maxcc=mincc
      cgap=log(1.0d+0+oper/fnzmin/5.0d+0)/log(2.0d+00)
      if(maxref.le.0)then
        maxref=-maxref
      else
        maxref=int(cgap*maxref)
      endif
      if(maxref.le.0)maxref=0
      write(buff,'(1x,a,i2)')'Centrality correction Power:',maxcc
      call mprnt(buff)
      write(buff,'(1x,a,i2)')'Iterative refinement  Power:',maxref
      call mprnt(buff)
c
c Starting point
c
      call initsol(xs,up,dv,dspr,dsup,rhs,obj,bounds,vartyp,slktyp,
     x vcstat,colpnt,ecolpnt,pivots,rowidx,nonzeros,diag,rwork1,
     x count)
      call timer(t2)
c
      write(buff,'(1x,a,f12.2,a)')'FIRSTFACTOR TIME :',
     x (dble(t2-t1)*0.01d+0),' sec'
      call mprnt(buff)
c
      maxstp=1.0d+0
      iter=0
      corect=0
      corr=0
      corrc=0
      barn=0
      cgap=0.0d+0
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.ne.0)then
            cgap=cgap+xs(i)*dspr(i)
            barn=barn+1
          endif
          if(j.lt.0)then
            cgap=cgap+up(i)*dsup(i)
            barn=barn+1
          endif
        endif
      enddo
      if(barn.lt.1)barn=1

ccc      i=2*rfree
ccc      j=350
ccc      call paintaat(mn,nz,pivotn,i,rowidx,ecolpnt,count,rindex,
ccc     x j,pivots,iwork1,iwork1(mn+1),iwork2,iwork2(mn+1),iwork3,
ccc     x iwork3(mn+1),'normal01.pic')

ccc      i=2*rfree
ccc      j=400
ccc      call paintata(mn,nz,pivotn,i,rowidx,ecolpnt,count,rindex,
ccc     x j,pivots,iwork1,iwork1(mn+1),iwork2,iwork2(mn+1),iwork3,
ccc     x 'atapat01.pic')


ccc      i=2*rfree
ccc      j=350
ccc      err=nz
ccc      call paintfct(mn,cfree,pivotn,i,rowidx,ecolpnt,count,rindex,
ccc     x j,pivots,iwork2,err,'factor01.pic')
c
c Initialize for the iteration loop
c
      do i=1,n
        if((vcstat(i).gt.-2).and.(vartyp(i).ne.0))then
          if(xs(i).gt.dspr(i))then
            vcstat(i)=1
          else
            vcstat(i)=0
          endif
        endif
      enddo
      do i=1,m
        if((vcstat(i+n).gt.-2).and.(slktyp(i).ne.0))then
          if(xs(i+n).gt.dspr(i+n))then
            vcstat(i+n)=1
          else
            vcstat(i+n)=0
          endif
        endif
      enddo
      opphas=0
      odphas=0
      pinfrd=1.0d+0
      dinfrd=1.0d+0
      barpar=0.0d+0
c
c main iteration loop
c
  10  if(mod(iter,20).eq.0)then
        write(buff,101)
        call mprnt(buff)
        write(buff,102)
        call mprnt(buff)
        write(buff,103)
        call mprnt(buff)
      endif
c
c Infeasibilities
c
      call cprinf(xs,prinf,slktyp,colpnt,rowidx,nonzeros,
     x rhs,vcstat,pinf)
      call cduinf(dv,dspr,dsup,duinf,vartyp,slktyp,colpnt,rowidx,
     x nonzeros,obj,vcstat,dinf)
      call cupinf(xs,up,upinf,bounds,vartyp,slktyp,vcstat,
     x uinf)
c
c Objectives
c
      call cpdobj(popt,dopt,obj,rhs,bounds,xs,dv,dsup,
     x vcstat,vartyp,slktyp)
      popt=scobj*popt+addobj
      dopt=scobj*dopt+addobj
c
c Stopping criteria
c
      call stpcrt(prelinf,drelinf,popt,dopt,cgap,iter,
     x code,pphase,dphase,maxstp,pinf,uinf,dinf,
     x prinf,upinf,duinf,nonopt,pinfrd,dinfrd,
     x prstpl,dustpl,obj,rhs,bounds,xs,dxs,dspr,ddspr,dsup,ddsup,dv,ddv,
     x up,addobj,scobj,vcstat,vartyp,slktyp,
     x oprelinf,odrelinf,opinf,odinf,ocgap,opphas,odphas,sbuff)
c
      write(buff,104)iter,wmark,corr,corrc,pinf,dinf,uinf,fxp,fxd,fxu,
     x popt,dopt,barpar
      call mprnt(buff)
      if(code.ne.0)then
        write(buff,'(1x)')
        call mprnt(buff)
        call mprnt(sbuff)
        goto 90
      endif
c
c P-D solution modification
c
      call pdmodi(xs,dspr,vcstat,vartyp,slktyp,cgap,popt,
     x dopt,prinf,duinf,upinf,colpnt,rowidx,nonzeros,pinf,uinf,dinf)
c
c Fixing variables / dropping rows / handling dual slacks
c
      i=fixn
      call varfix(vartyp,slktyp,rhs,colpnt,rowidx,nonzeros,
     x xs,up,dspr,dsup,vcstat,fixn,dropn,addobj,scobj,obj,bounds,
     x duinf,dinf,fxp,fxd,fxu)
      if(fixn.ne.i)then
        call supupd(pivots,invprm,snhead,nodtyp,vcstat,ecolpnt)
        call cprinf(xs,prinf,slktyp,colpnt,rowidx,nonzeros,
     x  rhs,vcstat,pinf)
        call cupinf(xs,up,upinf,bounds,vartyp,slktyp,vcstat,
     x  uinf)
      endif
c
c Compute gap
c
      cgap=0.0d+0
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.ne.0)then
            cgap=cgap+xs(i)*dspr(i)
            if(j.lt.0)then
              cgap=cgap+up(i)*dsup(i)
            endif
          endif
        endif
      enddo
c
c Computation of the scaling matrix
c
      objerr=abs(dopt-popt)/(abs(popt)+1.0d+0)
      call cdiag(xs,up,dspr,dsup,vartyp,slktyp,vcstat,diag,odiag)
      pinfrd=pinf
      dinfrd=dinf
c
c The actual factorization
c
  50  err=0
      call timer(t1)
      if (factyp.eq.1) then
        call mfactor(ecolpnt,vcstat,colpnt,rowidx,pivots,
     x  count,iwork4,nonzeros,diag,err,rwork1,iwork2,iwork2(mn+1),
     x  dropn,slktyp,snhead,iwork3,invprm,nodtyp,dv,odiag)
      else
        call nfactor(ecolpnt,vcstat,rowidx,pivots,count,nonzeros,
     x  diag,err,rwork1,iwork2,iwork2(mn+1),dropn,slktyp,
     x  snhead,iwork3,invprm,nodtyp,dv,odiag)
      endif
      call timer(t2)
      if(err.gt.0)then
        do i=1,mn
          diag(i)=odiag(i)
        enddo
        call newsmf(colpnt,pivots,rowidx,nonzeros,ecolpnt,count,
     x  vcstat,invprm,snhead,nodtyp,iwork1,rwork1,iwork2,iwork3,
     x  iwork4,code)
        if(code.lt.0)then
          write(buff,'(1x)')
          call mprnt(buff)
          goto 90
        endif
        goto 50
      endif
      factim=factim+t2-t1
c
c We are in the finish ?
c
      wmark(1:1)='-'
      if(objerr.gt.1.0d+0)objerr=1.0d+0
      if(objerr.lt.topt1)objerr=topt1
      if((objerr.le.topt1*10.0d+0).and.(pphase+dphase.eq.4))then
         if(bargrw.gt.0.1d+0)bargrw=0.1d+0
         nropt=nropt+1
         if(nropt.eq.5)then
           nropt=0
           topt1=topt1*sqrt(10.d+0)
           write(buff,'(1x,a)')'Near otptimal but slow convergence.'
           call mprnt(buff)
         endif
         wmark(1:1)='+'
      endif
c
c primal-dual predictor-corrector direction
c
      call  cpdpcd(xs,up,dspr,dsup,prinf,duinf,upinf,
     x dxsn,ddvn,ddsprn,ddsupn,dxs,ddv,ddspr,ddsup,bounds,
     x ecolpnt,count,pivots,vcstat,diag,odiag,rowidx,nonzeros,
     x colpnt,vartyp,slktyp,barpar,corr,prstpl,dustpl,barn,cgap)
      corect=corect+corr
c
c primal-dual centality-correction
c
      call  cpdccd(xs,up,dspr,dsup,upinf,
     x dxsn,ddvn,ddsprn,ddsupn,dxs,ddv,ddspr,ddsup,bounds,
     x ecolpnt,count,pivots,vcstat,diag,odiag,rowidx,nonzeros,
     x colpnt,vartyp,slktyp,barpar,corrc,prstpl,dustpl)
      corect=corect+corrc
c
c compute steplengths
c
      iter=iter+1
      prstpl=prstpl*palpha
      dustpl=dustpl*dalpha
c
c compute the new primal-dual solution
c
      call cnewpd(prstpl,xs,dxs,up,upinf,dustpl,dv,ddv,dspr,
     x ddspr,dsup,ddsup,vartyp,slktyp,vcstat,maxstp)
c
c End main loop
c
      goto 10
c
 90   opt=(dopt-popt)/(abs(popt)+1.0d+0)
      write(buff,'(1x,a,1PD11.4,a,1PD18.10)')
     x 'ABSOLUTE infeas.   Primal  :',pinf,   '    Dual         :',dinf
      call mprnt(buff)
      write(buff,'(1x,a,1PD11.4,a,1PD18.10)')
     x 'PRIMAL :  Relative infeas. :',prelinf,'    Objective    :',popt
      call mprnt(buff)
      write(buff,'(1x,a,1PD11.4,a,1PD18.10)')
     x 'DUAL   :  Relative infeas. :',drelinf,'    Objective    :',dopt
      call mprnt(buff)
      write(buff,'(1x,a,1PD11.4,a,1PD18.10)')
     x 'Complementarity gap        :',cgap,'    Duality gap  :',opt
      call mprnt(buff)
      opt=popt
c
c Restoring parameters
c
 999  maxcc=maxcco
      maxref=mxrefo
      lam=lamo
      supdens=spdeno
      bargrw=bargro
      topt1=topto
      return
      end
c
c ===========================================================================
