c Compute primal, upper, dual infeasibilities
c ===========================================================================
c
       subroutine cprinf(xs,prinf,slktyp,colpnt,rowidx,nonzeros,
     x  rhs,vcstat,pinf)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 slktyp(m),colpnt(n1),rowidx(nz),vcstat(mn)
      real*8    xs(mn),prinf(m),rhs(m),nonzeros(nz),pinf
c
      integer*4 i,j,pnt1,pnt2
      real*8 sol
c
c ---------------------------------------------------------------------------
c
      do i=1,m
        prinf(i)=rhs(i)
      enddo
      pinf=0.0D+0     
c
      do i=1,n
        if(vcstat(i).gt.-2)then
          sol=xs(i)
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            prinf(rowidx(j)-n)=prinf(rowidx(j)-n)-sol*nonzeros(j)
          enddo
        endif
      enddo
      do i=1,m
        if(vcstat(i+n).gt.-2)then
          if(slktyp(i).ne.0)then
            sol=prinf(i)+xs(i+n)            
          else
            sol=prinf(i)
          endif
        else
          sol=0.0d+0
        endif
        prinf(i)=sol
        if(pinf.lt.abs(sol))pinf=abs(sol)               
      enddo
      return
      end
c
c ===========================================================================
c
      subroutine cupinf(xs,up,upinf,bounds,vartyp,slktyp,vcstat,
     x uinf)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 vartyp(n),slktyp(m),vcstat(mn)
      real*8 xs(mn),up(mn),upinf(mn),bounds(mn),uinf
c
      integer*4 i
c
      do i=1,mn
        upinf(i)=0.0d+0
      enddo
      uinf=0.0d+0
      do i=1,n
        if((vcstat(i).gt.-2).and.(vartyp(i).lt.0))then         
          upinf(i)=bounds(i)-xs(i)-up(i)
          if(uinf.lt.abs(upinf(i)))uinf=abs(upinf(i))
        endif
      enddo
      do i=1,m
        if((vcstat(i+n).gt.-2).and.(slktyp(i).lt.0))then          
          upinf(i+n)=bounds(i+n)-xs(i+n)-up(i+n)
          if(uinf.lt.abs(upinf(i+n)))uinf=abs(upinf(i+n))
        endif
      enddo
      return
      end
c
c ============================================================================
c
      subroutine cduinf(dv,dspr,dsup,duinf,vartyp,slktyp,colpnt,
     x rowidx,nonzeros,obj,vcstat,dinf)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 vartyp(n),slktyp(m),colpnt(n1),rowidx(nz),
     x vcstat(mn)
      real*8 dv(m),dspr(mn),dsup(mn),duinf(mn),nonzeros(nz),obj(n),
     x dinf
c
      integer*4 i,j,pnt1,pnt2
      real*8 sol
c
c ------------------------------------------------------------------------------
c
      dinf=0.0d+0
c
      do i=1,m
        sol=0.0d+0
        if(vcstat(i+n).gt.-2)then
          if(slktyp(i).gt.0)then
            sol=dv(i)-dspr(i+n)
          else if(slktyp(i).lt.0)then
            sol=dv(i)-dspr(i+n)+dsup(i+n)
          endif
        endif
        duinf(i+n)=sol
      enddo
c
      do i=1,n
        sol=0.0d+0
        if(vcstat(i).gt.-2)then
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if(vcstat(rowidx(j)).gt.-2)then
              sol=sol+dv(rowidx(j)-n)*nonzeros(j)
            endif
          enddo
          if(vartyp(i))10,11,12
c
c Upper bounded variable
c
  10      sol=obj(i)-sol-dspr(i)+dsup(i)
          goto 15
c
c Free variable
c
  11      sol=obj(i)-sol
          goto 15
c
c Standard variable
c
  12      sol=obj(i)-sol-dspr(i)
        endif
  15    duinf(i)=sol        
      enddo
c
c Compute absolute and relative infeasibility
c
      do i=1,mn
        sol=abs(duinf(i))
        if(dinf.lt.sol)dinf=sol
      enddo
c
      return
      end
c
c ==============================================================================
c
      subroutine cpdobj(popt,dopt,obj,rhs,bounds,xs,dv,
     x dsup,vcstat,vartyp,slktyp)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 vcstat(mn),vartyp(n),slktyp(m)
      real*8  popt,dopt,obj(n),rhs(m),bounds(mn),xs(mn),dv(m),dsup(mn)
c
      integer*4 i
c
      popt=0.0d+0
      dopt=0.0d+0
      do i=1,n
        if(vcstat(i).gt.-2)then
          popt=popt+obj(i)*xs(i)
          if(vartyp(i).lt.0)then
            dopt=dopt-bounds(i)*dsup(i)
          endif
        endif
      enddo
      do i=1,m
        if(vcstat(i+n).gt.-2)then
          dopt=dopt+rhs(i)*dv(i)
          if(slktyp(i).lt.0)then
            dopt=dopt-bounds(i+n)*dsup(i+n)
          endif
        endif
      enddo      
      return
      end
c
c ===========================================================================
