c Minimum local fill-in ordering
c
c ===========================================================================
c
      subroutine genmfo(m,mn,nz,cfree,rfree,pivotn,
     x pntc,ccol,permut,pntr,crow,rowidx,
     x mark,cpermf,cpermb,rpermf,rpermb,cfill,rfill,cpnt,
     x cnext,cprew,suplst,fillin,colidx,tfind,noddeg,supdeg,code)
c
      integer*4 m,mn,nz,cfree,rfree,pivotn,rowidx(cfree),colidx(rfree),
     x permut(m),cpermf(m),cpermb(m),rpermf(m),rpermb(m),
     x ccol(m),crow(m),pntc(m),pntr(m),mark(m),cfill(m),cpnt(m),
     x cnext(m),cprew(m),rfill(m),suplst(m),fillin(m),tfind,
     x noddeg(m),supdeg(m),code
      character*99 buff
c
c ---------------------------------------------------------------------------
c INPUT PARAMETERS
c
c  m       number of rows
c  mn      an number greather than m
c  nz      last used position of the column file
c  cfree   length of the column file (column file is used from nz+1 to cfree)
c  rfree   length of the row file (row file is used from 1 to rfree)
c  rowidx  column file (containing the lower tiriangular part of AAT)
c  colidx  row file
c  pntc    pointer to the columns of the lower diagonal of AAT
c  ccol    column lengths of AAT
c  crow    if crow(i)<-1 row i is removed from the ordering
c  tfind   search loop,  tfind=0 gives the minimum degree ordering
c          suggested value tfind=25
c
c
c OUTPUT PARAMETERS
c permut   the ordering
c pivotn   Number of ordered nodes
c
c
c Others: Integer working arrays of size m
c
c
c --------------------------------------------------------------------------
      integer*4 pnt,pnt1,pnt2,i,j,k,l,o,p,endmem,ccfree,rcfree,pmode,
     x rfirst,rlast,cfirst,clast,pcol,pcnt,ppnt1,ppnt2,fill,prewcol,
     x ii,mm,mfill,supnd,hsupnd,oo,nnz,fnd,oldpcol,q,fl
c---------------------------------------------------------------------------
c
   1  format(' NOT ENOUGH MEMORY IN THE ROW    FILE ')
   2  format(' NOT ENOUGH MEMORY IN THE COLUMN FILE ')
   3  format(' Analyse for supernodes in aat    :',i9,' col')
   4  format(' Final supernodal columns disabled:',i9,' col')
   5  format(' Hidden supernodal columns        :',i9,' col')

c
c initialization
c
      code=0
      endmem=cfree
      pivotn=0
      pmode =0
      do i=1,m
        permut(i)=0
        suplst(i)=0
        fillin(i)=-1
        supdeg(i)=1
        if(crow(i).gt.-2)then
          crow(i)=0
        endif
      enddo
c
c Compute crow
c
      do 10 i=1,m
        if(crow(i).le.-2)goto 10
        pnt1=pntc(i)
        pnt2=pnt1+ccol(i)-1
        do j=pnt1,pnt2
          crow(rowidx(j))=crow(rowidx(j))+1
        enddo
        clast=i
  10  continue
      cpermf(clast)=0
      ccfree=cfree-pntc(clast)-ccol(clast)
      if(ccfree.lt.mn)then
        write(buff,2)
        call mprnt(buff)
        code=-2
        goto 999
      endif
c
c create pointers to colidx
c
      do i=1,m
        cprew(i)=0
      enddo
      pnt=1
      do i=1,m
        if(crow(i).ge.0)then
          pntr(i)=pnt
          rfill(i)=pnt
          pnt=pnt+crow(i)
        endif
      enddo
      rcfree=rfree-pnt
      if(rcfree.lt.mn)then
        write(buff,1)
        call mprnt(buff)
        code=-2
        goto 999
      endif
c
c create the row file : symbolical transps the matrix, set up noddeg
c
      do i=1,m
        noddeg(i)=ccol(i)+crow(i)
        if(crow(i).ge.0)then
          pnt1=pntc(i)
          pnt2=pnt1+ccol(i)-1
          do j=pnt1,pnt2
            k=rowidx(j)
            colidx(rfill(k))=i
            rfill(k)=rfill(k)+1
          enddo
        endif
      enddo
c
c Search supernodes
c
      hsupnd=0
      supnd=0
      do i=1,m
        if(crow(i).ge.0)then
          pnt1=pntr(i)
          pnt2=pnt1+crow(i)-1
          do j=pnt1,pnt2
            mark(colidx(j))=i
          enddo
          mark(i)=i
          pnt1=pntc(i)
          pnt2=pnt1+ccol(i)-1
          do j=pnt1,pnt2
            mark(rowidx(j))=i
          enddo
          p=ccol(i)+crow(i)
 118      if (pnt1.le.pnt2)then
            o=rowidx(pnt1)
            call chknod(m,cfree,rfree,i,o,p,ccol,crow,mark,pntc,
     x      pntr,rowidx,colidx,supdeg,suplst,ii)
            supnd=supnd+ii
            pnt1=pnt1-ii
            pnt2=pnt2-ii
            pnt1=pnt1+1
            goto 118
          endif
        endif
      enddo
      write(buff,3)supnd
      call mprnt(buff)
c
c Set up lists
c
      do i=1,m
        mark(i)=0
        cpnt(i)=0
        cnext(i)=0
      enddo
      cfirst=0
      clast=0
      rfirst=0
      rlast=0
      mm=0
      do i=1,m
        if(crow(i).ge.0)then
          mm=mm+1
          if(cfirst.eq.0)then
            cfirst=i
          else
            cpermf(clast)=i
          endif
          cpermb(i)=clast
          clast=i
c
          if(rfirst.eq.0)then
            rfirst=i
          else
            rpermf(rlast)=i
          endif
          rpermb(i)=rlast
          rlast=i
c
          j=noddeg(i)-supdeg(i)+2
          if(j.gt.0)then
            o=cpnt(j)
            cnext(i)=o
            cpnt(j)=i
            if(o.ne.0)cprew(o)=i
          endif
          cprew(i)=0
        endif
      enddo
      cpermf(clast)=0
      rpermf(rlast)=0
      pcol=0
c
c loop for pivots
c
  50  oldpcol=pcol
      pcol=0
      nnz=1
      if(oldpcol.eq.0)goto 9114
c
c Find supernodal pivot
c
      mfill=0
      k=pntc(oldpcol)
      l=k+ccol(oldpcol)-1
      oo=ccol(oldpcol)-1
9125  if(k.gt.l)goto 9114
      j=rowidx(k)
      if(crow(j)+ccol(j).eq.oo)then
        hsupnd=hsupnd+1
        pcol=j
        goto 9200
      endif
      k=k+1
      goto 9125
c
c Find another pivot
c
9114  pmode=0
      fnd=0
      mfill=-1
9110  j=cpnt(nnz)
      if((j.gt.0).and.(pmode.eq.0))then
        pmode=nnz
        if(tfind.eq.0)then
          pcol=j
          mfill=1
          goto 9200
        endif
      endif
9120  if(j.le.0)goto 9150
      if(fillin(j).ge.0)then
        fill=fillin(j)
        goto 9175
      endif
c
c set up mark and cfill
c
      q=0
      fill=0
      k=pntc(j)
      l=k+ccol(j)-1
      p=0
      do o=k,l
        q=q+1
        cfill(q)=rowidx(o)
        mark(rowidx(o))=supdeg(rowidx(o))
        fill=fill-(supdeg(rowidx(o))*(supdeg(rowidx(o))-1))/2
      enddo
      k=pntr(j)
      l=k+crow(j)-1
      do o=k,l
        q=q+1
        cfill(q)=colidx(o)
        mark(colidx(o))=supdeg(colidx(o))
        fill=fill-(supdeg(colidx(o))*(supdeg(colidx(o))-1))/2
      enddo
c
c compute fill-in
c
      fill=fill+((noddeg(j)-supdeg(j))*(noddeg(j)-supdeg(j)+1))/2
      do p=1,q
        fl=0
        o=cfill(p)
        k=pntc(o)
        l=k+ccol(o)-1
        do oo=k,l
          fl=fl+mark(rowidx(oo))
        enddo
        fill=fill-supdeg(o)*fl
      enddo
c
c administration
c
      do o=1,q
        mark(cfill(o))=0
      enddo
c
c Test
c
      fillin(j)=fill
9175  if(mfill.lt.0)mfill=fill+1
      if(fill.lt.mfill)then
        mfill=fill
        pcol=j
      endif
      fnd=fnd+1
      if((fnd.gt.tfind).or.(mfill.eq.0))goto 9200
      j=cnext(j)
      goto 9120
c
c next bunch
c
9150  nnz=nnz+1
      if(nnz.le.m)goto 9110
9200  if (pcol.eq.0)goto 900
      endmem=cfree
      ccfree=cfree-pntc(clast)-ccol(clast)
      rcfree=rfree-pntr(rlast)-crow(rlast)
c
c compress column file
c
      if(ccfree.lt.mn)then
       call mccmpr(mn,cfree,ccfree,endmem,nz,
     x  pntc,ccol,cfirst,cpermf,rowidx,code)
       if(code.lt.0)goto 999
      endif
c
c remove pcol from the cpermf lists
c
      prewcol=cpermb(pcol)
      o=cpermf(pcol)
      if(prewcol.ne.0)then
        cpermf(prewcol)=o
      else
        cfirst=o
      endif
      if(o.eq.0)then
        clast=prewcol
      else
        cpermb(o)=prewcol
      endif
c
c remove pcol from the rpermf lists
c
      prewcol=rpermb(pcol)
      o=rpermf(pcol)
      if(prewcol.ne.0)then
        rpermf(prewcol)=o
      else
        rfirst=o
      endif
      if(o.eq.0)then
        rlast=prewcol
      else
        rpermb(o)=prewcol
      endif
c
c administration
c
      pivotn=pivotn+1
      permut(pivotn)=pcol
      pcnt=ccol(pcol)+crow(pcol)
c
c remove pcol from the counter lists
c
      o=cnext(pcol)
      ii=cprew(pcol)
      if(ii.eq.0)then
        cpnt(noddeg(pcol)-supdeg(pcol)+2)=o
      else
        cnext(ii)=o
      endif
      if(o.ne.0)cprew(o)=ii
c
      ppnt1=endmem-pcnt
      ppnt2=ppnt1+pcnt-1
      endmem=endmem-pcnt
      ccfree=ccfree-pcnt
      pnt=ppnt1
c
c create pivot column from the row file
c
      pnt1=pntr(pcol)
      pnt2=pnt1+crow(pcol)-1
      do 70 i=pnt1,pnt2
        o=colidx(i)
        l=pntc(o)
        p=l+ccol(o)-1
c
c find element and move in the column o
c
        cfill(o)=ccol(o)-1
        rfill(o)= 0
        do 75 k=l,p
          if(rowidx(k).eq.pcol)then
            mark(o)=1
            rowidx(pnt)=o
            pnt=pnt+1
            rowidx(k)=rowidx(p)
            goto 70
          endif
  75    continue
  70  continue
      mm=pnt
c
c extend pivot column from the column file
c
      pnt1=pntc(pcol)
      pnt2=pnt1+ccol(pcol)-1
      do 60 j=pnt1,pnt2
        o=rowidx(j)
        mark(o)=1
        rowidx(pnt)=o
        pnt=pnt+1
c
c remove pcol from the row file
c
        rfill(o)=-1
        cfill(o)=ccol(o)
        l=pntr(o)
        p=l+crow(o)-2
        do 55 k=l,p
          if(colidx(k).eq.pcol)then
            colidx(k)=colidx(p+1)
            goto 60
          endif
  55    continue
  60  continue
      pntc(pcol)=ppnt1
      ccol(pcol)=pcnt
c
c remove columns from the counter lists
c
      do 77 j=ppnt1,ppnt2
        i=rowidx(j)
        o=cnext(i)
        ii=cprew(i)
        if(ii.eq.0)then
          cpnt(noddeg(i)-supdeg(i)+2)=o
        else
          cnext(ii)=o
        endif
        if(o.ne.0)cprew(o)=ii
  77  continue
c
c elimination loop
c
      if(mfill.gt.0)then
c
        if(ppnt1.lt.mm)call hpsort((mm-ppnt1),rowidx(ppnt1))
        if(mm.lt.ppnt2)call hpsort((ppnt2-mm+1),rowidx(mm))
c
        do 80 p=ppnt1,ppnt2
          i=rowidx(p)
c
c delete element from mark
c
          mark(i)=0
          pcnt=pcnt-1
c
c transformation on the column i
c
          fill=pcnt
          pnt1=pntc(i)
          pnt2=pnt1+cfill(i)-1
          do 90 k=pnt1,pnt2
             o=rowidx(k)
             if(mark(o).ne.0)then
               fill=fill-1
               mark(o)=0
             endif
  90      continue
c
c compute the free space
c
          ii=cpermf(i)
          if(ii.eq.0)then
            k=endmem-pnt2-1
          else
            k=pntc(ii)-pnt2-1
          endif
c
c move column to the end of the column file
c
          if(fill.gt.k)then
            if (ccfree.lt.mn)then
              call mccmpr(mn,cfree,ccfree,endmem,nz,
     x        pntc,ccol,cfirst,cpermf,rowidx,code)
              if(code.lt.0)goto 999
              pnt1=pntc(i)
              pnt2=pnt1+cfill(i)-1
            endif
            if(i.ne.clast)then
              l=pntc(clast)+ccol(clast)
              pntc(i)=l
              do 95 k=pnt1,pnt2
                rowidx(l)=rowidx(k)
                l=l+1
  95          continue
              pnt1=pntc(i)
              pnt2=l-1
              prewcol=cpermb(i)
              if(prewcol.eq.0)then
                cfirst=ii
              else
                cpermf(prewcol)=ii
              endif
              cpermb(ii)=prewcol
              cpermf(clast)=i
              cpermb(i)=clast
              clast=i
              cpermf(clast)=0
            endif
          endif
c
c create fill in
c
          do 97 k=p+1,ppnt2
            o=rowidx(k)
            if(mark(o).eq.0)then
              mark(o)=1
            else
              pnt2=pnt2+1
              rowidx(pnt2)=o
              rfill(o)=rfill(o)+1
            endif
   97     continue
          pnt2=pnt2+1
          ccol(i)=pnt2-pnt1
          if(i.eq.clast)then
            ccfree=endmem-pnt2-1
          endif
  80    continue
      else
        do p=ppnt1,ppnt2
          i=rowidx(p)
          ccol(i)=ccol(i)-1-rfill(i)
          mark(i)=0
        enddo
      endif
c
c make space for fills in the row file
c
      do 100 j=ppnt1,ppnt2
        i=rowidx(j)
        if(mfill.eq.0)goto 135
        pnt2=pntr(i)+crow(i)-1
c
c compute the free space
c
        ii=rpermf(i)
        if(ii.eq.0)then
          k=rfree-pnt2-1
        else
          k=pntr(ii)-pnt2-1
        endif
c
c move row to the end of the row file
c
        if(k.lt.rfill(i))then
          if(rcfree.lt.mn)then
            call rcomprs(mn,rfree,
     x      rcfree,pntr,crow,rfirst,rpermf,colidx,code)
            if(code.lt.0)goto 999
          endif
          if(ii.ne.0)then
            pnt1=pntr(i)
            pnt2=pnt1+crow(i)-1
            pnt=pntr(rlast)+crow(rlast)
            pntr(i)=pnt
            do 110 l=pnt1,pnt2
              colidx(pnt)=colidx(l)
              pnt=pnt+1
 110        continue
c
c update the rperm lists
c
            prewcol=rpermb(i)
            if(prewcol.eq.0)then
              rfirst=ii
            else
              rpermf(prewcol)=ii
            endif
            rpermb(ii)=prewcol
            rpermf(rlast)=i
            rpermb(i)=rlast
            rlast=i
            rpermf(rlast)=0
          endif
        endif
 135    crow(i)=crow(i)+rfill(i)
        if(i.eq.rlast)rcfree=rfree-crow(i)-pntr(i)
        noddeg(i)=noddeg(i)-supdeg(pcol)
 100  continue
      if(mfill.eq.0)goto 150
c
c make pointers to the end of the filled rows
c
      do 120 j=ppnt1,ppnt2
        rfill(rowidx(j))=pntr(rowidx(j))+crow(rowidx(j))-1
 120  continue
c
c generate fill-in in the row file, update noddeg
c
      do j=ppnt1,ppnt2
        o=rowidx(j)
        pnt1=pntc(o)+cfill(o)
        pnt2=pntc(o)+ccol(o)-1
        do k=pnt1,pnt2
          colidx(rfill(rowidx(k)))=o
          rfill(rowidx(k))=rfill(rowidx(k))-1
          noddeg(o)=noddeg(o)+supdeg(rowidx(k))
          noddeg(rowidx(k))=noddeg(rowidx(k))+supdeg(o)
        enddo
      enddo
c
c Indicate new fill-in computation
c
      if(tfind.gt.0)then
        do j=ppnt1,ppnt2
          i=rowidx(j)
          fillin(i)=-1
          pnt1=pntc(i)+cfill(i)
          pnt2=pntc(i)+ccol(i)-1
          do pnt=pnt1,pnt2
            ii=rowidx(pnt)
            if(rfill(ii).ge.0)then
              k=pntc(ii)
              l=k+ccol(ii)-1
              do o=k,l
                fillin(rowidx(o))=-1
              enddo
              k=pntr(ii)
              l=k+crow(ii)-1
              do o=k,l
                fillin(colidx(o))=-1
              enddo
              rfill(ii)=-1
            endif
          enddo
        enddo
      endif
c
c Searching for new supernodes
c
 150  l=0
      j=ppnt1
 151  if(j.le.ppnt2)then
        i=rowidx(j)
        p=ccol(i)+crow(i)
c
        pnt1=pntc(i)
        pnt2=pnt1+ccol(i)-1
        do k=pnt1,pnt2
          if(mark(rowidx(k)).eq.0)then
            l=l+1
            cfill(l)=rowidx(k)
          endif
          mark(rowidx(k))=i
        enddo
c
        if(mark(i).eq.0)then
          l=l+1
          cfill(l)=i
        endif
        mark(i)=i
c
        pnt1=pntr(i)
        pnt2=pnt1+crow(i)-1
        do k=pnt1,pnt2
          if(mark(colidx(k)).eq.0)then
            l=l+1
            cfill(l)=colidx(k)
          endif
          mark(colidx(k))=i
        enddo
c
        k=j+1
  152   if(k.le.ppnt2)then
          o=rowidx(k)
          call chknod(m,cfree,rfree,i,o,p,ccol,crow,mark,pntc,
     x    pntr,rowidx,colidx,supdeg,suplst,ii)
          if(ii.gt.0)then
            supnd=supnd+1
c
            prewcol=cpermb(o)
            oo=cpermf(o)
            if(prewcol.ne.0)then
              cpermf(prewcol)=oo
            else
              cfirst=oo
            endif
            if(oo.eq.0)then
              clast=prewcol
            else
              cpermb(oo)=prewcol
            endif
c
            prewcol=rpermb(o)
            oo=rpermf(o)
            if(prewcol.ne.0)then
              rpermf(prewcol)=oo
            else
              rfirst=oo
            endif
            if(oo.eq.0)then
              rlast=prewcol
            else
              rpermb(oo)=prewcol
            endif
c
            rowidx(k)=rowidx(ppnt2)
            k=k-1
            ppnt2=ppnt2-1
            ccol(pcol)=ccol(pcol)-1
          endif
          k=k+1
          goto 152
        endif
        j=j+1
        goto 151
      endif
      do i=1,l
        mark(cfill(i))=0
      enddo
c
c update the counter lists
c
      do j=ppnt1,ppnt2
        i=rowidx(j)
        fill=noddeg(i)-supdeg(i)+2
        o=cpnt(fill)
        cnext(i)=o
        cpnt(fill)=i
        if(o.ne.0)cprew(o)=i
        cprew(i)=0
      enddo
c
c Augment the permutation with the supernodes
c
      i=suplst(pcol)
 155  if(i.gt.0)then
        pivotn=pivotn+1
        permut(pivotn)=i
        i=suplst(i)
        goto 155
      endif
      goto 50
c
c Augment the permutation with the disabled rows
c
 900  do i=1,m
        if(crow(i).le.-2)then
          pivotn=pivotn+1
          permut(pivotn)=i
        endif
      enddo
      write(buff,4)supnd
      call mprnt(buff)
      write(buff,5)hsupnd
      call mprnt(buff)
c
c Ready
c
 999  return
      end
c
c ===========================================================================
c
      subroutine mccmpr(mn,cfree,ccfree,endmem,nz,
     x pnt,count,cfirst,cpermf,rowidx,code)
      integer*4 mn,cfree,ccfree,endmem,nz,pnt(mn),rowidx(cfree),
     x count(mn),cpermf(mn),cfirst,code
c
      integer*4 i,j,pnt1,pnt2,pnt0
      character*99 buff
c ---------------------------------------------------------------------------
   2  format(' NOT ENOUGH MEMORY DETECTED IN SUBROUTINE CCOMPRESS')
      pnt0=nz+1
      i=cfirst
  40  if(i.le.0)goto 30
        pnt1=pnt(i)
        if(pnt1.lt.pnt0)goto 10
        if(pnt1.eq.pnt0)then
          pnt0=pnt0+count(i)
          goto 10
        endif
        pnt(i)=pnt0
        pnt2=pnt1+count(i)-1
        do 20 j=pnt1,pnt2
          rowidx(pnt0)=rowidx(j)
          pnt0=pnt0+1
  20    continue
  10    i=cpermf(i)
      goto 40
  30  ccfree=endmem-pnt0-1
      if(ccfree.lt.mn)then
        write(buff,2)
        call mprnt(buff)
        code=-2
      endif
      return
      end
c
c ===========================================================================
c
      subroutine chknod(m,cfree,rfree,i,o,p,ccol,crow,mark,pntc,
     x pntr,rowidx,colidx,supdeg,suplst,fnd)
c
      integer*4 m,cfree,rfree,i,o,p,ccol(m),crow(m),mark(m),pntc(m),
     x pntr(m),rowidx(cfree),colidx(rfree),supdeg(m),suplst(m),fnd
c
      integer*4 ppnt1,ppnt2,k,l,pnt,ii,pnod
c
      fnd=0
      if(ccol(o)+crow(o).ne.p)goto 120
      ppnt1=pntr(o)
      ppnt2=ppnt1+crow(o)-1
 111  if(ppnt1.le.ppnt2)then
        if(mark(colidx(ppnt1)).ne.i)goto 119
          ppnt1=ppnt1+1
          goto 111
        endif
      ppnt1=pntc(o)
      ppnt2=ppnt1+ccol(o)-1
 112  if(ppnt1.le.ppnt2)then
        if(mark(rowidx(ppnt1)).ne.i)goto 119
        ppnt1=ppnt1+1
        goto 112
      endif
c
c include column o (and its list) in to the list of column i
c
      pnod=o
 211  if(suplst(pnod).ne.0)then
        pnod=suplst(pnod)
        goto 211
      endif
      suplst(pnod)=suplst(i)
      suplst(i)=o
      supdeg(i)=supdeg(i)+supdeg(o)
c
c remove column/row o from the row and column files
c
      ppnt1=pntr(o)
      ppnt2=ppnt1+crow(o)-1
      do 124 k=ppnt1,ppnt2
        l=colidx(k)
        pnt=pntc(l)
        ii=pnt+ccol(l)-1
        ccol(l)=ccol(l)-1
 123    if(pnt.le.ii)then
          if(rowidx(pnt).eq.o)then
            rowidx(pnt)=rowidx(ii)
            goto 124
          endif
          pnt=pnt+1
          goto 123
        endif
 124  continue
      ppnt1=pntc(o)
      ppnt2=ppnt1+ccol(o)-1
      do 127 k=ppnt1,ppnt2
        l=rowidx(k)
        pnt=pntr(l)
        ii=pnt+crow(l)-1
        crow(l)=crow(l)-1
 126    if(pnt.le.ii)then
          if(colidx(pnt).eq.o)then
            colidx(pnt)=colidx(ii)
            goto 127
          endif
          pnt=pnt+1
          goto 126
        endif
 127  continue
      crow(o)=-1
      p=p-1
      fnd=1
      goto 120
 119  fnd=0
 120  return
      end
c
c ===========================================================================
c
      subroutine hpsort(n,iarr)
c
      integer*4 n,iarr(n)
c
      integer*4 i,j,l,ir,rra
c
c ---------------------------------------------------------------------------
c
      l=n/2+1
      ir=n
  10  if(l.gt.1)then
         l=l-1
         rra=iarr(l)
      else
        rra=iarr(ir)
        iarr(ir)=iarr(1)
        ir=ir-1
        if(ir.le.1)then
          iarr(1)=rra
          goto 999
        endif
      endif
      i=l
      j=l+l
  20  if(j-ir)40,50,60
  40  if(iarr(j).lt.iarr(j+1))j=j+1
  50  if(rra.lt.iarr(j))then
        iarr(i)=iarr(j)
        i=j
        j=j+j
      else
        j=ir+1
      endif
      goto 20
  60  iarr(i)=rra
      goto 10
 999  return
      end
c
c ===========================================================================
