c
c Numerically more stable version
c
c ===========================================================================
c
       subroutine  sparser(n,n1,m,nz,colpnt,
     x colbeg,colend,colidx,colnzs,
     x rowbeg,rowend,rowidx,rownzs,
     x colsta,rowsta,rhs,slktyp,
     x mark,rflag,tplus,tzer,redtol,reltol,abstol)
c
      integer*4 n,n1,m,nz,colpnt(n1),colbeg(n),colend(n),colidx(nz),
     x rowbeg(m),rowend(m),rowidx(nz),colsta(n),rowsta(m),
     x rflag(m),mark(n),slktyp(m)
      real*8 colnzs(nz),rownzs(nz),rhs(m),
     x tplus,tzer,redtol,reltol,abstol
c
      integer*4 i,j,k,pnt1,pnt2,rpnt1,rpnt2,row,col,prow,pcol,
     x pnt,ppnt1,ppnt2,elim,total,totaln,iw,rowlen
      real*8 pivot,nval,tol
      character*99 buff
c
c ---------------------------------------------------------------------------
c
      total=0
      totaln=0
      tol=1.0d+0/reltol
      do i=1,m
        if(rowsta(i).gt.-2)then         
          rflag(i)=0
          totaln=totaln+rowend(i)-rowbeg(i)+1
        else
          rflag(i)=2
        endif
      enddo
      do i=1,n
        mark(i)=0
      enddo
c
 100  elim=0
      do 20 row=1,m
        if((rflag(row).lt.2).and.(slktyp(row).eq.0))then
          iw=rflag(row)
          pnt1=rowbeg(row)
          pnt2=rowend(row)
          rowlen=pnt2-pnt1
c
c Select the shortest column
c
          col=0
          k=m+1
          do j=pnt1,pnt2
            i=rowidx(j)
            mark(i)=j
            if(colend(i)-colbeg(i).lt.k)then
              col=i
              k=colend(i)-colbeg(i)
            endif
          enddo
          if(col.eq.0)then
            rflag(row)=1
            goto 20
          endif
c
c Scan the selected column
c
          ppnt1=colbeg(col)
          ppnt2=colend(col)
          do 30 i=ppnt1,ppnt2
            prow=colidx(i)
            rpnt1=rowbeg(prow)
            rpnt2=rowend(prow)
            if((rowlen.gt.rpnt2-rpnt1).or.(iw+rflag(prow).ge.2).or.
     x      (row.eq.prow))goto 30
            k=-1
            do pnt=rpnt1,rpnt2
              if(mark(rowidx(pnt)).gt.0)k=k+1
            enddo
            if(k.ne.rowlen)goto 30
c
c Select pivot
c
            pcol=0
            pivot=tol
            do pnt=rpnt1,rpnt2
              if(mark(rowidx(pnt)).gt.0)then
                if(abs(rownzs(mark(rowidx(pnt)))).gt.abstol)then
                  nval=-rownzs(pnt)/rownzs(mark(rowidx(pnt)))
                  if(abs(nval).lt.abs(pivot))then
                    pivot=nval
                    pcol=rowidx(pnt)
                  endif
                endif
              endif
            enddo
            if(pcol.eq.0)goto 20
c
c Transformation
c
            rflag(prow)=0
            rhs(prow)=rhs(prow)+pivot*rhs(row)
            do pnt=rpnt1,rpnt2
              if(mark(rowidx(pnt)).gt.0)then
                nval=rownzs(pnt)+pivot*rownzs(mark(rowidx(pnt)))
                if(abs(nval).lt.tplus*(abs(rownzs(pnt))))nval=0.0d+0
                rownzs(pnt)=nval
              endif
            enddo
            do while (rpnt1.le.rpnt2)
              if(abs(rownzs(rpnt1)).lt.tzer)then
                k=rowidx(rpnt1)
                rownzs(rpnt1)=rownzs(rpnt2)
                rowidx(rpnt1)=rowidx(rpnt2)
                rownzs(rpnt2)=0.0d+0
                rowidx(rpnt2)=k
                rpnt2=rpnt2-1
                elim=elim+1
              else
                rpnt1=rpnt1+1
              endif
            enddo
            rowend(prow)=rpnt2
  30      continue
          do j=pnt1,pnt2
            mark(rowidx(j))=0
          enddo
          rflag(row)=1
        endif
  20  continue
      total=total+elim
      totaln=totaln-elim
      if(dble(elim)/(dble(totaln)+1.0d+0).gt.redtol)goto 100
c
c making modification in the column file
c
      if(total.gt.0)then
        do i=1,n         
          mark(i)=colbeg(i)-1
        enddo
        do i=1,m
          if(rowsta(i).gt.-2)then
            pnt1=rowbeg(i)
            pnt2=rowend(i)
            do j=pnt1,pnt2
              col=rowidx(j)
              mark(col)=mark(col)+1
              colidx(mark(col))=i
              colnzs(mark(col))=rownzs(j)
            enddo
          endif
        enddo
        pnt=colpnt(1)
        do i=1,n
          iw=pnt
          if(colsta(i).gt.-2)then
            pnt1=colbeg(i)
            pnt2=mark(i)
            colbeg(i)=pnt
            do j=pnt1,pnt2
              colnzs(pnt)=colnzs(j)
              colidx(pnt)=colidx(j)
              pnt=pnt+1
            enddo
            pnt1=colend(i)+1
            colend(i)=pnt-1
          else
            pnt1=colpnt(i)            
          endif
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            colnzs(pnt)=colnzs(j)
            colidx(pnt)=colidx(j)
            pnt=pnt+1
          enddo
          colpnt(i)=iw
        enddo
        colpnt(n+1)=pnt
      endif
c
      write(buff,'(1x,i5,a)')total,' nonzeros eliminated'
      call mprnt(buff)
      return
      end
c
c ===========================================================================
