PVMFS - PVM File Server


PVMFS is a PVM task process which facilitates I/O for programs
utilizing the Parallel Virtual Machine system (see pvm(1PVM)).    The
file server presents a common file system and support for coordinated
I/O to its parent and siblings.


------------------------------------------------------------------------


Making PVMFS


If you don't have an ANSI C compiler, compile ccwrap and regress
in libc/cc and make them accessible via your PATH.

Note that the shar files assume you're in the PVM_ROOT directoy.
Apply the patch ``pvm3.2.4.fspatch'', found in the patches directory.
You can do this by typing ``patch -p < patches/pvm3.2.4.fspatch''
again, when you're in the PVM_ROOT directory.

Typing ``make'' in your PVM_ROOT directory will, by default, compile
the new system call handling code as well as the file server.  If you,
for whatever reason, *don't* want the file server support, don't
#define PVMFS as it now is in various Makefile.aimk's.

One caveat is that you have to prepare libc/pvmerrno.[ch] for all of
the machines you will ever want to use in your virtual machine.  A perl
script, libc/pvmerrno.pl is provided to make this easier.  cd to libc
and type

	pvmerrno.pl <file where EPERM and friends are #defined>

which is usually

	pvmerrno.pl /usr/include/sys/errno.h

(If you don't have perl, basically you want to add every E* constant to
libc/pvmerrno.[ch] just like the others already there.)

Take libc/pvmerrno.[ch] to every other machine and do the same thing.
What these files do is provide a mapping from one machine's errno
constants to another's.  In libc/PVM_ARCH, the file errnoconf.h is
created.  This file deals with compilers not liking multiple case
statements with the same value (such as if EAGAIN == EWOULDBLOCK).)


------------------------------------------------------------------------


Examples


There are basically two example programs to run to check whether the
linking is good and to peruse example programming with the file
server.  These are under $PVM_ROOT/fsexamples and are called io and
iot.

io contains programs that read and write files using the various I/O
modes with UNIX, ANSI C, and FORTRAN functions.  You can just type
``aimk'' and it will try to run all the example programs.  Besides each
individual program, ``aimk c'' will do the UNIX examples, ``aimk stdc''
the ANSI C examples (files named *_stdc_[rw].c), and ``aimk f'' the
FORTRAN examples (files named *_f_[rw].f).  These all use the files
[01]_w and 01_r (although not directly).  ###WARNING: Some of the cases,
especially if they don't use buffering, can take a long time on a
loaded system.  If this is a problem, decrease the number of lines in
01_r, 0_w, and 1_w.  All of the examples are designed to run on just
one host, although if you coordinate the making of the executables (io
and fio), you can run on multiple hosts.

iot is like perl in that it can be interactive and its syntax resembles
the calling of UNIX system calls.  Unless DEBUG is #defined, it runs
one process on the current host and another as given by argv[1] (or
both on the current host if argc == 1.  The (remote) spawned process
actually reads the input and has the file server perform the requested
actions.  Type a system call name followed by a space if you want to
know the syntax.  Also, reads and writes use an anonymous buffer so you
can read and then write the stuff you read.  Use aimk to make iot.


-----------------------------------------------------------------------


Notes


There's a new -f option to the kill command of the console program.  It
kills the file server whose tid is specified and all processes with
that fstid.

If you're interested, you can #define DEBUG in the Makefile.aimk's in
src and pvmfs (this affects src/lpvm.c and pvmfs/fs.c), create the
named pipe /tmp/fspipe and run the file server in a debugger.

Also, you can #define TRACE and set the global variable pvmdebug
nonzero and system calls (and some POSIX calls like opendir) will print
out a trace (it may be bypassed in write).  It's amazing how often the
RS6K and SUN4 FORTRAN libraries call isatty...

If you don't want a file server (as we don't for the console process),
just don't call pvm_usefs with a nonzero argument.  By default, you
don't get a file server (unless your parent has one).


-----------------------------------------------------------------------


Bugs


Not all of the POSIX terminal I/O tc* functions are implemented.  And I
don't even want to think about ioctl...

File locking, which must be implemented in the file server because of
pid considerations, isn't.

Writing binary data should be fun.  You potentially have to know how to
convert from one architecture's format to another's.

The most important thing to get right when using the file server is the
linking.  Look at the Makefile*'s for the examples.  Note that all of
the true system calls (and some other functions easily emulated) are in
libc/syscalls.c.  libc/posix.c has functions that are *not* system
calls and cannot be called indirectly using syscall (like opendir).  If
you want to call opendir via the file server and then *locally* later,
you're out of luck.

For some reason, I've been able to cause the ALPHA's malloc to core
dump when trapping system calls, so one that uses a static array is
included under libc.  You may never need it.  If you do, though, you
should verify the reliability of the malloc implementation.  USE AT
YOUR OWN RISK.  If anybody sees this problem and figures this out,
please let me know.


-----------------------------------------------------------------------


FORTRAN hints


When you use shared files (other than mode PvmIomodeIndividual),
you should not specify STATUS = 'new' for output files.  The reason
is that the file server will remember that it has opened a file, but
isn't smart enough to lie about a call to access.  Use 'unknown'
and make sure the file is empty when you start up your program.

ftruncate has been disabled for shared files because, when you use
'unknown' and then write to a file, some FORTRAN I/O libraries
immediately do an lseek followed by an ftruncate.  When these are
done by multiple processes, data can be lost.

Be aware of buffering!!!


-----------------------------------------------------------------------


Porting Notes


As I said above, the most important thing to get right is the linking.
It's not good to think your FORTRAN code is trying to open a file via
the file server when it's really not because the linking is wrong.
Take some super-small C and FORTRAN programs and use the compiler's -v
option during the linking to see all of the libraries and stuff in the
argument list to ld.  Generally speaking, satisfy all of the FORTRAN
references first and have the system call trapping code last (assuming
a ``left-to-right'' linker).  The SUN4 and ALPHA are examples.

If your system has unusual linking, put this stuff in libc/PVM_ARCH/Mfile.
The RS6K is one example.

When you've figured out the linking, set ARCHFFSLIB (and ARCHFSLIB if
really weird) in conf/PVM_ARCH.def.

If things don't seem right running the examples, check /libc/libc.a.
For example, fopen on the ALPHA calls _open (which seems to take the
same arguments as open).  One the CNVXN, all of the system calls (say
open) actually call other functions in /libc/libc.a (__ap$open).  Look
at libc/syscalls.c to see this silliness.

You need to find out what return and argument types your system's read,
readv, write, writev, and select take and make appropriate changes to
libc/argtypes.h.

Change libc/pipe.h as necessary if syscall(SYS_pipe, fd) always returns
0 but doesn't set fd[0] or fd[1].


Enjoy!


Chris
----------

Christopher G. Phillips
pefv700@utpe.pe.utexas.edu
