	program common_f_r
	include '../../include/fpvm3.h'
	integer stderr
	parameter (stderr = 0)
	common /mvp/ tids(3), nodes, me, parent
	integer tids, nodes, me, parent
	integer startup
	integer ierr
	character*31 buf, infile, outfile
	character*1 cme

	nodes = 3
	me = startup('fio')

	infile = '../file'
	call pvmfsetdefiomode(PvmIomodeCommon, ierr)
	if (ierr .ne. 0) then
		call pvmfperror('pvmfsetdefiomode', ierr)
		call pvmfexit(ierr)
		stop
	endif
	open(10, file = infile, status = 'old', iostat = ierr)
	if (ierr .ne. 0) then
		write(stderr, 50) 'Can''t open ', infile
		call pvmfexit(ierr)
		stop
	endif
	
	if (me .eq. 0) then
		cme = '0'
	else if (me .eq. 1) then
		cme = '1'
	else
		cme = '2'
	endif

	outfile = '../' // cme // '.out'
	call pvmfsetdefiomode(PvmIomodeIndividual, ierr)
	if (ierr .ne. 0) then
		call pvmfperror('pvmfsetdefiomode', ierr)
		call pvmfexit(ierr)
		stop
	endif
	open(11, file = outfile, status = 'unknown', iostat = ierr)
	if (ierr .ne. 0) then
		write(stderr, 50) 'Can''t open ', outfile
		call pvmfexit(ierr)
		stop
	endif

 10	read(10, '(A31)', iostat = ierr, err = 30, end = 20) buf
	write(11, '(A31)', iostat = ierr, err = 40) buf
	go to 10

 20	close(10, iostat = ierr)
	if (ierr .ne. 0) then
		write(stderr, 50) 'Close error: ', infile
		call pvmfexit(ierr)
		stop
	endif
	close(11, iostat = ierr)
	if (ierr .ne. 0) then
		write(stderr, 50) 'Close error: ', outfile
		call pvmfexit(ierr)
		stop
	endif
	call pvmfexit(ierr)
	call wait4fs
	stop

 30	write(stderr, 50) infile, ': read error'
	call pvmfexit(ierr)
	stop
 40	write(stderr, 50) outfile, ': write error'
	call pvmfexit(ierr)
	stop

 50	format(1x, A, A)

	end
