C
C	Author:  Christopher G. Phillips
C	Copyright (C) 1993 All Rights Reserved
C
C	NOTICE
C
C Permission to use, copy, modify, and distribute this software and
C its documentation for any purpose and without fee is hereby granted
C provided that the above copyright notice appear in all copies and
C that both the copyright notice and this permission notice appear in
C supporting documentation.
C
C The author makes no representations about the suitability of this
C software for any purpose.  This software is provided ``as is''
C without express or implied warranty.
C

	subroutine shutdown(num_spawned)
	common /mvp/ tids(3), nodes, me, parent
	integer tids, nodes, me, parent
	integer num_spawned

	do 10 i = 2, num_spawned
		if (tids(i) .ge. 0) then
			call pvmfkill(tids(i), idummy)
		endif
  10	continue

	write(0, *) 'Shutting down...'
	stop
	end

	subroutine gsync
	include '../../include/fpvm3.h'
	integer gsync_type
	parameter(gsync_type = 32765)
	common /mvp/ tids(3), nodes, me, parent
	integer tids, nodes, me, parent
	integer	i, info

	if (nodes .gt. 1) then
		if (me .eq. 0) then
			do 10 i = 2, nodes
				call pvmfrecv(-1, gsync_type, info)
  10			continue
			call pvmfinitsend(PVMDEFAULT, info)
			call pvmfmcast(nodes - 1, tids(2),
     +			  gsync_type + 1, info)
		else
			call pvmfinitsend(PVMDEFAULT, info)
			call pvmfsend(parent, gsync_type, info)
			call pvmfrecv(parent, gsync_type + 1, info)
		endif
	endif
	
	return
	end

	integer function startup(task)
	include '../../include/fpvm3.h'
	integer gsync_type
	parameter(gsync_type = 16777216)
	common /mvp/ tids(3), nodes, me, parent
	integer tids, nodes, me, parent
	character*(*) task

	integer	mytid, numt

	call pvmfusefs(1, info)
	if (info .lt. 0) then
		call pvmfperror('pvmfusefs', info)
		stop
	endif

	call pvmfmytid(mytid)
	if (mytid .lt. 0) then
		call pvmfperror('pvmfmytid', mytid)
		stop
	endif

	call pvmfparent(parent)
	if (parent .lt. 0) then
		if (nodes .gt. 1) then
			tids(1) = mytid

c			call pvmfspawn(task, PVMDEFAULT + PVMDEBUG, '*',
			call pvmfspawn(task, PVMDEFAULT, '*',
     +			  nodes - 1, tids(2), numt)
			if (numt .ne. nodes - 1) then
				call shutdown(nodes - 1)
			endif

			call pvmfinitsend(PVMDEFAULT, info)
			if (info .lt. 0) call shutdown(nodes - 1)
			call pvmfpack(INTEGER4, nodes, 1, 1, info)
			if (info .lt. 0) call shutdown(nodes - 1)
			call pvmfpack(INTEGER4, tids, nodes, 1, info)
			if (info .lt. 0) call shutdown(nodes - 1)
			call pvmfmcast(nodes - 1, tids(2), 32767, info)
			if (info .lt. 0) call shutdown(nodes - 1)
		endif
		me = 0
	else
		call pvmfrecv(parent, 32767, info)
		if (info .lt. 0) call shutdown(0)
		call pvmfunpack(INTEGER4, nodes, 1, 1, info)
		if (info .lt. 0) call shutdown(0)
		call pvmfunpack(INTEGER4, tids, nodes, 1, info)
		if (info .lt. 0) call shutdown(0)

		do 10 i = 2, nodes
			if (tids(i) .eq. mytid) then
				me = i - 1
			endif
  10		continue
	endif

	call gsync

	startup = me
	return
	end
