#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <pvm3.h>

#define EXIT	pvm_exit(), exit
#define EXIT2	pvm_exit(), wait4fs(), exit

extern int	startup __ProtoGlarp__((int *, char **));
extern void	wait4fs __ProtoGlarp__((void));

int
main(int argc, char **argv)
{
	int	me;
	int	fdr;
	int	fdw;
	char	buf[32];
	char	wfile[BUFSIZ];
	int	nbytes;

	me = startup(&argc, argv);

	pvm_setioorder(me);
	pvm_setdefiomode(PvmIomodeSyncBC);
	if ((fdr = open("../file", O_RDONLY)) == -1) {
		perror("../file");
		EXIT(1);
	}
	sprintf(wfile, "../%d.out", me);
	pvm_setdefiomode(PvmIomodeIndividual);
	if ((fdw = open(wfile, O_CREAT | O_TRUNC | O_WRONLY, 0600)) == -1) {
		perror(wfile);
		EXIT(1);
	}
	while ((nbytes = read(fdr, buf, sizeof buf)) > 0) {
		if (write(fdw, buf, nbytes) == -1) {
			perror("write");
			EXIT(1);
		}
	}
	if (nbytes == -1) {
		perror("read");
		EXIT(1);
	}

	if (close(fdr) == -1)
		perror(wfile);
	if (close(fdw) == -1)
		perror("../file");

	EXIT2(0);
}
