#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <pvm3.h>

#define EXIT	pvm_exit(), exit
#define EXIT2	pvm_exit(), wait4fs(), exit

extern int	startup __ProtoGlarp__((int *, char **));
extern void	wait4fs __ProtoGlarp__((void));

int
main(int argc, char **argv)
{
	int	me;
	FILE	*fpr;
	FILE	*fpw;
	char	buf[32], fpwbuf[32];
	char	wfile[BUFSIZ];
	size_t	nbytes;

	me = startup(&argc, argv);

	pvm_setioorder(me);
	pvm_setdefiomode(PvmIomodeSyncSeq);
	if ((fpw = fopen("../file", "w")) == NULL) {
		perror("../file");
		EXIT(1);
	}
	setvbuf(fpw, fpwbuf, _IOFBF, sizeof fpwbuf);

	sprintf(wfile, "../%d.out", me);
	pvm_setdefiomode(PvmIomodeIndividual);
	if ((fpr = fopen(wfile, "r")) == NULL) {
		perror(wfile);
		EXIT(1);
	}

	while (nbytes = fread(buf, sizeof *buf, sizeof buf, fpr)) {
		if (fwrite(buf, sizeof *buf, nbytes, fpw) != nbytes) {
			perror("fwrite");
			EXIT(1);
		}
	}
	if (ferror(fpr)) {
		perror("fread");
		EXIT(1);
	}

	if (fclose(fpr) == EOF)
		perror(wfile);
	if (fclose(fpw) == EOF)
		perror("../file");

	EXIT2(0);
}
