/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#ifdef IMA_SUN4
#define sprintf	ugh
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <dirent.h>
#include <termios.h>
#include <utime.h>
#include <sys/uio.h>
#include <pvm3.h>
#ifndef IMA_RS6K
#include <syscall.h>
#include <sys/mman.h>
#else
#include <sys/select.h>
#include "syscall-fake.h"
#endif
#ifndef PATH_MAX
#define PATH_MAX 1024
#endif
#ifdef IMA_SUN4
#undef sprintf
int	sprintf __ProtoGlarp__((char *, const char *, ...));

char *
strerror(int num)
{
	extern int	sys_nerr;
	extern char	*sys_errlist[];

	if (num > 0 && num < sys_nerr)
		return sys_errlist[num];
	else
		return "???";
}
#endif

#ifdef rewinddir
#undef rewinddir
extern void	rewinddir  __ProtoGlarp__((DIR *));
#endif

#define NUMFPS	10
static struct {
	int	used;
	FILE	*fp;
} gfp[NUMFPS];

extern int	errno;
static char	prompt[] = "pvm$ ";

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	1024
#endif

static void
say_hello(void)
{
	char	hostname[MAXHOSTNAMELEN];

	if (gethostname(hostname, sizeof hostname) == -1)
		strcpy(hostname, "Unknown");
	printf("Reading commands on %s!\n", hostname);
}

int
main(int argc, char **argv)
{
	int		me;
	int		int1, int2, int3, int4;
	int		saved_errno;
	int		retval;
	int		n;
	struct stat	st;
	struct timeval	tv[2], *tvp;
	fd_set		wset, rset, eset;
	fd_set		*wsetp, *rsetp, *esetp;
	struct flock	flock;
	struct rlimit	rl;
	char		path1[PATH_MAX], path2[PATH_MAX];
	char		buf[BUFSIZ];
	char		rwbuf[BUFSIZ];
	char		*cp;
	long		long1, long2, long3, long4;
	long		offset1, offset2, offset3, offset4;
	unsigned long	ul1, ul2;
	DIR		*dp;
	FILE		*fp;
#ifndef IMA_SUN4
	fpos_t		fpos1;
#endif
	struct dirent	*dirp;
	struct utimbuf	ut, *utp;

	int		other;
#ifdef DEBUG
	extern int	pvmdebug;

	pvmdebug = 1;
#endif

	pvm_usefs(1);

        if ((other = pvm_parent()) < 0) {
#ifndef DEBUG
		char	*slash;

		if (slash = strrchr(argv[0], '/'))
			argv[0] = slash + 1;
                if (pvm_spawn(argv[0], argv,
		  argc > 1 ? PvmTaskHost : PvmTaskDefault,
		  argc > 1 ? argv[1] : NULL, 1, &other) != 1) {
			extern int	pvm_errno;

			pvm_errno = other;
			pvm_perror("pvm_spawn");
                        exit(1);
		}
#endif
		me = 0;
        } else
		me = 1;
#ifdef DEBUG
	me = !me;
#endif

	if (pvm_setiomode(0, PvmIomodeCommon) == -1)
		perror("pvm_setiomode");
	if (pvm_setiomode(1, PvmIomodeCommon) == -1)
		perror("pvm_setiomode");
	if (pvm_setiomode(2, PvmIomodeCommon) == -1)
		perror("pvm_setiomode");

	if (me == 0) {
		pvm_notify(PvmTaskExit, 10, 1, &other);
                pvm_recv(-1, 10);
		pvm_exit();
		exit(0);
        } else
		say_hello();

	for (n = 0; n < NUMFPS; n++) {
		gfp[n].used = n < 3;
		gfp[n].fp = NULL;
	}
	gfp[0].fp = stdin;
	gfp[1].fp = stdout;
	gfp[2].fp = stderr;

top:
	write(1, prompt, sizeof prompt - 1);
	while ((n = read(0, buf, sizeof buf - 1)) > 0) {
		buf[n] = '\0';
		n = 0;
		if (strncmp(buf, "rename ", sizeof("rename")) == 0) {
			if (sscanf(buf + sizeof("rename"), "%s %s", path1,
			  path2) == 2) {
				retval = rename(path1, path2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "rename(\"%s\", \"%s\") = %d",
				  path1, path2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: rename path1 path2\n");
		} else if (strncmp(buf, "fcntl ", sizeof("fcntl")) == 0) {
			if (sscanf(buf + sizeof("fcntl"), "%d %d %d",
			  &int1, &int2, &int3) == 3) {
				retval = fcntl(int1, int2, int3);
				saved_errno = errno;
				n += sprintf(buf + n, "fcntl(%d, %d, %d) = %d",
				  int1, int2, int3, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else if (sscanf(buf + sizeof("fcntl"),
			  "%d %d %ld %ld %ld %ld", &int1, &int2, &long1, &long2,
			  &long3, &long4) == 6) {
				flock.l_type = long1;
				flock.l_start = long2;
				flock.l_whence = long3;
				flock.l_len = long4;
				retval = fcntl(int1, int2, &flock);
				saved_errno = errno;
				n += sprintf(buf + n, 
				  "fcntl(%d, %d, <%ld, %ld, %ld, %ld>) = %d",
				  int1, int2, long1, long2, long3, long4,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else {
				n += sprintf(buf + n,
				  "usage: fcntl fd cmd arg\n");
				n += sprintf(buf + n,
			  "or fcntl fd cmd l_type l_start l_whence l_len\n");
			}
		} else if (strncmp(buf, "link ", sizeof("link")) == 0) {
			if (sscanf(buf + sizeof("link"), "%s %s", path1, path2)
			  == 2) {
				retval = link(path1, path2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "link(\"%s\", \"%s\") = %d",
				  path1, path2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: link path1 path2\n");
		} else if (strncmp(buf, "symlink ", sizeof("symlink")) == 0) {
			if (sscanf(buf + sizeof("symlink"), "%s %s", path1,
			  path2) == 2) {
				retval = symlink(path1, path2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "symlink(\"%s\", \"%s\") = %d",
				  path1, path2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: symlink path1 path2\n");
		} else if (strncmp(buf, "mkdir ", sizeof("mkdir")) == 0) {
			if (sscanf(buf + sizeof("mkdir"), "%s %lo", path1,
			  &long1) == 2) {
				retval = mkdir(path1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "mkdir(\"%s\", %04o) = %d",
				  path1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: mkdir path octal_mode\n");
		} else if (strncmp(buf, "readlink ", sizeof("readlink")) == 0) {
			if (sscanf(buf + sizeof("readlink"), "%s %d", path1,
			  &int1) == 2) {
				path2[0] = '\0';
				retval = readlink(path1, path2, int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "readlink(\"%s\", \"%s\", %d) = %d",
				  path1, path2, int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: readlink path length\n");
		} else if (strncmp(buf, "mkfifo ", sizeof("mkfifo")) == 0) {
			if (sscanf(buf + sizeof("mkfifo"), "%s %lo", path1,
			  &long1) == 2) {
				retval = mkfifo(path1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "mkfifo(\"%s\", %04o) = %d",
				  path1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: mkfifo path octal_mode\n");
		} else if (strncmp(buf, "mknod ", sizeof("mknod")) == 0) {
			if (sscanf(buf + sizeof("mknod"), "%s %lo %d", path1,
			  &long1, &int1) == 3) {
				retval = mknod(path1, long1, int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "mknod(\"%s\", %04o, %d) = %d",
				  path1, (int)long1, int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: mknod path octal_mode device\n");
		} else if (strncmp(buf, "truncate ", sizeof("truncate")) == 0) {
			if (sscanf(buf + sizeof("truncate"), "%s %ld", path1,
			  &long1) == 2) {
				retval = truncate(path1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "truncate(\"%s\", %ld) = %d",
				  path1, long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: truncate path length\n");
		} else if (strncmp(buf, "ftruncate ", sizeof("ftruncate"))
		  == 0) {
			if (sscanf(buf + sizeof("ftruncate"), "%d %ld",
			  &int1, &long1) == 2) {
				retval = ftruncate(int1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "ftruncate(%d, %ld) = %d",
				  int1, long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: ftruncate fd length\n");
		} else if (strncmp(buf, "chmod ", sizeof("chmod")) == 0) {
			if (sscanf(buf + sizeof("chmod"), "%s %lo", path1,
			  &long1) == 2) {
				retval = chmod(path1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "chmod(\"%s\", %04o) = %d",
				  path1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: chmod path octal_mode\n");
		} else if (strncmp(buf, "fchmod ", sizeof("fchmod")) == 0) {
			if (sscanf(buf + sizeof("fchmod"), "%d %lo",
			  &int1, &long1) == 2) {
				retval = fchmod(int1, long1);
				saved_errno = errno;
				n += sprintf(buf + n, "fchmod(%d, %04o) = %d",
				  int1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fchmod fd octal_mode\n");
		} else if (strncmp(buf, "chown ", sizeof("chown")) == 0) {
			if (sscanf(buf + sizeof("chown"), "%s %ld %ld", path1,
			  &long1, &long2) == 3) {
				retval = chown(path1, long1, long2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "chown(\"%s\", %ld, %ld) = %d",
				  path1, long1, long2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: chown path uid gid\n");
		} else if (strncmp(buf, "fchown ", sizeof("fchown")) == 0) {
			if (sscanf(buf + sizeof("fchown"), "%d %ld %ld",
			  &int1, &long1, &long2) == 3) {
				retval = fchown(int1, long1, long2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fchown(%d, %ld, %ld) = %d",
				  int1, long1, long2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fchown fd uid gid\n");
		} else if (strncmp(buf, "lchown ", sizeof("lchown")) == 0) {
			if (sscanf(buf + sizeof("lchown"), "%s %ld %ld", path1,
			  &long1, &long2) == 3) {
				retval = lchown(path1, long1, long2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "lchown(\"%s\", %ld, %ld) = %d",
				  path1, long1, long2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: lchown path uid gid\n");
		} else if (strncmp(buf, "stat ", sizeof("stat")) == 0) {
			if (sscanf(buf + sizeof("stat"), "%s", path1) == 1) {
				retval = stat(path1, &st);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "stat(\"%s\", %p) = %d", path1, &st, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)\n",
					  strerror(errno));
				else {
					n += sprintf(buf + n, "\n");
n += sprintf(buf + n, "st_dev = %ld, st_ino = %ld, st_mode = %04o, st_nlink = %ld\n",
  (long)st.st_dev, (long)st.st_ino, (int)st.st_mode, (long)st.st_nlink);
n += sprintf(buf + n, "st_uid = %ld, st_gid = %ld, st_rdev = %ld, st_size = %ld\n",
  (long)st.st_uid, (long)st.st_gid, (long)st.st_rdev, (long)st.st_size);
n += sprintf(buf + n, "st_atime = %ld, st_ctime = %ld, st_mtime = %ld\n",
  (long)st.st_atime, (long)st.st_ctime, (long)st.st_mtime);
				}
			} else
				n += sprintf(buf + n,
				  "usage: stat path\n");
		} else if (strncmp(buf, "lstat ", sizeof("lstat")) == 0) {
			if (sscanf(buf + sizeof("lstat"), "%s", path1) == 1) {
				retval = lstat(path1, &st);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "lstat(\"%s\", %p) = %d", path1, &st, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)\n",
					  strerror(errno));
				else {
					n += sprintf(buf + n, "\n");
n += sprintf(buf + n, "st_dev = %ld, st_ino = %ld, st_mode = %04o, st_nlink = %ld\n",
  (long)st.st_dev, (long)st.st_ino, (int)st.st_mode, (long)st.st_nlink);
n += sprintf(buf + n, "st_uid = %ld, st_gid = %ld, st_rdev = %ld, st_size = %ld\n",
  (long)st.st_uid, (long)st.st_gid, (long)st.st_rdev, (long)st.st_size);
n += sprintf(buf + n, "st_atime = %ld, st_ctime = %ld, st_mtime = %ld\n",
  (long)st.st_atime, (long)st.st_ctime, (long)st.st_mtime);
				}
			} else
				n += sprintf(buf + n,
				  "usage: lstat path\n");
		} else if (strncmp(buf, "fstat ", sizeof("fstat")) == 0) {
			if (sscanf(buf + sizeof("fstat"), "%d", &int1) == 1) {
				retval = fstat(int1, &st);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fstat(%d, %p) = %d", int1, &st, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)\n",
					  strerror(errno));
				else {
					n += sprintf(buf + n, "\n");
n += sprintf(buf + n, "st_dev = %ld, st_ino = %ld, st_mode = %04o, st_nlink = %ld\n",
  (long)st.st_dev, (long)st.st_ino, (int)st.st_mode, (long)st.st_nlink);
n += sprintf(buf + n, "st_uid = %ld, st_gid = %ld, st_rdev = %ld, st_size = %ld\n",
  (long)st.st_uid, (long)st.st_gid, (long)st.st_rdev, (long)st.st_size);
n += sprintf(buf + n, "st_atime = %ld, st_ctime = %ld, st_mtime = %ld\n",
  (long)st.st_atime, (long)st.st_ctime, (long)st.st_mtime);
				}
			} else
				n += sprintf(buf + n, "usage: fstat fd\n");
		} else if (strncmp(buf, "chroot ", sizeof("chroot")) == 0) {
			if (sscanf(buf + sizeof("chroot"), "%s", path1) == 1) {
				retval = chroot(path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "chroot(\"%s\") = %d", path1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: chroot path\n");
		} else if (strncmp(buf, "chdir ", sizeof("chdir")) == 0) {
			if (sscanf(buf + sizeof("chdir"), "%s", path1) == 1) {
				retval = chdir(path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "chdir(\"%s\") = %d", path1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: chdir path\n");
		} else if (strncmp(buf, "fchdir ", sizeof("fchdir")) == 0) {
			if (sscanf(buf + sizeof("fchdir"), "%d", &int1) == 1) {
				retval = fchdir(int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fchdir(%d) = %d", int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: fchdir fd\n");
		} else if (strncmp(buf, "dup ", sizeof("dup")) == 0) {
			if (sscanf(buf + sizeof("dup"), "%d", &int1) == 1) {
				retval = dup(int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "dup(%d) = %d", int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: dup fd\n");
		} else if (strncmp(buf, "dup2 ", sizeof("dup2")) == 0) {
			if (sscanf(buf + sizeof("dup2"), "%d %d", &int1, &int2)
			  == 2) {
				retval = dup2(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "dup2(%d, %d) = %d", int1, int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: dup2 fd1 fd2\n");
		} else if (strncmp(buf, "read ", sizeof("read")) == 0) {
			if (sscanf(buf + sizeof("read"), "%d %ld", &int1,
			  &long1) == 2) {
				if (long1 > BUFSIZ) {
					printf("length being reduced to %d\n",
					  BUFSIZ);
					long1 = BUFSIZ;
				}
				long2 = read(int1, rwbuf, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "read(%d, %p, %ld) = %ld", int1, rwbuf, long1,
				  long2);
				errno = saved_errno;
				if (long2 == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: read fd nbytes\n");
		} else if (strncmp(buf, "readv ", sizeof("readv")) == 0) {
			if (sscanf(buf + sizeof("readv"), "%d 1 %ld %ld", &int1,
			  &long1, &offset1) == 3)
				int2 = 1;
			else if (sscanf(buf + sizeof("readv"),
			  "%d 2 %ld %ld %ld %ld", &int1, &long1, &offset1,
			  &long2, &offset2) == 5)
				int2 = 2;
			else if (sscanf(buf + sizeof("readv"),
			  "%d 3 %ld %ld %ld %ld %ld %ld", &int1,
			  &long1, &offset1, &long2, &offset2, &long3, &offset3)
			  == 7)
				int2 = 3;
			else
				int2 = 0;

			if (int2) {
				struct iovec	iovec[3];

				switch (int2) {
				case 3: iovec[2].iov_base = rwbuf + offset3;
					iovec[2].iov_len = long3;
				case 2: iovec[1].iov_base = rwbuf + offset2;
					iovec[1].iov_len = long2;
				case 1: iovec[0].iov_base = rwbuf + offset1;
					iovec[0].iov_len = long1;
				}

				long4 = readv(int1, iovec, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "readv(%d, %p, %d) = %ld", int1, iovec, int2,
				  long4);
				errno = saved_errno;
				if (long4 == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
			  "usage: readv fd [123] [length offset]{1,3}\n");
		} else if (strncmp(buf, "write ", sizeof("write")) == 0) {
			long2 = 0;
			if (sscanf(buf + sizeof("write"), "%d %ld %ld", &int1,
			  &long1, &long2) == 3
			  || sscanf(buf + sizeof("write"), "%d %ld", &int1,
			  &long1) == 2) {
				long3 = write(int1, rwbuf + long2, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "write(%d, %p, %ld) = %ld", int1,
				  rwbuf + long2, long1, long3);
				errno = saved_errno;
				if (long3 == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else if (sscanf(buf + sizeof("write"), "%d %s",
			  &int1, path1) == 2) {
				long2 = write(int1, path1, strlen(path1));
				saved_errno = errno;
				n += sprintf(buf + n,
				  "write(%d, \"%s\", %ld) = %ld", int1, path1,
				  strlen(path1), long2);
				errno = saved_errno;
				if (long2 == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else {
				n += sprintf(buf + n,
				  "usage: write fd length [offset]\n");
				n += sprintf(buf + n, "or write fd string\n");
			}
		} else if (strncmp(buf, "writev ", sizeof("writev")) == 0) {
			if (sscanf(buf + sizeof("writev"), "%d 1 %ld %ld",
			  &int1, &long1, &offset1) == 3)
				int2 = 1;
			else if (sscanf(buf + sizeof("writev"),
			  "%d 2 %ld %ld %ld %ld", &int1, &long1, &offset1,
			  &long2, &offset2) == 5)
				int2 = 2;
			else if (sscanf(buf + sizeof("writev"),
			  "%d 3 %ld %ld %ld %ld %ld %ld", &int1,
			  &long1, &offset1, &long2, &offset2, &long3, &offset3)
			  == 7)
				int2 = 3;
			else
				int2 = 0;

			if (int2) {
				struct iovec	iovec[3];

				switch (int2) {
				case 3: iovec[2].iov_base = rwbuf + offset3;
					iovec[2].iov_len = long3;
				case 2: iovec[1].iov_base = rwbuf + offset2;
					iovec[1].iov_len = long2;
				case 1: iovec[0].iov_base = rwbuf + offset1;
					iovec[0].iov_len = long1;
				}

				long4 = writev(int1, iovec, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "writev(%d, %p, %ld) = %ld", int1, iovec, 
				  long1, long4);
				errno = saved_errno;
				if (long4 == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
			  "usage: writev fd [123] [length offset]{1,3}\n");
		} else if (strncmp(buf, "lseek ", sizeof("lseek")) == 0) {
			if (sscanf(buf + sizeof("lseek"), "%d %ld %d", &int1,
			  &long1, &int2) == 3) {
				retval = lseek(int1, long1, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "lseek(%d, %ld, %d) = %d", int1, long1,
				  int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: lseek fd offset whence\n");
		} else if (strncmp(buf, "close ", sizeof("close")) == 0) {
			if (sscanf(buf + sizeof("close"), "%d", &int1) == 1) {
				retval = close(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "close(%d) = %d", int1,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: close fd\n");
		} else if (strncmp(buf, "rmdir ", sizeof("rmdir")) == 0) {
			if (sscanf(buf + sizeof("rmdir"), "%s", path1) == 1) {
				retval = rmdir(path1);
				saved_errno = errno;
				n += sprintf(buf + n, "rmdir(\"%s\") = %d",
				  path1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: rmdir path\n");
		} else if (strncmp(buf, "open ", sizeof("open")) == 0) {
			if (sscanf(buf + sizeof("open"), "%s %d %lo", path1,
			  &int1, &long1) == 3) {
				retval = open(path1, int1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "open(\"%s\", %d, %04o) = %d",
				  path1, int1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else if (sscanf(buf + sizeof("open"), "%s %d", path1,
			  &int1) == 2) {
				retval = open(path1, int1);
				saved_errno = errno;
				n += sprintf(buf + n, "open(\"%s\", %d) = %d",
				  path1, int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else {
				n += sprintf(buf + n,
				  "usage: open path flags octal_mode\n");
				n += sprintf(buf + n,
				  "or open path flags\n");
			}
		} else if (strncmp(buf, "creat ", sizeof("creat")) == 0) {
			if (sscanf(buf + sizeof("creat"), "%s %lo", path1,
			  &long1) == 2) {
				retval = creat(path1, long1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "creat(\"%s\", %04o) = %d",
				  path1, (int)long1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: creat path octal_mode\n");
		} else if (strncmp(buf, "unlink ", sizeof("unlink")) == 0) {
			if (sscanf(buf + sizeof("unlink"), "%s", path1) == 1) {
				retval = unlink(path1);
				saved_errno = errno;
				n += sprintf(buf + n, "unlink(\"%s\") = %d",
				  path1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: unlink path\n");
		} else if (strncmp(buf, "umask ", sizeof("umask")) == 0) {
			if (sscanf(buf + sizeof("umask"), "%lo", &long1) == 1) {
				long2 = umask(long1);
				saved_errno = errno;
				n += sprintf(buf + n, "umask(%04o) = %04o",
				  (int)long1,
				  (int)long2);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: umask octal_mask\n");
		} else if (strncmp(buf, "utime ", sizeof("utime")) == 0) {
			if (sscanf(buf + sizeof("utime"), "%s %ld %ld", path1,
			  &long1, &long2) == 3) {
				utp = &ut;
				utp->actime = long1;
				utp->modtime = long2;
				n += sprintf(buf + n,
				  "utime(\"%s\", <%ld, %ld>)", path1, long1,
				  long2);
			} else if (sscanf(buf + sizeof("utime"), "%s", path1)
			  == 1) {
				utp = NULL;
				n += sprintf(buf + n, "utime(\"%s\", NULL)",
				  path1);
			} else {
				n += sprintf(buf + n,
				  "usage: utime path actime modtime\n");
				n += sprintf(buf + n,
				  "or utime path\n");
				goto bottom;
			}
			retval = utime(path1, utp);
			saved_errno = errno;
			n += sprintf(buf + n, " = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)", strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "utimes ", sizeof("utimes")) == 0) {
			if (sscanf(buf + sizeof("utimes"), "%s %ld %ld", path1,
			  &long1, &long2) == 3) {
				tv[0].tv_sec = long1;
				tv[1].tv_sec = long2;
				tv[0].tv_usec = tv[1].tv_usec = 0;
				retval = utimes(path1, tv);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "utimes(\"%s\", <%ld, %ld>) = %d",
				  path1, long1, long2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: utimes path actime modtime\n");
		} else if (strncmp(buf, "fsync ", sizeof("fsync")) == 0) {
			if (sscanf(buf + sizeof("fsync"), "%d", &int1) == 1) {
				retval = fsync(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "fsync(%d) = %d", int1,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: fsync fd\n");
		} else if (strncmp(buf, "isatty ", sizeof("isatty")) == 0) {
			if (sscanf(buf + sizeof("isatty"), "%d", &int1) == 1) {
				retval = isatty(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "isatty(%d) = %d", int1,
				  retval);
				errno = saved_errno;
				if (retval == 0)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: isatty fd\n");
		} else if (strncmp(buf, "ttyname ", sizeof("ttyname")) == 0) {
			if (sscanf(buf + sizeof("ttyname"), "%d", &int1) == 1) {
				cp = ttyname(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "ttyname(%d) = ", int1);
				errno = saved_errno;
				if (cp)
					n += sprintf(buf + n, "\"%s\"\n", cp);
				else
					n += sprintf(buf + n, "NULL (%s)\n",
					  strerror(errno));
			} else
				n += sprintf(buf + n, "usage: ttyname fd\n");
		} else if (strncmp(buf, "tcdrain ", sizeof("tcdrain")) == 0) {
			if (sscanf(buf + sizeof("tcdrain"), "%d", &int1) == 1) {
				retval = tcdrain(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "tcdrain(%d) = %d", int1,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: tcdrain fd\n");
		} else if (strncmp(buf, "tcflow ", sizeof("tcflow")) == 0) {
			if (sscanf(buf + sizeof("tcflow"), "%d %d", &int1,
			  &int2) == 2) {
				retval = tcflow(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n, "tcflow(%d, %d) = %d",
				  int1, int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: tcflow fd action\n");
		} else if (strncmp(buf, "tcflush ", sizeof("tcflush")) == 0) {
			if (sscanf(buf + sizeof("tcflush"), "%d %d", &int1,
			  &int2) == 2) {
				retval = tcflush(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n, "tcflush(%d, %d) = %d",
				  int1, int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: tcflush fd queue\n");
		} else if (strncmp(buf, "tcsendbreak ", sizeof("tcsendbreak"))
		  == 0) {
			if (sscanf(buf + sizeof("tcsendbreak"), "%d %d", &int1,
			  &int2) == 2) {
				retval = tcsendbreak(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "tcsendbreak(%d, %d) = %d", int1, int2,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: tcsendbreak fd duration\n");
		} else if (strncmp(buf, "access ", sizeof("access")) == 0) {
			if (sscanf(buf + sizeof("access"), "%s %d", path1,
			  &int1) == 2) {
				retval = access(path1, int1);
				saved_errno = errno;
				n += sprintf(buf + n, "access(\"%s\", %d) = %d",
				  path1, int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: access path mode\n");
		} else if (strncmp(buf, "select ", sizeof("select")) == 0) {
			if (sscanf(buf + sizeof("select"), "%d %d %d %ld",
			  &int1, &int2, &int3, &long1) == 4) {
				tv[0].tv_sec = long1;
				tv[0].tv_usec = 0;
				tvp = &tv[0];
			} else if (sscanf(buf + sizeof("select"),
			  "%d %d %d", &int1, &int2, &int3) == 3)
				tvp = NULL;
			else {
				n += sprintf(buf + n,
				  "usage: select rfd wfd efd [secs]\n");
				n += sprintf(buf + n,
				  "[rwe]fd should be one fd or -1\n");
				goto bottom;
			}

			int4 = -1;
			if (int1 >= 0) {
				rsetp = &rset;
				FD_ZERO(rsetp);
				FD_SET(int1, rsetp);
				int4 = int1;
			} else
				rsetp = NULL;
			if (int2 >= 0) {
				wsetp = &wset;
				FD_ZERO(wsetp);
				FD_SET(int2, wsetp);
				if (int2 > int4)
					int4 = int2;
			} else
				wsetp = NULL;
			if (int3 >= 0) {
				esetp = &eset;
				FD_ZERO(esetp);
				FD_SET(int3, esetp);
				if (int3 > int4)
					int4 = int3;
			} else
				esetp = NULL;
			int4++;
			n += sprintf(buf + n, "select(%d, ", int4);
			int4 = select(int4, rsetp, wsetp, esetp, tvp);
			saved_errno = errno;
			if (rsetp && FD_ISSET(int1, rsetp))
				n += sprintf(buf + n, "<%d>", int1);
			else
				n += sprintf(buf + n, "NULL");
			n += sprintf(buf + n, ", ");
			if (wsetp && FD_ISSET(int2, wsetp))
				n += sprintf(buf + n, "<%d>", int2);
			else
				n += sprintf(buf + n, "NULL");
			n += sprintf(buf + n, ", ");
			if (esetp && FD_ISSET(int3, esetp))
				n += sprintf(buf + n, "<%d>", int3);
			else
				n += sprintf(buf + n, "NULL");
			n += sprintf(buf + n, ", ");
			if (tvp)
				n += sprintf(buf + n, "<%ld>", tvp->tv_sec);
			else
				n += sprintf(buf + n, "NULL");
			n += sprintf(buf + n, ") = %d", int4);
			errno = saved_errno;
			if (int4 == -1)
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			else if (int4 > 0) {
				n += sprintf(buf + n, " {");
				if (rsetp && FD_ISSET(int1, rsetp))
					n += sprintf(buf + n, "%d", int1);
				else
					n += sprintf(buf + n, "NULL");
				n += sprintf(buf + n, ", ");
				if (wsetp && FD_ISSET(int2, wsetp))
					n += sprintf(buf + n, "%d", int2);
				else
					n += sprintf(buf + n, "NULL");
				n += sprintf(buf + n, ", ");
				if (esetp && FD_ISSET(int3, esetp))
					n += sprintf(buf + n, "%d", int3);
				else
					n += sprintf(buf + n, "NULL");
				n += sprintf(buf + n, "}");
			}
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "sync", 4) == 0) {
			retval = sync();
			saved_errno = errno;
			n += sprintf(buf + n, "sync() = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "mmap", 4) == 0) {
			cp = mmap(NULL, 0, 0, 0, 0, 0);
			saved_errno = errno;
			n += sprintf(buf + n, "mmap() = ");
			if (cp)
				n += sprintf(buf + n, "%p", cp);
			else
				n += sprintf(buf + n, "NULL");
			errno = saved_errno;
			if (cp == NULL)
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "ioctl", 5) == 0) {
			retval = ioctl(0, 0, 0);
			saved_errno = errno;
			n += sprintf(buf + n, "ioctl() = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "pathconf ", sizeof("pathconf")) == 0) {
			if (sscanf(buf + sizeof("pathconf"), "%s %d",
			  path1, &int1) == 2) {
				retval = pathconf(path1, int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "pathconf(\"%s\", %d) = %d", path1, int1,
				  retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: pathconf path name\n");
		} else if (strncmp(buf, "fpathconf ", sizeof("fpathconf"))
		  == 0) {
			if (sscanf(buf + sizeof("fpathconf"), "%d %d",
			  &int1, &int2) == 2) {
				retval = fpathconf(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fpathconf(%d, %d) = %d", int1, int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fpathconf fd name\n");
		} else if (strncmp(buf, "pipe", 4) == 0) {
			int	twoints[2];

			retval = pipe(twoints);
			saved_errno = errno;
			n += sprintf(buf + n, "pipe(%p) = %d ",
			  twoints, retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, "(%s)",
				  strerror(errno));
			else
				n += sprintf(buf + n, "<%d, %d>",
				  twoints[0], twoints[1]);
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "ctermid", 7) == 0) {
			cp = ctermid(NULL);
			saved_errno = errno;
			n += sprintf(buf + n, "ctermid(NULL) = ");
			errno = saved_errno;
			if (cp)
				n += sprintf(buf + n, "\"%s\"\n", cp);
			else
				n += sprintf(buf + n, "NULL (%s)\n",
					  strerror(errno));
		} else if (strncmp(buf, "sh ", 3) == 0) {
			int	i;

			for (i = 0; buf[i] != '\n'; i++)
				;
			buf[i + 1] = '\0';
			system(buf + 3);
			buf[0] = '\0';
		} else if (strncmp(buf, "cd ", 3) == 0) {
			if (sscanf(buf + 3, "%s", path1) == 1)
				syscall(SYS_chdir, path1);
			buf[0] = '\0';
		} else if (strncmp(buf, "setioorder ", sizeof("setioorder"))
		  == 0) {
			if (sscanf(buf + sizeof("setioorder"), "%d", &int1)
			  == 1) {
				retval = pvm_setioorder(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "setioorder(%d) = %d",
				  int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: setioorder cardinal\n");
		} else if (strncmp(buf, "getioorder", 10) == 0) {
			retval = pvm_getioorder();
			saved_errno = errno;
			n += sprintf(buf + n, "getioorder() = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "setiomode ", sizeof("setiomode"))
		  == 0) {
			if (sscanf(buf + sizeof("setiomode"), "%d %d", &int1,
			  &int2) == 2) {
				retval = pvm_setiomode(int1, int2);
				saved_errno = errno;
				n += sprintf(buf + n, "setiomode(%d, %d) = %d",
				  int1, int2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: setiomode fd mode\n");
		} else if (strncmp(buf, "getiomode ", sizeof("getiomode"))
		  == 0) {
			if (sscanf(buf + sizeof("getiomode"), "%d", &int1)
			  == 1) {
				retval = pvm_getiomode(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "getiomode(%d) = %d",
				  int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: getiomode fd\n");
		} else if (strncmp(buf, "setdefiomode ", sizeof("setdefiomode"))
		  == 0) {
			if (sscanf(buf + sizeof("setdefiomode"), "%d", &int1)
			  == 1) {
				retval = pvm_setdefiomode(int1);
				saved_errno = errno;
				n += sprintf(buf + n, "setdefiomode(%d) = %d",
				  int1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: setdefiomode mode\n");
		} else if (strncmp(buf, "getdefiomode", 12) == 0) {
			retval = pvm_getdefiomode();
			saved_errno = errno;
			n += sprintf(buf + n, "getdefiomode() = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)", strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "opendir ", sizeof("opendir")) == 0) {
			if (sscanf(buf + sizeof("opendir"), "%s", path1) == 1) {
				dp = opendir(path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "opendir(\"%s\") = ", path1);
				if (dp)
					n += sprintf(buf + n, "%p", dp);
				else
					n += sprintf(buf + n, "NULL");
				errno = saved_errno;
				if (dp == NULL)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
		  "usage: opendir path (returns directory descriptor)\n");
		} else if (strncmp(buf, "readdir ", sizeof("readdir")) == 0) {
			if (sscanf(buf + sizeof("readdir"), "%d", &int1) == 1) {
				dp = (DIR *)int1;
				errno = 0;
				dirp = readdir(dp);
				saved_errno = errno;
				n += sprintf(buf + n, "readdir(%p) =", dp);
				if (dirp == NULL) {
					if (saved_errno)
						n += sprintf(buf + n,
						  " NULL (%s)",
						  strerror(saved_errno));
					else
						n += sprintf(buf + n, " NULL");
				} else
					n += sprintf(buf + n, " \"%s\"",
					  dirp->d_name);
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: readdir directory_descriptor\n");
		} else if (strncmp(buf, "closedir ", sizeof("closedir")) == 0) {
			if (sscanf(buf + sizeof("closedir"), "%d", &int1)
			  == 1) {
				dp = (DIR *)int1;
				retval = closedir(dp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "closedir(%p) = %d", dp, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: closedir directory_descriptor\n");
		} else if (strncmp(buf, "rewinddir ", sizeof("rewinddir"))
		  == 0) {
			if (sscanf(buf + sizeof("rewinddir"), "%d", &int1)
			  == 1) {
				dp = (DIR *)int1;
				rewinddir(dp);
				n += sprintf(buf + n, "rewinddir(%p)\n", dp);
			} else
				n += sprintf(buf + n,
				  "usage: rewinddir directory_descriptor\n");
		} else if (strncmp(buf, "clearerr ", sizeof("clearerr")) == 0) {
			if (sscanf(buf + sizeof("clearerr"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else {
					clearerr(gfp[int1].fp);
					retval = 0;
				}
				n += sprintf(buf + n, "clearerr(%d)", int1);
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: clearerr fp_descriptor\n");
		} else if (strncmp(buf, "fclose ", sizeof("fclose")) == 0) {
			if (sscanf(buf + sizeof("fclose"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else {
					retval = fclose(gfp[int1].fp);
					gfp[int1].used = 0;
				}
				saved_errno = errno;
				n += sprintf(buf + n, "fclose(%d) = ", int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%d", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fclose fp_descriptor\n");
		} else if (strncmp(buf, "fdopen ", sizeof("fdopen")) == 0) {
			if (sscanf(buf + sizeof("fdopen"), "%d %s", &int1,
			  path1) == 2) {
				for (int2 = 0; int2 < NUMFPS; int2++)
					if (gfp[int2].used == 0)
						break;
				if (int2 == NUMFPS) {
					retval = -1;
					errno = ENOMEM;
				} else if (fp = fdopen(int1, path1)) {
					gfp[int2].fp = fp;
					gfp[int2].used = 1;
					retval = int2;
				} else
					retval = -1;
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fdopen(%d, \"%s\") = ", int1, path1);
				if (retval >= 0)
					n += sprintf(buf + n, "%d", retval);
				else
					n += sprintf(buf + n, "NULL");
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fdopen fd path\n");
		} else if (strncmp(buf, "feof ", sizeof("feof")) == 0) {
			if (sscanf(buf + sizeof("feof"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = feof(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "feof(%d) = %d", int1, retval);
				errno = saved_errno;
				if (retval && ferror(gfp[int1].fp))
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: feof fp_descriptor\n");
		} else if (strncmp(buf, "ferror ", sizeof("ferror")) == 0) {
			if (sscanf(buf + sizeof("ferror"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = ferror(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "ferror(%d) = %d", int1, retval);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: ferror fp_descriptor\n");
		} else if (strncmp(buf, "fflush ", sizeof("fflush")) == 0) {
			if (sscanf(buf + sizeof("fflush"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fflush(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fflush(%d) = ", int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%d", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fflush fp_descriptor\n");
		} else if (strncmp(buf, "fgetc ", sizeof("fgetc")) == 0) {
			if (sscanf(buf + sizeof("fgetc"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fgetc(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fgetc(%d) = ", int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF && ferror(gfp[int1].fp))
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fgetc fp_descriptor\n");
#if !defined(IMA_SUN4) && !defined(IMA_CNVXN)
		} else if (strncmp(buf, "fgetpos ", sizeof("fgetpos")) == 0) {
			if (sscanf(buf + sizeof("fgetpos"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fgetpos(gfp[int1].fp,
					  &fpos1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fgetpos(%d, %p) = %d <%ld>", int1, &fpos1,
				  retval, (long)fpos1);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fgetpos fp_descriptor\n");
#endif
		} else if (strncmp(buf, "fgets ", sizeof("fgets")) == 0) {
			if (sscanf(buf + sizeof("fgets"), "%d", &int1)
			  == 1) {
				errno = 0;
				if (gfp[int1].used == 0) {
					cp = NULL;
					errno = EBADF;
				} else
					cp = fgets(rwbuf, sizeof rwbuf - 1,
					  gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fgets(%p, %ld, %d) = ", rwbuf,
				  sizeof rwbuf - 1, int1);
				if (cp)
					n += sprintf(buf + n, "%p", cp);
				else
					n += sprintf(buf + n, "NULL");
				errno = saved_errno;
				if (cp == NULL && (errno == EBADF
				  || ferror(gfp[int1].fp)))
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fgets fp_descriptor\n");
		} else if (strncmp(buf, "fileno ", sizeof("fileno")) == 0) {
			if (sscanf(buf + sizeof("fileno"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fileno(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n, "fileno(%d) = %d", int1,
				  retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fileno fp_descriptor\n");
		} else if (strncmp(buf, "fopen ", sizeof("fopen")) == 0) {
			if (sscanf(buf + sizeof("fopen"), "%s %s", path1,
			  path2) == 2) {
				for (int1 = 0; int1 < NUMFPS; int1++)
					if (gfp[int1].used == 0)
						break;
				if (int1 == NUMFPS) {
					retval = -1;
					errno = ENOMEM;
				} else if (fp = fopen(path1, path2)) {
					gfp[int1].fp = fp;
					gfp[int1].used = 1;
					retval = int1;
				} else
					retval = -1;
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fopen(\"%s\", \"%s\") = ", path1, path2);
				if (retval >= 0)
					n += sprintf(buf + n, "%d", retval);
				else
					n += sprintf(buf + n, "NULL");
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
			  "usage: fopen path mode (returns fp_descriptor)\n");
		} else if (strncmp(buf, "fprintf ", sizeof("fprintf")) == 0) {
			if (sscanf(buf + sizeof("fprintf"), "%d %s", &int1,
			  path1) == 2) {
				strcat(path1, "\n");
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fprintf(gfp[int1].fp,
					  path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fprintf(%d, \"%s\") = %d", int1, path1,
				  retval);
				errno = saved_errno;
				if (retval < 0)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fprintf fp_descriptor string\n");
		} else if (strncmp(buf, "fputc ", sizeof("fputc")) == 0) {
			if (sscanf(buf + sizeof("fputc"), "%o %d", &int1,
			  &int2) == 2) {
				if (gfp[int2].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fputc(int1, gfp[int2].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fputc(%o, %d) = ", int1, int2);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
			  "usage: fputc octal_char fp_descriptor string\n");
		} else if (strncmp(buf, "fputs ", sizeof("fputs")) == 0) {
			long1 = 0;
			if (sscanf(buf + sizeof("fputs"), "%d %ld",
			  &int1, &long1) == 2 || sscanf(buf + sizeof("fputs"),
			  "%d", &int1) == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fputs(rwbuf + long1,
					  gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fputs(%p, %d) = %d", rwbuf + long1, int1,
				  retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else if (sscanf(buf + sizeof("fputs"), "%s %d", path1,
			  &int1) == 2) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fputs(path1, gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fputs(%p, %d) = ", path1, int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%d", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else {
				n += sprintf(buf + n,
				  "usage: fputs string fp_descriptor\n");
				n += sprintf(buf + n,
				  "or fputs fp_descriptor [offset]\n");
			}
		} else if (strncmp(buf, "fread ", sizeof("fread")) == 0) {
			long1 = 0;
			if (sscanf(buf + sizeof("fread"), "%d %d %ld", &int1,
			  &int2, &long1) == 3
			  || sscanf(buf + sizeof("fread"), "%d %d", &int1,
			  &int2) == 2) {
				if (gfp[int2].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fread(rwbuf + long1, 1, int1, 
					  gfp[int2].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fread(%p, 1, %d, %d) = %d\n", rwbuf + long1,
				  int1, int2, retval);
			} else
				n += sprintf(buf + n,
			  "usage: fread nbytes fp_descriptor [offset]\n");
		} else if (strncmp(buf, "freopen ", sizeof("freopen")) == 0) {
			if (sscanf(buf + sizeof("freopen"), "%s %s %d", path1,
			  path2, &int1) == 3) {
				if (gfp[int1].used == 0) {
					retval = 0;
					errno = EBADF;
				} else if (gfp[int1].fp = freopen(path1,
				  path2, gfp[int1].fp)) {
					retval = int1;
				} else
					retval = 0;
				saved_errno = errno;
				n += sprintf(buf + n,
				  "freopen(\"%s\", \"%s\", %d) = %d", path1,
				    path2, int1, retval);
				errno = saved_errno;
				if (retval == 0)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: freopen path mode fp_descriptor\n");
		} else if (strncmp(buf, "fseek ", sizeof("fseek")) == 0) {
			if (sscanf(buf + sizeof("fseek"), "%d %ld %d", &int1,
			  &long1, &int2) == 3) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fseek(gfp[int1].fp, long1,
					  int2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fseek(%d, %ld, %d) = %d", int1, long1,
				  int2, retval);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fseek fp_descriptor offset whence\n");
#if !defined(IMA_SUN4) && !defined(IMA_CNVXN)
		} else if (strncmp(buf, "fsetpos ", sizeof("fsetpos")) == 0) {
			if (sscanf(buf + sizeof("fsetpos"), "%d %ld", &int1,
			  &long1) == 2) {
				fpos1 = long1;
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fsetpos(gfp[int1].fp,
					  &fpos1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fsetpos(%d, <%ld>) = %d", int1, (long)fpos1,
				  retval);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: fsetpos fp_descriptor offset\n");
#endif
		} else if (strncmp(buf, "ftell ", sizeof("ftell")) == 0) {
			if (sscanf(buf + sizeof("ftell"), "%d", &int1) == 1) {
				if (gfp[int1].used == 0) {
					long1 = -1L;
					errno = EBADF;
				} else
					long1 = ftell(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "ftell(%d) = %ld", int1, long1);
				errno = saved_errno;
				if (long1 == -1L)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: ftell fp_descriptor\n");
		} else if (strncmp(buf, "fwrite ", sizeof("fwrite")) == 0) {
			long1 = 0;
			if (sscanf(buf + sizeof("fwrite"), "%d %d %ld", &int1,
			  &int2, &long1) == 3 || sscanf(buf + sizeof("fwrite"),
			  "%d %d", &int1, &int2) == 2) {
				if (gfp[int2].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = fwrite(rwbuf + long1, 1, int1, 
					  gfp[int2].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "fwrite(%p, 1, %d, %d) = %d", rwbuf + long1,
				  int1, int2, retval);
				if (ferror(gfp[int2].fp))
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
			  "usage: fwrite nbytes fp_descriptor [offset]\n");
		} else if (strncmp(buf, "getc ", sizeof("getc")) == 0) {
			if (sscanf(buf + sizeof("getc"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = getc(gfp[int1].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "getc(%d) = ", int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF && ferror(gfp[int1].fp))
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: getc fp_descriptor\n");
		} else if (strncmp(buf, "getchar", 7) == 0) {
			retval = getchar();
			saved_errno = errno;
			n += sprintf(buf + n, "getchar() = ");
			if (retval == EOF)
				n += sprintf(buf + n, "EOF");
			else
				n += sprintf(buf + n, "%o", retval);
			errno = saved_errno;
			if (retval == EOF && ferror(stdin))
				n += sprintf(buf + n, " (%s)",
				  strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "gets", 4) == 0) {
			cp = gets(rwbuf);
			saved_errno = errno;
			n += sprintf(buf + n, "gets(%p) = ", rwbuf);
			if (cp)
				n += sprintf(buf + n, "%p", cp);
			else
				n += sprintf(buf + n, "NULL");
			errno = saved_errno;
			if (cp == NULL && ferror(stdin))
				n += sprintf(buf + n, " (%s)", strerror(errno));
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "perror ", sizeof("perror")) == 0) {
			if (sscanf(buf + sizeof("perror"), "%s", path1) == 1) {
				strcat(path1, "\n");
				perror(path1);
				n += sprintf(buf + n, "perror(%s)\n", path1);
			} else
				n += sprintf(buf + n,
				  "usage: perror string\n");
		} else if (strncmp(buf, "printf ", sizeof("printf")) == 0) {
			if (sscanf(buf + sizeof("printf"), "%s", path1)
			  == 1) {
				strcat(path1, "\n");
				retval = printf(path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "printf(\"%s\") = %d", path1, retval);
				errno = saved_errno;
				if (retval < 0)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: printf string\n");
		} else if (strncmp(buf, "putc ", sizeof("putc")) == 0) {
			if (sscanf(buf + sizeof("putc"), "%o %d", &int1,
			  &int2) == 2) {
				if (gfp[int2].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = putc(int1, gfp[int2].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "putc(%o, %d) = ", int1, int2);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: putc octal_char fp_descriptor\n");
		} else if (strncmp(buf, "putchar ", sizeof("putchar")) == 0) {
			if (sscanf(buf + sizeof("putchar"), "%o", &int1) == 1) {
				retval = putchar(int1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "putchar(%o) = ", int1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: putchar char\n");
		} else if (strncmp(buf, "puts ", sizeof("puts")) == 0) {
			if (sscanf(buf + sizeof("puts"), "%s", path1) == 1) {
				retval = puts(path1);
				saved_errno = errno;
				n += sprintf(buf + n, "puts(%s) = ", path1);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%d", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: puts string\n");
		} else if (strncmp(buf, "remove ", sizeof("remove")) == 0) {
			if (sscanf(buf + sizeof("remove"), "%s", path1) == 1) {
				retval = remove(path1);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "remove(%s) = %d", path1, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n, "usage: remove path\n");
		} else if (strncmp(buf, "rename ", sizeof("rename")) == 0) {
			if (sscanf(buf + sizeof("rename"), "%s %s", path1,
			  path2) == 2) {
				retval = rename(path1, path2);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "rename(%s, %s) = %d", path1, path2, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: rename path1 path2\n");
		} else if (strncmp(buf, "rewind ", sizeof("rewind")) == 0) {
			if (sscanf(buf + sizeof("rewind"), "%d", &int1)
			  == 1) {
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else {
					rewind(gfp[int1].fp);
					retval = 0;
				}
				saved_errno = errno;
				n += sprintf(buf + n, "rewind(%d)", int1);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: rewind fp_descriptor\n");
		} else if (strncmp(buf, "setbuf ", sizeof("setbuf")) == 0) {
			if (sscanf(buf + sizeof("setbuf"), "%d %d", &int1,
			  &int2) == 2) {
				retval = 0;
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else if (int2) {
					if (cp = malloc(BUFSIZ)) 
						setbuf(gfp[int1].fp, cp);
					else
						retval = EOF;
				} else
					setbuf(gfp[int1].fp, NULL);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "setbuf(%d, %p) = %d", int1, int2, retval);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: setbuf fp_descriptor [01]\n");
		} else if (strncmp(buf, "setvbuf ", sizeof("setvbuf")) == 0) {
			if (sscanf(buf + sizeof("setvbuf"), "%d %d %d",
			  &int1, &int2, &int3) == 3) {
				cp = NULL;
				if (gfp[int1].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else if (int2) {
					if (cp = malloc(BUFSIZ)) 
						retval = setvbuf(gfp[int1].fp,
						  cp, int3, BUFSIZ);
					else
						retval = EOF;
				} else
					retval = setvbuf(gfp[int1].fp, NULL,
					  int3, 0);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "setvbuf(%d, %p, %d, %d) = %d", int1, cp,
				  int3, cp ? BUFSIZ : 0, retval);
				errno = saved_errno;
				if (retval)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: setvbuf fp_descriptor [01] mode\n");
		} else if (strncmp(buf, "strerror ", sizeof("strerror")) == 0) {
			if (sscanf(buf + sizeof("strerror"), "%d", &int1)
			  == 1) {
				n += sprintf(buf + n, "strerror(%d) = %s\n",
				  int1, strerror(int1));
			} else
				n += sprintf(buf + n,
				  "usage: strerror errno\n");
		} else if (strncmp(buf, "system", 6) == 0) {
			cp = buf + 6;
			if (*cp == '\0' || *cp == ' ' || *cp == '\t') {
				retval = system(path1);
				n += sprintf(buf + n, "system(%s) = %d\n",
				  path1, retval);
			} else
				n += sprintf(buf + n,
				  "usage: system [string]\n");
		} else if (strncmp(buf, "ungetc ", sizeof("ungetc")) == 0) {
			if (sscanf(buf + sizeof("ungetc"), "%o %d", &int1,
			  &int2) == 2) {
				if (gfp[int2].used == 0) {
					retval = EOF;
					errno = EBADF;
				} else
					retval = ungetc(int1, gfp[int2].fp);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "ungetc(%o, %d) = ", int1, int2);
				if (retval == EOF)
					n += sprintf(buf + n, "EOF");
				else
					n += sprintf(buf + n, "%o", retval);
				errno = saved_errno;
				if (retval == EOF)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: ungetc octal_char fp_descriptor\n");
		} else if (strncmp(buf, "getcwd", 6) == 0) {
			cp = getcwd(path1, sizeof path1);
			saved_errno = errno;
			n += sprintf(buf + n, "getcwd(...) = ");
			if (!cp)
				n += sprintf(buf + n, "NULL (%s)",
				  strerror(saved_errno));
			else
				n += sprintf(buf + n, "\"%s\"", cp);
			n += sprintf(buf + n, "\n");
		} else if (strncmp(buf, "getrlimit ", sizeof("getrlimit"))
		  == 0) {
			if (sscanf(buf + sizeof("getrlimit"), "%d", &int1)
			  == 1) {
				retval = getrlimit(int1, &rl);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "getrlimit(%d, %p) = %d", int1, &rl, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				else {
					n += sprintf(buf + n, " <rlim_cur = ");
					if (rl.rlim_cur == RLIM_INFINITY)
						n += sprintf(buf + n, "INF");
					else
						n += sprintf(buf + n, "%lu",
						  (unsigned long)rl.rlim_cur);
					n += sprintf(buf + n, ", rlim_max = ");
					if (rl.rlim_max == RLIM_INFINITY)
						n += sprintf(buf + n, "INF");
					else
						n += sprintf(buf + n, "%lu",
						  (unsigned long)rl.rlim_max);
					n += sprintf(buf + n, ">");
				}
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				  "usage: getrlimit resource\n");
		} else if (strncmp(buf, "setrlimit ", sizeof("setrlimit"))
		  == 0) {
			int2 = 0;
			if (sscanf(buf + sizeof("setrlimit"), "%d %lu %lu",
			  &int1, &ul1, &ul2) == 3) {
				rl.rlim_cur = ul1;
				rl.rlim_max = ul2;
				int2 = 1;
			} else if (sscanf(buf + sizeof("setrlimit"),
			  "%d INF %lu", &int1, &ul1) == 2) {
				rl.rlim_cur = RLIM_INFINITY;
				rl.rlim_max = ul1;
				int2 = 1;
			} else if (sscanf(buf + sizeof("setrlimit"),
			  "%d %lu INF", &int1, &ul1) == 2) {
				rl.rlim_cur = ul1;
				rl.rlim_max = RLIM_INFINITY;
				int2 = 1;
			} else if (sscanf(buf + sizeof("setrlimit"),
			  "%d INF INF", &int1) == 1) {
				rl.rlim_cur = rl.rlim_max = RLIM_INFINITY;
				int2 = 1;
			}
			if (int2) {
				retval = setrlimit(int1, &rl);
				saved_errno = errno;
				n += sprintf(buf + n,
				  "setrlimit(%d, %p) = %d", int1, &rl, retval);
				errno = saved_errno;
				if (retval == -1)
					n += sprintf(buf + n, " (%s)",
					  strerror(errno));
				n += sprintf(buf + n, "\n");
			} else
				n += sprintf(buf + n,
				 "usage: setrlimit resource cur|INF max|INF\n");
		} else if (strncmp(buf, "getdtablesize", 13) == 0) {
			retval = getdtablesize();
			saved_errno = errno;
			n += sprintf(buf + n, "getdtablesize() = %d", retval);
			errno = saved_errno;
			if (retval == -1)
				n += sprintf(buf + n, " (%s)", strerror(errno));
			n += sprintf(buf + n, "\n");
#if 0
		} else if (strncmp(buf, "OPEN ", sizeof("OPEN")) == 0) {
			if ((int2 = sscanf(buf + sizeof("OPEN"), "%d %s %s",
			  &int1, path1, path2)) == 3)
				f77open_(path1, strlen(path1), path2,
				  strlen(path2));
			else if ((int2 = sscanf(buf + sizeof("OPEN"), "%d %s",
			  &int1, path1)) == 2)
				f77open_(path1, strlen(path1), "UNKNOWN", 7);
			if (int2 == 2 || int2 == 3)
				n += sprintf(buf + n,
				  "OPEN(%d, FILE = \"%s\", STATUS = \"%s\")\n",
				  int1, path1, int2 == 3 ? path2 : "UNKNOWN");
			else
				n += sprintf(buf + n,
				  "usage: OPEN path [STATUS]\n");
		} else if (strncmp(buf, "READ ", sizeof("READ")) == 0) {
			if ((int2 = sscanf(buf + sizeof("READ"), "%d %s %s",
			  &int1, path1, path2)) == 3)
				f77open_(path1, strlen(path1), path2,
				  strlen(path2));
			else if ((int2 = sscanf(buf + sizeof("READ"), "%d %s",
			  &int1, path1)) == 2)
				f77open_(path1, strlen(path1), "UNKNOWN", 7);
			if (int2 == 2 || int2 == 3)
				n += sprintf(buf + n,
				  "READ(%d, FILE = \"%s\", STATUS = \"%s\")\n",
				  int1, path1, int2 == 3 ? path2 : "UNKNOWN");
			else
				n += sprintf(buf + n,
				  "usage: READ path [STATUS]\n");
		} else if (strncmp(buf, "CLOSE ", sizeof("CLOSE")) == 0) {
			if (sscanf(buf + sizeof("CLOSE"), "%d", &int1) == 1) {
				retval = f77close_(int1);
				n += sprintf(buf + n, "CLOSE(%d)\n", int1);
			} else
				n += sprintf(buf + n,
				  "usage: OPEN path [STATUS]\n");
#endif
		} else
			n += sprintf(buf + n, "Command not found\n");

bottom:
		n += sprintf(buf + n, "%s", prompt);
		write(1, buf, n);
	}

	if (n == -1 && errno == EINTR) {
		write(1, "got EINTR\n", 10);
		goto top;
	}

	pvm_exit();
	exit(0);
}
