/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <unistd.h>

#ifdef IMA_SUN4
#define WRITE_RETURN_TYPE	int
#define WRITE_ARG2_TYPE		char *
#define WRITE_ARG3_TYPE		unsigned
#define READ_RETURN_TYPE	int
#define READ_ARG2_TYPE		char *
#define READ_ARG3_TYPE		unsigned
#elif defined(IMA_PMAX)
#define WRITE_RETURN_TYPE	int
#define WRITE_ARG2_TYPE		char *
#define WRITE_ARG3_TYPE		int
#define READ_RETURN_TYPE	int
#define READ_ARG2_TYPE		char *
#define READ_ARG3_TYPE		int
#elif defined(IMA_ALPHA) || defined(IMA_CNVXN) || defined(IMA_RS6K)
#define WRITE_RETURN_TYPE	ssize_t
#define WRITE_ARG2_TYPE		const void *
#define WRITE_ARG3_TYPE		size_t
#define READ_RETURN_TYPE	ssize_t
#define READ_ARG2_TYPE		void *
#define READ_ARG3_TYPE		size_t
#define WRITEV_RETURN_TYPE	int
#define READV_RETURN_TYPE	int
#endif
#ifndef WRITEV_RETURN_TYPE
#define WRITEV_RETURN_TYPE	WRITE_RETURN_TYPE
#endif
#ifndef READV_RETURN_TYPE
#define READV_RETURN_TYPE	READ_RETURN_TYPE
#endif
#ifndef WRITEV_CONST
#define WRITEV_CONST
#endif
#ifndef READV_CONST
#define READV_CONST
#endif
#ifndef SETRLIMIT_CONST
#define SETRLIMIT_CONST
#endif

#ifdef IMA_RS6K
#define SELECT_ARG1_TYPE	unsigned long
#define SELECT_SETP_TYPE	void *
#else
#define SELECT_ARG1_TYPE	int
#define SELECT_SETP_TYPE	fd_set *
#endif
