/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>

char *
basename(s)
char *s;
{
	char	*lastslash;

	if (lastslash = strrchr(s, '/'))
		return lastslash + 1;
	else
		return s;
}

int
main(argc, argv)
int argc;
char **argv;
{
	int	i;
	size_t	len;
	char	buf[1000];
	int	status;
	int	got_o = 0;
	int	got_E = 0;
	int	got_P = 0;
	int	cfiles = 0;
	pid_t	pid;

	/* argv[1] is the actual compiler */

	for (i = 2; i < argc; i++)
		if (strcmp(argv[i], "-o") == 0)
			got_o = 1;
		else if (strcmp(argv[i], "-E") == 0)
			got_E = 1;
		else if (strcmp(argv[i], "-P") == 0)
			got_P = 1;

	for (i = 2; i < argc; i++) {
		len = strlen(argv[i]);
		if (len > 2 && argv[i][len - 2] == '.'
		  && argv[i][len - 1] == 'c')
			cfiles++;
	}

	if (cfiles > 1)
		exit(1);
	else if (cfiles == 0) {
		argv++;
		execvp(argv[0], argv);
		exit(1);
	}

	/* cfiles == 1 */
	for (i = 2; i < argc; i++) {
		len = strlen(argv[i]);
		if (len > 2 && argv[i][len - 2] == '.'
		  && argv[i][len - 1] == 'c') {
			strcpy(buf, "regress ");
			strcat(buf, argv[i]);
			strcat(buf, " _temp.c");
			if (status = system(buf))
				exit(status);
			if (!got_o && !got_E) {
				char	**newargv;
				int	j;

				newargv = malloc((argc + 2) * sizeof(*newargv));
				if (!newargv)
					exit(1);
				for (j = 0; j < argc - 1; j++)
					newargv[j] = argv[j + 1];
				if ((newargv[argc] = malloc(3)) == NULL)
					exit(1);
				newargv[argc - 1] = "-o";
				argv[i][len - 1] = got_P ? 'i' : 'o';
				newargv[argc] = basename(argv[i]);
				newargv[i - 1] = "_temp.c";
				newargv[argc + 1] = NULL;
				argv = newargv;
			} else {
				argv[i] = "_temp.c";
				argv++;
			}
			switch (pid = fork()) {
			case -1:
			case 0:
				execvp(argv[0], argv);
				exit(1);
			default:
				while (wait(&status) != pid)
					;
				if (WIFEXITED(status)) {
					remove("_temp.c");
					exit(0);
				} else
					exit(WEXITSTATUS(status));
			}
		}
	}

	/* NOTREACHED */
	exit(1);
}
