/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

/*
 * Quick and dirty converter of
 * ANSI C function headers to K&R function headers
 *
 * This program changes lines of the form
 *
 *	^[_a-zA-Z0-9$][_a-zA-Z0-9$](.*)$
 *
 * so that (as an example)

func(   char * const b, int s, struct   a       * c     )

 * becomes

func(b, s, c) char *b; int s; struct a *c;

 * All other lines, including function prototypes, remain unchanged.
 *
 * Note especially that it doesn't deal with ellipses...
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int
needs_changed(s)
char *s;
{
	int	i;
	int	len = strlen(s);

	for (i = 0; isalnum(s[i]) || s[i] == '_' || s[i] == '$'; i++)
		;
	return (i >= 1 && s[i] == '(' && s[len - 2] == ')');
}

void
delconst(s, end)
char *s, *end;
{
	char	*prev = NULL;

	s--;
	while (*++s != ';' && s < end) {
		if (*s == 'c' && (!prev || !isalnum(*prev) && *prev != '_'))
			if (strncmp(s, "const", 5) == 0)
				if (!isalnum(s[5]) && s[5] != '_') {
					strncpy(s, "     ", 5);
					s += 5;
				}
		prev = s;
	}
}

char *
nonwhite(s)
char *s;
{
	while (isspace(*++s))
		;
	return s;
}

void
squeeze(s)
char *s;
{
	char	*prev = NULL;
	char	buf[BUFSIZ];
	char	*p = buf;
	char	*next;

	strcpy(buf, s);

	p--;
	while (*++p != '\n') {
		if (*p == '\t')
			*p = ' ';
		if (!isspace(*p) || (prev && !isspace(*prev) && *prev != '*'
		  && *prev != '(' && *prev != '['
		  && *(next = nonwhite(p)) != ';' && *next != ','
		  && *next != ')' && *next != ']' && *next != '[')) {
			*s++ = *p;
			if (*p == ')' && !isspace(p[1]))
				*s++ = ' ';
		}
		prev = p;
	}
	*s++ = '\n';
	*s = '\0';
}

int
justvoid(s)
char *s;
{
	s--;
	return *(s = nonwhite(s)) == 'v'
	  && *(s = nonwhite(s)) == 'o'
	  && *(s = nonwhite(s)) == 'i'
	  && *(s = nonwhite(s)) == 'd'
	  && *(s = nonwhite(s)) == ')';
}

int
valist(s)
char *s;
{
	s--;
	return *(s = nonwhite(s)) == 'v'
	  && *(s = nonwhite(s)) == 'a'
	  && *(s = nonwhite(s)) == '_'
	  && *(s = nonwhite(s)) == 'a'
	  && *(s = nonwhite(s)) == 'l'
	  && *(s = nonwhite(s)) == 'i'
	  && *(s = nonwhite(s)) == 's'
	  && *(s = nonwhite(s)) == 't'
	  && *(s = nonwhite(s)) == ')';
}

void
change_it(s)
char *s;
{
	int	i;
	int	len;
	int	hasparams;
	char	params[BUFSIZ];
	char	types[BUFSIZ];
	char	*begin, *end;
	char	*p, *q;

	while (*s++ != '(')
		;

	if (justvoid(s)) {
		strcpy(s, ")\n");
		return;
	} else if (valist(s)) {
		strcpy(s, "va_alist)\n");
		return;
	}

	delconst(s, s + strlen(s));

	strcpy(types, s);
	strcpy(params, s);

	len = strlen(types);
	hasparams = 0;
	for (i = 0; i < len; i++)
		if (types[i] == ',')
			types[i] = ';';
		else if (!hasparams && isalnum(types[i]))
			hasparams = 1;
		else if (types[i] == ')')
			if (hasparams)
				types[i] = ';';
			else {
				types[i] = '\n';
				types[i + 1] = '\0';
			}
	
	begin = params;
	do {
		if ((end = strchr(begin, ',')) == NULL)
			end = strchr(begin, ')');
		for (p = end, q = p - 1; p > begin && isspace(*q);
		  p--, q = p - 1)
			;
		for (; p > begin; p--) {
			q = p - 1;
			if (!isalnum(*q) && *q != '_' && *q != '$') {
				if (*q == ']') {
					*q = ' ';
					for (p--; p > begin; p--) {
						q = p - 1;
						if (*q == '[')
							break;
						else
							*q = ' ';
					}
					*q = ' ';
					for (p--, q = p - 1;
					  p > begin && isspace(*q);
					  p--, q = p - 1)
						;
				} else
					break;
			}
		}
		while (p != begin)
			*--p = ' ';
		begin = end + 1;
	} while (*end != ')');

	params[strlen(params) - 1] = '\0';	/* zap '\n' */
	strcpy(s, params);
	strcat(s, types);

	squeeze(s);
}

int
main(argc, argv)
int argc;
char  **argv;
{
	char	buf[BUFSIZ];
	FILE	*fp1 = stdin;
	FILE	*fp2 = stdout;

	if (argc > 3) {
		fprintf(stderr, "Usage: %s [input [output]]\n", argv[0]);
		exit(1);
	}
	if (argc > 2 && (fp2 = fopen(argv[2], "w")) == NULL) {
		fprintf(stderr, "%s: can't open %s\n", argv[0], argv[2]);
		exit(1);
	}
	if (argc > 1 && (fp1 = fopen(argv[1], "r")) == NULL) {
		fprintf(stderr, "%s: can't read %s\n", argv[0], argv[1]);
		exit(1);
	}

	while (fgets(buf, sizeof buf, fp1)) {
		if (needs_changed(buf))
			change_it(buf);
		if (fputs(buf, fp2) == EOF) {
			perror(argc < 3 ? "stdout" : argv[2]);
			exit(1);
		}
	}
	if (ferror(fp1)) {
		perror(argc < 2 ? "stdin" : argv[1]);
		exit(1);
	}

	exit(0);
}
