/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#ifndef FS_H
#define FS_H

#define PVMFS_O_RDONLY		0x0001
#define PVMFS_O_WRONLY		0x0002
#define PVMFS_O_RDWR		0x0004
#define PVMFS_O_APPEND		0x0008
#define PVMFS_O_CREAT		0x0010
#define PVMFS_O_EXCL		0x0020
#define PVMFS_O_TRUNC		0x0040
#define PVMFS_O_NOCTTY		0x0080
#define PVMFS_O_NONBLOCK	0x0100
#define PVMFS_O_SYNC		0x0200
#define PVMFS_O_ASYNC		0x0400
#define PVMFS_O_LARGEFILE	0x0800

#define PVMFS_S_IRUSR	0400
#define PVMFS_S_IWUSR	0200
#define PVMFS_S_IXUSR	0100
#define PVMFS_S_IRGRP	0040
#define PVMFS_S_IWGRP	0020
#define PVMFS_S_IXGRP	0010
#define PVMFS_S_IROTH	0004
#define PVMFS_S_IWOTH	0002
#define PVMFS_S_IXOTH	0001

#define PVMFS_SEEK_SET	0
#define PVMFS_SEEK_CUR	1
#define PVMFS_SEEK_END	2

#define PVMFS_F_DUPFD	0
#define PVMFS_F_GETFD	1
#define PVMFS_F_SETFD	2
#define PVMFS_F_GETFL	3
#define PVMFS_F_SETFL	4
#define PVMFS_F_GETOWN	5
#define PVMFS_F_SETOWN	6
#define PVMFS_F_GETLK	7
#define PVMFS_F_SETLK	8
#define PVMFS_F_SETLKW	9

#define PVMFS_F_RDLCK	0
#define PVMFS_F_WRLCK	1
#define PVMFS_F_UNLCK	2

#define PVMFS_F_OK	0
#define PVMFS_X_OK	1
#define PVMFS_W_OK	2
#define PVMFS_R_OK	4

#define PVMFS_TCOOFF	0
#define PVMFS_TCOON	1
#define PVMFS_TCIOFF	2
#define PVMFS_TCION	3

#define PVMFS_TCIFLUSH	0
#define PVMFS_TCOFLUSH	1
#define PVMFS_TCIOFLUSH	2

#define PVMFS_TCSANOW	0
#define PVMFS_TCSADRAIN	1
#define PVMFS_TCSAFLUSH	2

#define PVMFS_BRKINT	0x0001
#define PVMFS_ICRNL	0x0002
#define PVMFS_IGNBRK	0x0004
#define PVMFS_IGNCR	0x0008
#define PVMFS_IGNPAR	0x0010
#define PVMFS_IMAXBEL	0x0020
#define PVMFS_INLCR	0x0040
#define PVMFS_INPCK	0x0080
#define PVMFS_ISTRIP	0x0100
#define PVMFS_IUCLC	0x0200
#define PVMFS_IXANY	0x0400
#define PVMFS_IXOFF	0x0800
#define PVMFS_IXON	0x1000
#define PVMFS_PARMRK	0x2000

#define PVMFS_BSDLY	0x00000001
#define PVMFS_BS0	0x00000002
#define PVMFS_BS1	0x00000004
#define PVMFS_CRDLY	0x00000008
#define PVMFS_CR0	0x00000010
#define PVMFS_CR1	0x00000020
#define PVMFS_CR2	0x00000040
#define PVMFS_CR3	0x00000080
#define PVMFS_FFDLY	0x00000100
#define PVMFS_FF0	0x00000200
#define PVMFS_FF1	0x00000400
#define PVMFS_NLDLY	0x00000800
#define PVMFS_NL0	0x00001000
#define PVMFS_NL1	0x00002000
#define PVMFS_OCRNL	0x00004000
#define PVMFS_OFDEL	0x00008000
#define PVMFS_OFILL	0x00010000
#define PVMFS_OLCUC	0x00020000
#define PVMFS_ONLCR	0x00040000
#define PVMFS_ONLRET	0x00080000
#define PVMFS_ONOCR	0x00100000
#define PVMFS_ONOEOT	0x00200000
#define PVMFS_OPOST	0x00400000
#define PVMFS_OXTABS	0x00800000
#define PVMFS_TABDLY	0x01000000
#define PVMFS_TAB0	0x02000000
#define PVMFS_TAB1	0x04000000
#define PVMFS_TAB2	0x08000000
#define PVMFS_TAB3	0x10000000
#define PVMFS_VTDLY	0x20000000
#define PVMFS_VT0	0x40000000
#define PVMFS_VT1	0x80000000

#define PVMFS_CCTS_OFLOW	0x0001
#define PVMFS_CIGNORE		0x0002
#define PVMFS_CLOCAL		0x0004
#define PVMFS_CREAD		0x0008
#define PVMFS_CRTS_IFLOW	0x0010
#define PVMFS_CSIZE		0x0020
#define PVMFS_CS5		0x0040
#define PVMFS_CS6		0x0080
#define PVMFS_CS7		0x0100
#define PVMFS_CS8		0x0200
#define PVMFS_CSTOPB		0x0400
#define PVMFS_HUPCL		0x0800
#define PVMFS_MDMBUF		0x1000
#define PVMFS_PARENB		0x2000
#define PVMFS_PARODD		0x4000

#define PVMFS_ALTWERASE		0x000001
#define PVMFS_ECHO		0x000002
#define PVMFS_ECHOCTL		0x000004
#define PVMFS_ECHOE		0x000008
#define PVMFS_ECHOK		0x000010
#define PVMFS_ECHOKE		0x000020
#define PVMFS_ECHONL		0x000040
#define PVMFS_ECHOPRT		0x000080
#define PVMFS_FLUSHO		0x000100
#define PVMFS_ICANON		0x000200
#define PVMFS_IEXTEN		0x000400
#define PVMFS_ISIG		0x000800
#define PVMFS_NOFLSH		0x001000
#define PVMFS_NOKERNINFO	0x002000
#define PVMFS_PENDIN		0x004000
#define PVMFS_TOSTOP		0x008000
#define PVMFS_XCASE		0x010000

#define PVMFS_B0	1
#define PVMFS_B50	2
#define PVMFS_B75	3
#define PVMFS_B110	4
#define PVMFS_B134	5
#define PVMFS_B150	6
#define PVMFS_B200	7
#define PVMFS_B300	8
#define PVMFS_B600	9
#define PVMFS_B1200	10
#define PVMFS_B1800	11
#define PVMFS_B2400	12
#define PVMFS_B4800	13
#define PVMFS_B9600	14
#define PVMFS_B19200	15
#define PVMFS_B38400	16

#define PVMFS__PC_LINK_MAX		10
#define PVMFS__PC_MAX_CANON		11
#define PVMFS__PC_MAX_INPUT		12
#define PVMFS__PC_NAME_MAX		13
#define PVMFS__PC_PATH_MAX		14
#define PVMFS__PC_PIPE_BUF		15
#define PVMFS__PC_CHOWN_RESTRICTED	16
#define PVMFS__PC_NO_TRUNC		17
#define PVMFS__PC_VDISABLE		18
#define PVMFS__SC_OPEN_MAX		19

#define PVMFS_RLIMIT_CORE		0
#define PVMFS_RLIMIT_FSIZE		1
#define PVMFS_RLIMIT_NOFILE		2
#define PVMFS_RLIMIT_OFILE		3

#endif
