/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <stdio.h>
#include <errno.h>
#include "pvmerrno.h"

extern int	errno;

int
pvm_local_errno(int pvmerrno)
{
	switch (pvmerrno) {
	case -2:		return -2;
	case PvmE2BIG:		return E2BIG;
	case PvmEACCES:		return EACCES;
	case PvmEACLBLOCK:	return EACLBLOCK;
	case PvmEACLCMD:	return EACLCMD;
	case PvmEACLDELIM:	return EACLDELIM;
	case PvmEACLDUPGID:	return EACLDUPGID;
	case PvmEACLDUPOTHER:	return EACLDUPOTHER;
	case PvmEACLDUPUID:	return EACLDUPUID;
	case PvmEACLENTRY:	return EACLENTRY;
	case PvmEACLGRPNAM:	return EACLGRPNAM;
	case PvmEACLPERMS:	return EACLPERMS;
	case PvmEACLSORT:	return EACLSORT;
	case PvmEACLSRC:	return EACLSRC;
	case PvmEACLTYPE:	return EACLTYPE;
	case PvmEACLUSRNAM:	return EACLUSRNAM;
	case PvmEADDRINUSE:	return EADDRINUSE;
	case PvmEADDRNOTAVAIL:	return EADDRNOTAVAIL;
	case PvmEADV:		return EADV;
	case PvmEAFNOSUPPORT:	return EAFNOSUPPORT;
	case PvmEAGAIN:		return EAGAIN;
	case PvmEAIO:		return EAIO;
	case PvmEALREADY:	return EALREADY;
	case PvmEBADCHAN:	return EBADCHAN;
	case PvmEBADF:		return EBADF;
	case PvmEBADMSG:	return EBADMSG;
	case PvmEBADRPC:	return EBADRPC;
	case PvmEBUSY:		return EBUSY;
	case PvmECANCELED:	return ECANCELED;
	case PvmECHANASSOC:	return ECHANASSOC;
	case PvmECHANCLEAR:	return ECHANCLEAR;
	case PvmECHILD:		return ECHILD;
	case PvmECHRNG:		return ECHRNG;
	case PvmECLONEME:	return ECLONEME;
	case PvmECOMM:		return ECOMM;
	case PvmECONNABORTED:	return ECONNABORTED;
	case PvmECONNREFUSED:	return ECONNREFUSED;
	case PvmECONNRESET:	return ECONNRESET;
	case PvmEDEADLK:	return EDEADLK;
	case PvmEDESTADDRREQ:	return EDESTADDRREQ;
	case PvmEDIRTY:		return EDIRTY;
	case PvmEDIST:		return EDIST;
	case PvmEDMONBADTYPE:	return EDMONBADTYPE;
	case PvmEDMONCLEAR:	return EDMONCLEAR;
	case PvmEDMONINUSE:	return EDMONINUSE;
	case PvmEDMONRETRY:	return EDMONRETRY;
	case PvmEDMONSUSP:	return EDMONSUSP;
	case PvmEDOM:		return EDOM;
	case PvmEDOTDOT:	return EDOTDOT;
	case PvmEDQUOT:		return EDQUOT;
	case PvmEDUPPKG:	return EDUPPKG;
	case PvmEEXIST:		return EEXIST;
	case PvmEFAIL:		return EFAIL;
	case PvmEFAULT:		return EFAULT;
	case PvmEFBIG:		return EFBIG;
	case PvmEFORMAT:	return EFORMAT;
	case PvmEFTYPE:		return EFTYPE;
	case PvmEHOSTDOWN:	return EHOSTDOWN;
	case PvmEHOSTUNREACH:	return EHOSTUNREACH;
	case PvmEIDRM:		return EIDRM;
	case PvmEINPROG:	return EINPROG;
	case PvmEINPROGRESS:	return EINPROGRESS;
	case PvmEINTR:		return EINTR;
	case PvmEINVAL:		return EINVAL;
	case PvmEIO:		return EIO;
	case PvmEISCONN:	return EISCONN;
	case PvmEISDEV:		return EISDEV;
	case PvmEISDIR:		return EISDIR;
	case PvmEISMIGRATED:	return EISMIGRATED;
	case PvmEISSOCK:	return EISSOCK;
	case PvmEJUSTRETURN:	return EJUSTRETURN;
	case PvmEL2HLT:		return EL2HLT;
	case PvmEL2NSYNC:	return EL2NSYNC;
	case PvmEL3HLT:		return EL3HLT;
	case PvmEL3RST:		return EL3RST;
	case PvmELNRNG:		return ELNRNG;
	case PvmELOOP:		return ELOOP;
	case PvmEMASS:		return EMASS;
	case PvmEMAXLOCALCHAN:	return EMAXLOCALCHAN;
	case PvmEMAXSUSP:	return EMAXSUSP;
	case PvmEMEDIA:		return EMEDIA;
	case PvmEMFILE:		return EMFILE;
	case PvmEMLINK:		return EMLINK;
	case PvmEMSGSIZE:	return EMSGSIZE;
	case PvmEMTIMERS:	return EMTIMERS;
	case PvmEMULTIHOP:	return EMULTIHOP;
	case PvmENAMETOOLONG:	return ENAMETOOLONG;
	case PvmENETDOWN:	return ENETDOWN;
	case PvmENETRESET:	return ENETRESET;
	case PvmENETUNREACH:	return ENETUNREACH;
	case PvmENFILE:		return ENFILE;
	case PvmENOACL:		return ENOACL;
	case PvmENOATTR:	return ENOATTR;
	case PvmENOBUFS:	return ENOBUFS;
	case PvmENOCONNECT:	return ENOCONNECT;
	case PvmENOCSI:		return ENOCSI;
	case PvmENODATA:	return ENODATA;
	case PvmENODEV:		return ENODEV;
	case PvmENODMON:	return ENODMON;
	case PvmENOENT:		return ENOENT;
	case PvmENOEXEC:	return ENOEXEC;
	case PvmENOLCK:		return ENOLCK;
	case PvmENOLINK:	return ENOLINK;
	case PvmENOMEM:		return ENOMEM;
	case PvmENOMSG:		return ENOMSG;
	case PvmENONET:		return ENONET;
	case PvmENOPKG:		return ENOPKG;
	case PvmENOPROTOOPT:	return ENOPROTOOPT;
	case PvmENOSPC:		return ENOSPC;
	case PvmENOSR:		return ENOSR;
	case PvmENOSTR:		return ENOSTR;
	case PvmENOSYM:		return ENOSYM;
	case PvmENOSYS:		return ENOSYS;
	case PvmENOTBLK:	return ENOTBLK;
	case PvmENOTCONN:	return ENOTCONN;
	case PvmENOTDIR:	return ENOTDIR;
	case PvmENOTEMPTY:	return ENOTEMPTY;
	case PvmENOTREADY:	return ENOTREADY;
	case PvmENOTRUST:	return ENOTRUST;
	case PvmENOTSOCK:	return ENOTSOCK;
	case PvmENOTSUP:	return ENOTSUP;
	case PvmENOTTY:		return ENOTTY;
	case PvmENXIO:		return ENXIO;
	case PvmEOPNOTSUPP:	return EOPNOTSUPP;
	case PvmEPERM:		return EPERM;
	case PvmEPFNOSUPPORT:	return EPFNOSUPPORT;
	case PvmEPIPE:		return EPIPE;
	case PvmEPROCLIM:	return EPROCLIM;
	case PvmEPROCUNAVAIL:	return EPROCUNAVAIL;
	case PvmEPROGMISMATCH:	return EPROGMISMATCH;
	case PvmEPROGUNAVAIL:	return EPROGUNAVAIL;
	case PvmEPROTO:		return EPROTO;
	case PvmEPROTONOSUPPORT:return EPROTONOSUPPORT;
	case PvmEPROTOTYPE:	return EPROTOTYPE;
	case PvmERANGE:		return ERANGE;
	case PvmERELOCATED:	return ERELOCATED;
	case PvmEREMCHG:	return EREMCHG;
	case PvmEREMOTE:	return EREMOTE;
	case PvmERESTART:	return ERESTART;
	case PvmEROFS:		return EROFS;
	case PvmERPCMISMATCH:	return ERPCMISMATCH;
	case PvmERREMOTE:	return ERREMOTE;
	case PvmERWOFF:		return ERWOFF;
	case PvmESAD:		return ESAD;
	case PvmESHUTDOWN:	return ESHUTDOWN;
	case PvmESOCKTNOSUPPORT:return ESOCKTNOSUPPORT;
	case PvmESOFT:		return ESOFT;
	case PvmESPIPE:		return ESPIPE;
	case PvmESRCH:		return ESRCH;
	case PvmESRMNT:		return ESRMNT;
	case PvmESTALE:		return ESTALE;
	case PvmESTATECHANGED:	return ESTATECHANGED;
	case PvmESUCCESS:	return ESUCCESS;
	case PvmESUSPCLEAR:	return ESUSPCLEAR;
	case PvmETIME:		return ETIME;
	case PvmETIMEDOUT:	return ETIMEDOUT;
	case PvmETOOMANYREFS:	return ETOOMANYREFS;
	case PvmETPBADFORM:	return ETPBADFORM;
	case PvmETPNOSUPPORT:	return ETPNOSUPPORT;
	case PvmETPTRUNC:	return ETPTRUNC;
	case PvmETXTBSY:	return ETXTBSY;
	case PvmEUNATCH:	return EUNATCH;
	case PvmEUSERS:		return EUSERS;
	case PvmEVERSION:	return EVERSION;
	case PvmEWOULDBLOCK:	return EWOULDBLOCK;
	case PvmEWRPROTECT:	return EWRPROTECT;
	case PvmEXDEV:		return EXDEV;
	case PvmEILSEQ:		return EILSEQ;
	default:		return -1;
	}
}

#include "errnoconf.h"

int
pvmerrno(int errnum)
{
	switch (errnum) {
	case -2:		return -2;
#if E2BIG != -1
	case E2BIG:		return PvmE2BIG;
#endif
#if EACCES != -1
	case EACCES:		return PvmEACCES;
#endif
#if EACLBLOCK != -1
	case EACLBLOCK:		return PvmEACLBLOCK;
#endif
#if EACLCMD != -1
	case EACLCMD:		return PvmEACLCMD;
#endif
#if EACLDELIM != -1
	case EACLDELIM:		return PvmEACLDELIM;
#endif
#if EACLDUPGID != -1
	case EACLDUPGID:	return PvmEACLDUPGID;
#endif
#if EACLDUPOTHER != -1
	case EACLDUPOTHER:	return PvmEACLDUPOTHER;
#endif
#if EACLDUPUID != -1
	case EACLDUPUID:	return PvmEACLDUPUID;
#endif
#if EACLENTRY != -1
	case EACLENTRY:		return PvmEACLENTRY;
#endif
#if EACLGRPNAM != -1
	case EACLGRPNAM:	return PvmEACLGRPNAM;
#endif
#if EACLPERMS != -1
	case EACLPERMS:		return PvmEACLPERMS;
#endif
#if EACLSORT != -1
	case EACLSORT:		return PvmEACLSORT;
#endif
#if EACLSRC != -1
	case EACLSRC:		return PvmEACLSRC;
#endif
#if EACLTYPE != -1
	case EACLTYPE:		return PvmEACLTYPE;
#endif
#if EACLUSRNAM != -1
	case EACLUSRNAM:	return PvmEACLUSRNAM;
#endif
#if EADDRINUSE != -1
	case EADDRINUSE:	return PvmEADDRINUSE;
#endif
#if EADDRNOTAVAIL != -1
	case EADDRNOTAVAIL:	return PvmEADDRNOTAVAIL;
#endif
#if EADV != -1
	case EADV:		return PvmEADV;
#endif
#if EAFNOSUPPORT != -1
	case EAFNOSUPPORT:	return PvmEAFNOSUPPORT;
#endif
#if EAGAIN != -1
	case EAGAIN:		return PvmEAGAIN;
#endif
#if EAIO != -1
	case EAIO:		return PvmEAIO;
#endif
#if EALREADY != -1
	case EALREADY:		return PvmEALREADY;
#endif
#if EBADCHAN != -1
	case EBADCHAN:		return PvmEBADCHAN;
#endif
#if EBADF != -1
	case EBADF:		return PvmEBADF;
#endif
#if EBADMSG != -1
	case EBADMSG:		return PvmEBADMSG;
#endif
#if EBADRPC != -1
	case EBADRPC:		return PvmEBADRPC;
#endif
#if EBUSY != -1
	case EBUSY:		return PvmEBUSY;
#endif
#if ECANCELED != -1
	case ECANCELED:		return PvmECANCELED;
#endif
#if ECHANASSOC != -1
	case ECHANASSOC:	return PvmECHANASSOC;
#endif
#if ECHANCLEAR != -1
	case ECHANCLEAR:	return PvmECHANCLEAR;
#endif
#if ECHILD != -1
	case ECHILD:		return PvmECHILD;
#endif
#if ECHRNG != -1
	case ECHRNG:		return PvmECHRNG;
#endif
#if ECLONEME != -1
	case ECLONEME:		return PvmECLONEME;
#endif
#if ECOMM != -1
	case ECOMM:		return PvmECOMM;
#endif
#if ECONNABORTED != -1
	case ECONNABORTED:	return PvmECONNABORTED;
#endif
#if ECONNREFUSED != -1
	case ECONNREFUSED:	return PvmECONNREFUSED;
#endif
#if ECONNRESET != -1
	case ECONNRESET:	return PvmECONNRESET;
#endif
#if EDEADLK != -1
	case EDEADLK:		return PvmEDEADLK;
#endif
#if EDESTADDRREQ != -1
	case EDESTADDRREQ:	return PvmEDESTADDRREQ;
#endif
#if EDIRTY != -1
	case EDIRTY:		return PvmEDIRTY;
#endif
#if EDIST != -1
	case EDIST:		return PvmEDIST;
#endif
#if EDMONBADTYPE != -1
	case EDMONBADTYPE:	return PvmEDMONBADTYPE;
#endif
#if EDMONCLEAR != -1
	case EDMONCLEAR:	return PvmEDMONCLEAR;
#endif
#if EDMONINUSE != -1
	case EDMONINUSE:	return PvmEDMONINUSE;
#endif
#if EDMONRETRY != -1
	case EDMONRETRY:	return PvmEDMONRETRY;
#endif
#if EDMONSUSP != -1
	case EDMONSUSP:		return PvmEDMONSUSP;
#endif
#if EDOM != -1
	case EDOM:		return PvmEDOM;
#endif
#if EDOTDOT != -1
	case EDOTDOT:		return PvmEDOTDOT;
#endif
#if EDQUOT != -1
	case EDQUOT:		return PvmEDQUOT;
#endif
#if EDUPPKG != -1
	case EDUPPKG:		return PvmEDUPPKG;
#endif
#if EEXIST != -1
	case EEXIST:		return PvmEEXIST;
#endif
#if EFAIL != -1
	case EFAIL:		return PvmEFAIL;
#endif
#if EFAULT != -1
	case EFAULT:		return PvmEFAULT;
#endif
#if EFBIG != -1
	case EFBIG:		return PvmEFBIG;
#endif
#if EFORMAT != -1
	case EFORMAT:		return PvmEFORMAT;
#endif
#if EFTYPE != -1
	case EFTYPE:		return PvmEFTYPE;
#endif
#if EHOSTDOWN != -1
	case EHOSTDOWN:		return PvmEHOSTDOWN;
#endif
#if EHOSTUNREACH != -1
	case EHOSTUNREACH:	return PvmEHOSTUNREACH;
#endif
#if EIDRM != -1
	case EIDRM:		return PvmEIDRM;
#endif
#if EINPROG != -1
	case EINPROG:		return PvmEINPROG;
#endif
#if EINPROGRESS != -1
	case EINPROGRESS:	return PvmEINPROGRESS;
#endif
#if EINTR != -1
	case EINTR:		return PvmEINTR;
#endif
#if EINVAL != -1
	case EINVAL:		return PvmEINVAL;
#endif
#if EIO != -1
	case EIO:		return PvmEIO;
#endif
#if EISCONN != -1
	case EISCONN:		return PvmEISCONN;
#endif
#if EISDEV != -1
	case EISDEV:		return PvmEISDEV;
#endif
#if EISDIR != -1
	case EISDIR:		return PvmEISDIR;
#endif
#if EISMIGRATED != -1
	case EISMIGRATED:	return PvmEISMIGRATED;
#endif
#if EISSOCK != -1
	case EISSOCK:		return PvmEISSOCK;
#endif
#if EJUSTRETURN != -1
	case EJUSTRETURN:	return PvmEJUSTRETURN;
#endif
#if EL2HLT != -1
	case EL2HLT:		return PvmEL2HLT;
#endif
#if EL2NSYNC != -1
	case EL2NSYNC:		return PvmEL2NSYNC;
#endif
#if EL3HLT != -1
	case EL3HLT:		return PvmEL3HLT;
#endif
#if EL3RST != -1
	case EL3RST:		return PvmEL3RST;
#endif
#if ELNRNG != -1
	case ELNRNG:		return PvmELNRNG;
#endif
#if ELOOP != -1
	case ELOOP:		return PvmELOOP;
#endif
#if EMASS != -1
	case EMASS:		return PvmEMASS;
#endif
#if EMAXLOCALCHAN != -1
	case EMAXLOCALCHAN:	return PvmEMAXLOCALCHAN;
#endif
#if EMAXSUSP != -1
	case EMAXSUSP:		return PvmEMAXSUSP;
#endif
#if EMEDIA != -1
	case EMEDIA:		return PvmEMEDIA;
#endif
#if EMFILE != -1
	case EMFILE:		return PvmEMFILE;
#endif
#if EMLINK != -1
	case EMLINK:		return PvmEMLINK;
#endif
#if EMSGSIZE != -1
	case EMSGSIZE:		return PvmEMSGSIZE;
#endif
#if EMTIMERS != -1
	case EMTIMERS:		return PvmEMTIMERS;
#endif
#if EMULTIHOP != -1
	case EMULTIHOP:		return PvmEMULTIHOP;
#endif
#if ENAMETOOLONG != -1
	case ENAMETOOLONG:	return PvmENAMETOOLONG;
#endif
#if ENETDOWN != -1
	case ENETDOWN:		return PvmENETDOWN;
#endif
#if ENETRESET != -1
	case ENETRESET:		return PvmENETRESET;
#endif
#if ENETUNREACH != -1
	case ENETUNREACH:	return PvmENETUNREACH;
#endif
#if ENFILE != -1
	case ENFILE:		return PvmENFILE;
#endif
#if ENOACL != -1
	case ENOACL:		return PvmENOACL;
#endif
#if ENOATTR != -1
	case ENOATTR:		return PvmENOATTR;
#endif
#if ENOBUFS != -1
	case ENOBUFS:		return PvmENOBUFS;
#endif
#if ENOCONNECT != -1
	case ENOCONNECT:	return PvmENOCONNECT;
#endif
#if ENOCSI != -1
	case ENOCSI:		return PvmENOCSI;
#endif
#if ENODATA != -1
	case ENODATA:		return PvmENODATA;
#endif
#if ENODEV != -1
	case ENODEV:		return PvmENODEV;
#endif
#if ENODMON != -1
	case ENODMON:		return PvmENODMON;
#endif
#if ENOENT != -1
	case ENOENT:		return PvmENOENT;
#endif
#if ENOEXEC != -1
	case ENOEXEC:		return PvmENOEXEC;
#endif
#if ENOLCK != -1
	case ENOLCK:		return PvmENOLCK;
#endif
#if ENOLINK != -1
	case ENOLINK:		return PvmENOLINK;
#endif
#if ENOMEM != -1
	case ENOMEM:		return PvmENOMEM;
#endif
#if ENOMSG != -1
	case ENOMSG:		return PvmENOMSG;
#endif
#if ENONET != -1
	case ENONET:		return PvmENONET;
#endif
#if ENOPKG != -1
	case ENOPKG:		return PvmENOPKG;
#endif
#if ENOPROTOOPT != -1
	case ENOPROTOOPT:	return PvmENOPROTOOPT;
#endif
#if ENOSPC != -1
	case ENOSPC:		return PvmENOSPC;
#endif
#if ENOSR != -1
	case ENOSR:		return PvmENOSR;
#endif
#if ENOSTR != -1
	case ENOSTR:		return PvmENOSTR;
#endif
#if ENOSYM != -1
	case ENOSYM:		return PvmENOSYM;
#endif
#if ENOSYS != -1
	case ENOSYS:		return PvmENOSYS;
#endif
#if ENOTBLK != -1
	case ENOTBLK:		return PvmENOTBLK;
#endif
#if ENOTCONN != -1
	case ENOTCONN:		return PvmENOTCONN;
#endif
#if ENOTDIR != -1
	case ENOTDIR:		return PvmENOTDIR;
#endif
#if ENOTEMPTY != -1
	case ENOTEMPTY:		return PvmENOTEMPTY;
#endif
#if ENOTREADY != -1
	case ENOTREADY:		return PvmENOTREADY;
#endif
#if ENOTRUST != -1
	case ENOTRUST:		return PvmENOTRUST;
#endif
#if ENOTSOCK != -1
	case ENOTSOCK:		return PvmENOTSOCK;
#endif
#if ENOTSUP != -1
	case ENOTSUP:		return PvmENOTSUP;
#endif
#if ENOTTY != -1
	case ENOTTY:		return PvmENOTTY;
#endif
#if ENXIO != -1
	case ENXIO:		return PvmENXIO;
#endif
#if EOPNOTSUPP != -1
	case EOPNOTSUPP:	return PvmEOPNOTSUPP;
#endif
#if EPERM != -1
	case EPERM:		return PvmEPERM;
#endif
#if EPFNOSUPPORT != -1
	case EPFNOSUPPORT:	return PvmEPFNOSUPPORT;
#endif
#if EPIPE != -1
	case EPIPE:		return PvmEPIPE;
#endif
#if EPROCLIM != -1
	case EPROCLIM:		return PvmEPROCLIM;
#endif
#if EPROCUNAVAIL != -1
	case EPROCUNAVAIL:	return PvmEPROCUNAVAIL;
#endif
#if EPROGMISMATCH != -1
	case EPROGMISMATCH:	return PvmEPROGMISMATCH;
#endif
#if EPROGUNAVAIL != -1
	case EPROGUNAVAIL:	return PvmEPROGUNAVAIL;
#endif
#if EPROTO != -1
	case EPROTO:		return PvmEPROTO;
#endif
#if EPROTONOSUPPORT != -1
	case EPROTONOSUPPORT:	return PvmEPROTONOSUPPORT;
#endif
#if EPROTOTYPE != -1
	case EPROTOTYPE:	return PvmEPROTOTYPE;
#endif
#if ERANGE != -1
	case ERANGE:		return PvmERANGE;
#endif
#if ERELOCATED != -1
	case ERELOCATED:	return PvmERELOCATED;
#endif
#if EREMCHG != -1
	case EREMCHG:		return PvmEREMCHG;
#endif
#if EREMOTE != -1
	case EREMOTE:		return PvmEREMOTE;
#endif
#if ERESTART != -1
	case ERESTART:		return PvmERESTART;
#endif
#if EROFS != -1
	case EROFS:		return PvmEROFS;
#endif
#if ERPCMISMATCH != -1
	case ERPCMISMATCH:	return PvmERPCMISMATCH;
#endif
#if ERREMOTE != -1
	case ERREMOTE:		return PvmERREMOTE;
#endif
#if ERWOFF != -1
	case ERWOFF:		return PvmERWOFF;
#endif
#if ESAD != -1
	case ESAD:		return PvmESAD;
#endif
#if ESHUTDOWN != -1
	case ESHUTDOWN:		return PvmESHUTDOWN;
#endif
#if ESOCKTNOSUPPORT != -1
	case ESOCKTNOSUPPORT:	return PvmESOCKTNOSUPPORT;
#endif
#if ESOFT != -1
	case ESOFT:		return PvmESOFT;
#endif
#if ESPIPE != -1
	case ESPIPE:		return PvmESPIPE;
#endif
#if ESRCH != -1
	case ESRCH:		return PvmESRCH;
#endif
#if ESRMNT != -1
	case ESRMNT:		return PvmESRMNT;
#endif
#if ESTALE != -1
	case ESTALE:		return PvmESTALE;
#endif
#if ESTATECHANGED != -1
	case ESTATECHANGED:	return PvmESTATECHANGED;
#endif
#if ESUCCESS != -1
	case ESUCCESS:		return PvmESUCCESS;
#endif
#if ESUSPCLEAR != -1
	case ESUSPCLEAR:	return PvmESUSPCLEAR;
#endif
#if ETIME != -1
	case ETIME:		return PvmETIME;
#endif
#if ETIMEDOUT != -1
	case ETIMEDOUT:		return PvmETIMEDOUT;
#endif
#if ETOOMANYREFS != -1
	case ETOOMANYREFS:	return PvmETOOMANYREFS;
#endif
#if ETPBADFORM != -1
	case ETPBADFORM:	return PvmETPBADFORM;
#endif
#if ETPNOSUPPORT != -1
	case ETPNOSUPPORT:	return PvmETPNOSUPPORT;
#endif
#if ETPTRUNC != -1
	case ETPTRUNC:		return PvmETPTRUNC;
#endif
#if ETXTBSY != -1
	case ETXTBSY:		return PvmETXTBSY;
#endif
#if EUNATCH != -1
	case EUNATCH:		return PvmEUNATCH;
#endif
#if EUSERS != -1
	case EUSERS:		return PvmEUSERS;
#endif
#if EVERSION != -1
	case EVERSION:		return PvmEVERSION;
#endif
#if EWOULDBLOCK != -1
	case EWOULDBLOCK:	return PvmEWOULDBLOCK;
#endif
#if EWRPROTECT != -1
	case EWRPROTECT:	return PvmEWRPROTECT;
#endif
#if EXDEV != -1
	case EXDEV:		return PvmEXDEV;
#endif
#if EILSEQ != -1
	case EILSEQ:		return PvmEILSEQ;
#endif
	default:		return -1;
	}
}
