#!/usr/local/bin/perl

#
#                 Author:  Christopher G. Phillips
#              Copyright (C) 1993 All Rights Reserved
#
#                              NOTICE
#
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby granted
# provided that the above copyright notice appear in all copies and
# that both the copyright notice and this permission notice appear in
# supporting documentation.
#
# The author makes no representations about the suitability of this
# software for any purpose.  This software is provided ``as is''
# without express or implied warranty.
#

if (!defined $ENV{"PVM_ARCH"}) {
	die "PVM_ARCH not set\n";
} else {
	$ARCH = $ENV{"PVM_ARCH"};
}

$sort_all = 0;
while ($_ = $ARGV[0], /^-/) {
	shift;
	last if /^--$/;
	$sort_all = 1 if /^-s/;
}
          
$n = 0;
$maxlen = 0;

if (open(PVM, "<pvmerrno.h")) {
	while (<PVM>) {
		if (/\bPvm(E\S*\b)/ && !defined $s{"$1"}) {
			$s{"$1"} = ++$n;
			$e{$n} = "$1";
			if (length($1) > $maxlen) {
				$maxlen = length($1);
			}
		}
	}
	close(PVM);
}

loop:
while (<>) {
	if (/^\s*#\s*define\s+\b(E\S*\b)\s+\b(\S+\b)/) {
		if (defined $s{"$2"}) {
			$d{$1} = 1;
			warn $_ . "\n";
			next loop;
		}
		if ($sort_all) {
			if (!defined $s{"$1"}) {
				$s{"$1"} = 1;
			}
		} else {
			if (!defined $s{"$1"} && !defined $s2{"$1"}) {
				$s2{"$1"} = 1;
			}
		}
	}
}

if ($sort_all) {
	$n = 0;
	foreach $key (sort(keys %s)) {
		$s{$key} = ++$n;
		$e{$n} = $key;
		if (length($key) > $maxlen) {
			$maxlen = length($key);
		}
	}
} else {
	foreach $key (sort(keys %s2)) {
		$s{$key} = ++$n;
		$e{$n} = $key;
		if (length($key) > $maxlen) {
			$maxlen = length($key);
		}
	}
}

die "Can't open pvmerrno.h: $!" unless open(PVM, ">pvmerrno.h");
select(PVM);

do printcr();

printf("#ifndef PVMERRNO_H\n#define PVMERRNO_H\n\n");
for ($i = 1; $i <= $n; $i++) {
	printf("#ifndef %s\n", $e{$i});
	printf("#define %s%s-1\n", $e{$i}, "\t" x &tabs(length($e{$i}), 0));
	printf("#endif\n");
}
for ($i = 1; $i <= $n; $i++) {
	printf("#define Pvm%s%s$i\n", $e{$i}, "\t" x &tabs(length($e{$i}), 3));
}
printf("\n#endif\n");
close(PVM);

die "Can't open pvmerrno.c: $!" unless open(PVM, ">pvmerrno.c");
select(PVM);

do printcr();

print "#include <stdio.h>\n";
print "#include <errno.h>\n";
print '#include "pvmerrno.h"' . "\n\n";
print "extern int	errno;\n";
print "\n";
print "int\n";
print "pvm_local_errno(int pvmerrno)\n";
print "{\n";
print "	switch (pvmerrno) {\n";
printf("\tcase -2:%sreturn -2;\n", "\t" x &tabs(2, 1));
for ($i = 1; $i <= $n; $i++) {
	printf("\tcase Pvm%s:%sreturn %s;\n", $e{$i},
	  "\t" x &tabs(length($e{$i}), 1), $e{$i});
}
printf("\tdefault:%sreturn -1;\n", "\t" x &tabs(0, 0));
print "\t}\n";
print "}\n";
print "\n";
print '#include "errnoconf.h"' . "\n\n";
print "int\n";
print "pvmerrno(int errnum)\n";
print "{\n";
print "	switch (errnum) {\n";
printf("\tcase -2:%sreturn -2;\n", "\t" x &tabs(2, 1));
for ($i = 1; $i <= $n; $i++) {
	printf("#if %s != -1\n", $e{$i});
	printf("\tcase %s:%sreturn Pvm%s;\n", $e{$i},
	  "\t" x &tabs(length($e{$i}), 6), $e{$i});
	printf("#endif\n");
}
printf("\tdefault:%sreturn -1;\n", "\t" x &tabs(0, 0));
print "\t}\n";
print "}\n";
close(PVM);

die "Can't open $ARCH/errnoconf.h: $!" unless open(PVM, ">$ARCH/errnoconf.h");
select(PVM);

do printcr();

foreach $key (sort(keys %d)) {
	printf("#undef %s\n", $key);
	printf("#define %s -1\n", $key);
}
close(PVM);

exit(0);

sub tabs {
	local($len, $add) = @_;
	local($num);

	$num = int(($maxlen + 7 + $add) / 8) - int(($len + $add) / 8);
}

sub printcr {
print "/*\
 *                 Author:  Christopher G. Phillips\
 *              Copyright (C) 1993 All Rights Reserved\
 *\
 *                              NOTICE\
 *\
 * Permission to use, copy, modify, and distribute this software and\
 * its documentation for any purpose and without fee is hereby granted\
 * provided that the above copyright notice appear in all copies and\
 * that both the copyright notice and this permission notice appear in\
 * supporting documentation.\
 *\
 * The author makes no representations about the suitability of this\
 * software for any purpose.  This software is provided ``as is''\
 * without express or implied warranty.\
 */\n\n";
}
