/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "fs.h"
#include "map.h"
#include "pvm3.h"

#ifndef IMA_RS6K
#include <syscall.h>
#else
#include "syscall-fake.h"
#endif
extern char	buf2[];
#define dprint(s)	do {	\
				sprintf s;	\
				syscall(SYS_write, 2, buf2, strlen(buf2)); \
			} while (0)
#if 1
#undef dprint
#define dprint(s)
#endif

extern int	pvmmysfd;

struct gmap		globalmap;
struct lmap		*lmap = NULL;
extern struct gop	*gop;

size_t	nummaps = 0;
size_t	nummapsused = 0;
int	*tidorder = NULL;

int
fdtorealfd(struct lmap *lmp, int filedes)
{
	struct fd	*fdp;

	/*
	 * Translate a client fd to our fd.
	 */
	if (filedes < 0 || filedes >= globalmap.numfds)
		return -1;
	if (fdp = lmp->lfd[filedes].fd) {
		dprint((buf2, "tid t%x: fd %d is global fd %d\n", lmp->tid,
		  filedes, fdp - globalmap.fd));
		return fdp - globalmap.fd;
	} else
		return -1;
}

struct lmap *
lmap_add(int tid)
{
	int		i;
	struct lmap	*lmp;

	/*
	 * Add a new client.
	 */
	for (i = 0; i < nummaps; i++)
		if (lmap[i].tid == 0)
			break;

	if (i == nummaps) {
#if defined(IMA_SUN3) || defined(IMA_SUN4)
		if (lmap == NULL) {
			if ((lmap = malloc(sizeof(*lmap))) == NULL)
				return NULL;
		} else
#endif
		if ((lmap = realloc(lmap, (nummaps + 1) * sizeof(*lmap)))
		  == NULL)
			return NULL;
#if defined(IMA_SUN3) || defined(IMA_SUN4)
		if (tidorder == NULL) {
			if ((tidorder = malloc(sizeof(*tidorder))) == NULL)
				return NULL;
		} else
#endif
		if ((tidorder = realloc(tidorder,
		  (nummaps + 1) * sizeof(*tidorder))) == NULL)
			return NULL;
		tidorder[nummaps] = tid;
		if ((lmap[nummaps].lfd = malloc(globalmap.numfds
		  * sizeof(*lmap[0].lfd))) == NULL) {
			lmap[nummaps].tid = tidorder[nummaps] = 0;
			return NULL;
		} else
			nummaps++;
	}

	lmap[i].tid = tid;
	lmp = &lmap[i];
	for (i = 0; i < globalmap.numfds; i++)
		if (globalmap.fd[i].from_start) {
			lmp->lfd[i].fd = &globalmap.fd[i];
			lmp->lfd[i].iomode = globalmap.fd[i].iomode;
			lmp->lfd[i].offset = globalmap.fd[i].offset;
			globalmap.fd[i].nrefs++;
		} else
			lmp->lfd[i].fd = NULL;

	nummapsused++;

	return lmp;
}

struct lmap *
lmap_find(int tid)
{
	int		i;
	struct lmap	*lmp;

	for (i = 0, lmp = lmap; i < nummaps; i++, lmp++)
		if (lmp->tid == tid)
			return lmp;

	return NULL;
}

void
lmap_delete(int tid)
{
	int		i;
	int		j;
	int		fd;
	struct lmap	*lmp;

	/*
	 * A client went away...
	 */
	if (lmp = lmap_find(tid)) {
		lmp->tid = 0;
		for (i = 0; i < globalmap.numfds; i++)
			if ((fd = fdtorealfd(lmp, i)) != -1)
				switch (globalmap.fd[fd].iomode) {
				case PvmIomodeIndividual:
					/*globalmap.fd[i].nrefs--;*/
					close(fd);
					break;
				case PvmIomodeCommon:
				case PvmIomodeIndependent:
				case PvmIomodeSyncBC:
				case PvmIomodeSyncSeq:
					if (--globalmap.fd[i].nrefs == 0)
						close(fd);
					break;
				}

		if (lmp->lfd)
			free(lmp->lfd);

		for (i = 0; i < nummapsused; i++)
			if (tidorder[i] == tid)
				break;
		nummapsused--;
	}
}

int
lmap_init(int pfd0, int pfd1, int authfd)
{
	int		i;
	int		flags;
	struct stat	stbuf;

	/*
	 * Initialize the file descriptor and global operation mapping.
	 */
	globalmap.numfds = getdtablesize();
	if ((globalmap.fd = malloc(globalmap.numfds * sizeof(*globalmap.fd)))
	  == NULL)
		return -1;
	gop = NULL;
	tidorder = NULL;
	for (i = 0; i < globalmap.numfds; i++)
		if (i == pvmmysfd || i == pfd0 || i == pfd1 || i == authfd
		  || fstat(i, &stbuf) == -1)
			globalmap.fd[i].from_start = 0;
		else {
			globalmap.fd[i].nrefs = 0;
			globalmap.fd[i].st_ino = stbuf.st_ino;
			globalmap.fd[i].st_dev = stbuf.st_dev;
			if (i == 0 || (flags = fcntl(i, F_GETFL, 0)) == 0
			  && (flags & O_ACCMODE) == O_RDONLY)
				globalmap.fd[i].iomode = PvmIomodeSyncBC;
			else
				globalmap.fd[i].iomode = PvmIomodeCommon;
			globalmap.fd[i].offset = lseek(i, 0, SEEK_CUR);
			globalmap.fd[i].from_start = 1;
		}

	return 0;
}

int
tid2bitpos(int tid)
{
	int	i;

	for (i = 0; i < nummaps; i++)
		if (lmap[i].tid == tid)
			return i;

	return -1;
}
