/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1993 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

/*
 * File descriptors
 */
struct gmap {
	int	numfds;
	struct fd {
		int		nrefs;
		ino_t		st_ino;
		dev_t		st_dev;
		int		iomode;
		off_t		offset;
		int		from_start;
	} *fd;
};

/*
 * Global operations
 */
struct gop {
	struct gop	*next;
	int		type;
	int		fd;
	ino_t		st_ino;
	dev_t		st_dev;
	long		result;
	void		*buf;
	int		numdone;
	unsigned char	*done;
	struct queued	*queue;
};

/*
 * Queued synchronized reads and writes
 */
struct queued {
	struct queued	*next;
	int		number;
	int		type;
	int		fd;
	void		**args;
	int		nargs;
	int		tid;
};

/*
 * Clients
 */
struct lmap {
	int		tid;
	struct lfd {
		int		iomode;
		off_t		offset;
		struct fd	*fd;
	} *lfd;
};
