#*************************************************************#
#**                                                         **#
#**      Nmake file for the PVM console	                    **#
#**                   pvm.exe			            **#
#**         	      	         			    **#
#**                                                         **#
#*************************************************************#


LIBDIR  = c:\msdev\lib
INCLUDE = c:\msdev\include

cc      = cl.exe
cflags  = -c -W2 -DWIN32 /nologo /GX /O2 /D "NDEBUG" \
          /D "_CONSOLE" /I $(INCLUDE)
link    = link
link_flags= $(LIBDIR)\wsock32.lib $(LIBDIR)\kernel32.lib\
        $(LIBDIR)\libcd.lib \
        $(LIBDIR)\libc.lib \
        $(LIBDIR)\gdi32.lib $(LIBDIR)\winspool.lib \
        $(LIBDIR)\comdlg32.lib \
        $(LIBDIR)\advapi32.lib \
        $(LIBDIR)\shell32.lib  \
        $(LIBDIR)\ole32.lib \
        $(LIBDIR)\oleaut32.lib \
        $(LIBDIR)\uuid.lib \
        $(LIBDIR)\oldnames.lib

conflags   = /MACHINE:IX86 /NOLOGO -subsystem:console -entry:mainCRTStartup
conlibs    = $(libc)


all : pvm.exe

#

pvm.exe : cmds.obj cons.obj job.obj tevfmt.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\console\$(PVM_ARCH)\pvm.exe \
	cmds.obj cons.obj job.obj tevfmt.obj \
	$(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
	$(link_flags)

cmds.obj: $(PVM_ROOT)\console\cmds.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\console\cmds.c
cons.obj: $(PVM_ROOT)\console\cons.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\console\cons.c
tevfmt.obj: $(PVM_ROOT)\console\tevfmt.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\console\tevfmt.c
job.obj: $(PVM_ROOT)\console\job.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\console\job.c

# Clean up everything but the .EXEs
clean :
    -del *.obj
    -del *.pdb
