/*
*    SPMD example using PVM 3
*    also illustrating group functions
*/

#define NPROC 4

#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include "pvm3.h"


  
int main()
{
    int mytid;                  /* my task id */
    int tids[NPROC];            /* array of task id */
    int me;                     /* my process number */
    int i,j;

 
    /* enroll in pvm */
    mytid = pvm_mytid();
//    pvm_setopt(PvmRoute,PvmRouteDirect);
  
    /* Join a group and if I am the first instance */
    /* i.e. me=0 spawn more copies of myself       */
    me = pvm_joingroup( "foo" );
    fprintf(stderr,"me = %d mytid = %d\n",me,mytid);
						   
    if( me == 0 ) {
		j=pvm_spawn("spmd", (char**)0, 0, "", NPROC-1, &tids[1]);
		if (j != NPROC-1)
			fprintf(stderr,"could only spawn %d spmd's: %d \n",j);
	}
    /* Wait for everyone to startup before proceeding. */
						   
	pvm_freezegroup("foo",NPROC);


    pvm_barrier( "foo", NPROC );

/*--------------------------------------------------------------------------*/
     
     dowork( me, NPROC );

     /* program finished leave group and exit pvm */
     pvm_lvgroup( "foo" );
     pvm_exit();
     exit(1);
}

/* Simple example passes a token around a ring */

dowork( me, nproc )
     int me;
     int nproc;
{
     int token;
     int src, dest;
     int count  = 1;
     int stride = 1;
     int msgtag = 4;
	 float f;
	 double d;
	 int i=0;
	 char txt[128];

	 i=0;
	 f=(float)0.0;
	 d=0.0;
     /* Determine neighbors in the ring */
     src = pvm_gettid("foo", me-1);
     dest= pvm_gettid("foo", me+1);
     if( me == 0 )       src = pvm_gettid("foo", NPROC-1);
     if( me == NPROC-1 ) dest = pvm_gettid("foo", 0);

     if( me == 0 )
     { 
		i=4711;
		f= (float)4.0;
		d= 4.0;
        token = dest;
        pvm_initsend( PvmDataRaw );
        pvm_pkint( &token, count, stride );
		pvm_pkint(&i,1,1);
		pvm_pkfloat(&f,1,1);
		pvm_pkdouble(&d,1,1);
        pvm_send( dest, msgtag );
        pvm_recv( src, msgtag );
        printf("token ring done\n");
     }
     else
     { 
        pvm_recv( src, msgtag );
        pvm_upkint( &token, count, stride );
		pvm_upkint(&i,1,1);
		pvm_upkfloat(&f,1,1);
		pvm_upkdouble(&d,1,1);
	
        pvm_initsend( PvmDataRaw );
        pvm_pkint( &token, count, stride );
        pvm_send( dest, msgtag );
     }
}
