#*************************************************************#
#**                                                         **#
#**      PVM Examples:			                    **#
#**                   hello.exe hello_other.exe             **#
#**         	      spmd.exe nntime master1 slave1	    **#
#**                   timing                                **#
#*************************************************************#


LIBDIR  = c:\msdev\lib
INCLUDE = c:\msdev\include

cc      = cl.exe
cflags  = -c -W2 -DWIN32 /nologo /GX /O2 /D "NDEBUG" \
          /D "_CONSOLE" /I $(INCLUDE) /I $(PVM_ROOT)/include
link    = link
link_flags= $(LIBDIR)\wsock32.lib $(LIBDIR)\kernel32.lib\
        $(LIBDIR)\libc.lib \
        $(LIBDIR)\gdi32.lib $(LIBDIR)\winspool.lib \
        $(LIBDIR)\comdlg32.lib \
        $(LIBDIR)\advapi32.lib \
        $(LIBDIR)\shell32.lib  \
        $(LIBDIR)\ole32.lib \
        $(LIBDIR)\oleaut32.lib \
        $(LIBDIR)\uuid.lib \
        $(LIBDIR)\oldnames.lib

conflags   = /MACHINE:IX86 /NOLOGO -subsystem:console -entry:mainCRTStartup
conlibs    = $(libc)


all : timing hellos spmd ms-sl nntime gexample

#
timing : timing.exe timing_slave.exe
hellos : hello.exe hello_other.exe
ms-sl  : master1.exe slave1.exe
spmd   : spmd.exe
nntime : nntime.exe
gexample: gexample.exe


timing.exe: timing.obj $(PVM_ROOT)\examples\timing.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\timing.exe \
	timing.obj \
	$(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(link_flags)

timing_slave.exe: timing_slave.obj $(PVM_ROOT)\examples\timing_slave.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\timing_slave.exe \
	timing_slave.obj \
	$(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(link_flags)
gexample.exe : gexample.obj $(PVM_ROOT)\examples\gexample.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\gexample.exe \
      gexample.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
      $(link_flags)

hello.exe : hello.obj $(PVM_ROOT)\examples\hello.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\hello.exe \
      hello.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
      $(link_flags)

hello_other.exe : hello_other.obj $(PVM_ROOT)\examples\hello_other.c
    $(link) $(linkdebug) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\hello_other.exe \
      hello_other.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib $(link_flags)

master1.exe : master1.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\master1.exe \
      master1.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
      $(link_flags)

slave1.exe : slave1.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\slave1.exe \
      slave1.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
      $(link_flags)

spmd.exe : spmd.obj $(PVM_ROOT)\examples\spmd.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\spmd.exe \
        spmd.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
        $(link_flags)

nntime.exe : nntime.obj $(PVM_ROOT)\examples\nntime.c
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\nntime.exe \
      nntime.obj \
      $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
      $(link_flags)

timing.obj : $(PVM_ROOT)\examples\timing.c
        $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\timing.c

timing_slave.obj : $(PVM_ROOT)\examples\timing_slave.c
        $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\timing_slave.c

gexample.obj : $(PVM_ROOT)\examples\gexample.c
        $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\gexample.c

# hello main program
hello.obj : $(PVM_ROOT)\examples\hello.c
        $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\hello.c

# hello's compliant
hello_other.obj : $(PVM_ROOT)\examples\hello_other.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\hello_other.c


master1.obj: $(PVM_ROOT)\examples\master1.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\master1.c


slave1.obj: $(PVM_ROOT)\examples\slave1.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\slave1.c


nntime.obj: $(PVM_ROOT)\examples\nntime.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\nntime.c


spmd.obj: $(PVM_ROOT)\examples\spmd.c
   $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\spmd.c

# Clean up everything but the .EXEs
clean :
    -del *.obj
    -del *.pdb
