#*************************************************************#
#**                                                         **#
#**      PVM Fortran Examples:			            **#
#**                   spmdf.exe	hit		            **#
#**         	      					    **#
#**                                                         **#
#*************************************************************#


LIBDIR  = c:\msdev\lib
INCLUDE = c:\msdev\include

cc      = fl32.exe
cflags  = -c -DWIN32 /nologo /D "NDEBUG"  \
          /D "_CONSOLE" /I $(INCLUDE) /I $(PVM_ROOT)/include
link    = link
link_flags= $(LIBDIR)\wsock32.lib $(LIBDIR)\kernel32.lib\
        $(LIBDIR)\libc.lib \
        $(LIBDIR)\gdi32.lib $(LIBDIR)\winspool.lib \
        $(LIBDIR)\comdlg32.lib \
        $(LIBDIR)\advapi32.lib \
        $(LIBDIR)\shell32.lib  \
        $(LIBDIR)\ole32.lib \
        $(LIBDIR)\oleaut32.lib \
        $(LIBDIR)\uuid.lib \
        $(LIBDIR)\oldnames.lib

conflags   = /MACHINE:IX86 /NOLOGO -subsystem:console -entry:mainCRTStartup
conlibs    = $(libc)


all : ms-sl spmdf hit

#
spmdf   : spmdf.exe
hit 	: hit_ms hit_sl
gexample: gexample.exe
ms-sl   : master1.exe slave1.exe

spmdf.exe : spmdf.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\spmdf.exe \
        spmdf.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)


master1.exe : master1f.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\fmaster1.exe \
        master1f.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)

slave1.exe : slave1f.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\fslave1.exe \
        slave1f.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)



gexample.exe : gexamplef.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\fgexample.exe \
        gexamplef.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)

hit_ms: $(PVM_ROOT)\examples\hitc.f hitc.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\hitc.exe \
        hitc.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)

hit_sl: $(PVM_ROOT)\examples\hitc_slave.f hitc_slave.obj
        $(link) $(conflags) -out:$(PVM_ROOT)\bin\$(PVM_ARCH)\hitc_slave.exe \
        hitc_slave.obj \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libpvm3.lib \
        $(PVM_ROOT)\lib\$(PVM_ARCH)\libgpvm3.lib \
	$(PVM_ROOT)\libfpvm\$(PVM_ARCH)\libfpvm.lib \
        $(link_flags)
 
hitc.obj: $(PVM_ROOT)\examples\hitc.f
  $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\hitc.f


hitc_slave.obj: $(PVM_ROOT)\examples\hitc_slave.f
  $(cc) $(cdebug) $(cflags) $(cvars) $(PVM_ROOT)\examples\hitc_slave.f


spmdf.obj: $(PVM_ROOT)\examples\spmd.f
   $(cc) $(cdebug) /Fospmdf.obj $(cflags) $(cvars) $(PVM_ROOT)\examples\spmd.f

gexamplef.obj: $(PVM_ROOT)\examples\gexample.f
   $(cc) $(cdebug) /Fogexamplef.obj $(cflags) $(cvars) $(PVM_ROOT)\examples\gexample.f

slave1f.obj: $(PVM_ROOT)\examples\slave1.f
   $(cc) $(cdebug) /Foslave1f.obj $(cflags) $(cvars) $(PVM_ROOT)\examples\slave1.f

master1f.obj: $(PVM_ROOT)\examples\master1.f
   $(cc) $(cdebug) /Fomaster1f.obj $(cflags) $(cvars) $(PVM_ROOT)\examples\master1.f

# Clean up everything but the .EXEs
clean :
    -del *.obj
    -del *.pdb
