

#ifdef WIN32
#include "..\..\include\pvm3.h"
#include "..\..\src\pvmwin.h"
#else 
#include "pvm3.h"
#endif

#include "pvm_consts.h"

void __stdcall
PVMFBCAST (group_ptr,group_len, msgtag, info)
char * group_ptr; int group_len;
int *msgtag, *info;
{
	char tgroup[MAX_GRP_NAME + 1];

	/*
	 * Copy the group name to make sure there's
	 * a NUL at the end.
	 */
	if (ftocstr(tgroup, sizeof(tgroup), group_ptr, group_len)){
		*info = PvmBadParam;
		return;
	}

	*info = pvm_bcast(tgroup, *msgtag);
}

