

#ifdef WIN32
#include "..\..\include\pvm3.h"
#include "..\..\src\pvmwin.h"
#else 
#include "pvm3.h"
#endif

#include "pvm_consts.h"

void __stdcall
PVMFGATHER (result, data, count, datatype, msgtag, gname_ptr,gname_len, rootinst, info)
void *result, *data;
int *count, *datatype, *msgtag, *rootinst, *info;
char * gname_ptr; int gname_len;
{
  char tgroup[MAX_GRP_NAME + 1];

  /*
   * Copy the group name to make sure there's a NUL at the end.
   */

  if (ftocstr(tgroup,sizeof(tgroup),gname_ptr,gname_len))
    {
    *info = PvmBadParam;
    return;
    }

  *info = pvm_gather(result, data, *count, *datatype, *msgtag, tgroup, 
                     *rootinst);

}

