

#ifdef WIN32
#include "..\..\include\pvm3.h"
#include "..\..\src\pvmwin.h"
#else 
#include "pvm3.h"
#endif

#include "pvm_consts.h"

void __stdcall
PVMFGETINST (group_ptr,group_len, tid, inum)
char * group_ptr; int group_len;
int *inum, *tid;
{
	char tgroup[MAX_GRP_NAME + 1];

	/*
	 * Copy the group name to make sure there's
	 * a NUL at the end.
	 */
	if (ftocstr(tgroup, sizeof(tgroup), group_ptr, group_len)){
		*inum = PvmBadParam;
		return;
	}

	*inum = pvm_getinst(tgroup, *tid);
}

