
#ifdef WIN32
#include "..\..\include\pvm3.h"
#include "..\..\src\pvmwin.h"
#else 
#include "pvm3.h"
#endif

#include "pvm_consts.h"

void __stdcall
PVMFREDUCE (func, data,count, datatype, msgtag, gname_ptr,gname_len, rootinst, info)
#ifdef UXPM
void (**func)(); /* correction for Fujitsu FORTRAN77 EX */
#else
void (*func)();
#endif
void *data;
int *count, *datatype, *msgtag, *rootinst, *info;
char * gname_ptr; int gname_len;
{
  char tgroup[MAX_GRP_NAME + 1];

  /*
   * Copy the group name to make sure there's a NUL at the end.
   */
  if (ftocstr(tgroup, sizeof(tgroup), gname_ptr, gname_len)){
    *info = PvmBadParam;
    return;
    }

#ifdef UXPM
  *info = pvm_reduce(*func, data, *count, *datatype, *msgtag, tgroup, 
                     *rootinst);
#else
  *info = pvm_reduce(func, data, *count, *datatype, *msgtag, tgroup, 
                     *rootinst);
#endif

}

/* various reduction functions are defined here */

void
pvmmax_ (datatype, data, work, count, info)
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmMax(datatype, data, work, count, info);
}



void
pvmmin_ (datatype, data, work, count, info)
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmMin(datatype, data, work, count, info);
}

void
pvmsum_ (datatype, data, work, count, info)
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmSum(datatype, data, work, count, info);
}

void
pvmproduct_ (datatype, data, work, count, info)
int *datatype;
void *data, *work;
int *count, *info;
{
  PvmProduct(datatype, data, work, count, info);
}
