

#ifdef WIN32
#include "..\..\include\pvm3.h"
#include "..\..\src\pvmwin.h"
#else 
#include "pvm3.h"
#endif

#include "pvm_consts.h"

void __stdcall
PVMFSPAWN (char *aout_ptr,int *trash1, int *flag, char *where_ptr,int *trash2, int *count, int *tids, int *info)
{
	char taout[MAX_PROC_NAME + 1];
	char twhere[MAX_HOST_NAME + 1];
	int aout_len; 
	int where_len;
	aout_len= strlen(aout_ptr);
	where_len = strlen(where_ptr);
	/*
	 * Copy the program and where names to make sure there's
	 * a NUL at the end.
	 */
	
	if (ftocstr(taout, sizeof(taout), aout_ptr, aout_len)) {
		*info = PvmBadParam;
		return;
	}
	
	/*
	 * if the where parameter is '*', pass a NULL pointer to
	 * initiate which will allow execution on any machine.
	 */

	if (*(where_ptr) == '*') {
		*info = pvm_spawn(taout, (char**)0, *flag, "", *count, tids);

	} else {
		if (ftocstr(twhere, sizeof(twhere), where_ptr, where_len)) {
			*info = PvmBadParam;
			return;
		}
	
		*info = pvm_spawn(taout, (char**)0, *flag, twhere, *count, tids);

	}
}

