
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *  pvmmimd.h
 *
$Log: pvmmimd.h,v $
 * Revision 1.8  1995/06/16  16:09:30  manchek
 * changed size of PGON host info array to 10
 *
 * Revision 1.7  1995/06/12  18:24:20  manchek
 * SIZEHINFO only affects PGON for now
 *
 * Revision 1.6  1995/06/12  16:01:56  manchek
 * changed SIZEHINFO to 6
 *
 * Revision 1.5  1995/05/30  17:50:23  manchek
 * Added new defines for SP2MPI architecture
 *
 * Revision 1.4  1994/11/08  19:19:23  manchek
 * mpp fixes
 *
 * Revision 1.3  1994/06/03  20:38:25  manchek
 * version 3.3.0
 *
 * Revision 1.2  1993/12/20  15:39:44  manchek
 * patch 6 from wcj
 *
 * Revision 1.1  1993/08/30  23:26:51  manchek
 * Initial revision
 *
 */

/* iPSC/860 */

#ifdef IMA_I860
#define CUBENAMELEN		16		/* max number of characters in cube name */
#define MAKECUBENAME(name,no)	(sprintf((name),"pvm%d",(no)))
#endif


/*
 * message handling routines
 *
 * ASYNCWAIT():		waits for asynchronous send/recv to complete
 * ASYNCDONE():		returns 1 if the asynchronous send/recv has completed; 0
 *					otherwise
 * ASYNCSEND():		asynchronous send
 * ASYNCRECV():		asynchronous receive
 * MSGSIZE():		length (in bytes) of pending/received message
 * MSGSENDER():		address of the sender
 */

#ifdef IMA_CM5

#include <cm/cmmd.h>
#define ASYNCDONE(mid)			CMMD_msg_done(mid)
#define ASYNCWAIT(mid)			CMMD_msg_wait(mid)
#define MSGSIZE(mid)			CMMD_bytes_received()
#define MSGSENDER(mid)			CMMD_msg_sender()
#define MSGTAG(mid)				CMMD_msg_tag()
#define ASYNCRECV(src,tag,buf,len,ptype,info) \
		CMMD_receive_async(src,tag,buf,len,(void*)0,(void*)0)
#define ASYNCSEND(tag,buf,len,dest,ptype) \
		CMMD_send_async((int)(dest),tag,buf,len,(void*)0,(void*)0)
#define PVMCSEND(tag,buf,len,dest,ptype) \
								CMMD_send_noblock((int)(dest),tag,buf,len)
/*
								CMMD_send_block((int)(dest),tag,buf,len)
*/
#define PVMCRECV(src,tag,buf,len,ptype,info) \
								CMMD_receive_block((int)src,tag,buf,len)
#define MSGPROBE(src,tag,info)	CMMD_msg_pending((int)src,tag)
#define NUMSMHD		90			/* CMMD has about 100 message IDs */
#define MPPANYNODE	CMMD_ANY_NODE
#define MPPANYTAG	CMMD_ANY_TAG
/* fragment on async send queue */
struct tmpfrag {
	struct frag *tf_fp;			/* fragment queued */
	CMMD_mcb tf_mhdl;			/* msg handle returned by async send */
};
#define PVMMHDNULL	CMMD_ERRVAL	/* null msg handle */

#endif /*IMA_CM5*/

#if defined(IMA_PGON) || defined(IMA_I860)

#define ASYNCDONE(mid)	_msgdone(mid)
#define ASYNCWAIT(mid)	_msgwait(mid)
/* #define ASYNCRECV(buf,len)		_irecv((long)recvmask,buf,(long)len) */
#define ASYNCSEND(tag,buf,len,dest,ptype)	_isend(tag,buf,(long)len,dest,ptype)
#define PVMCSEND(tag,buf,len,dest,ptype)	_csend(tag,buf,(long)len,dest,ptype)
#define NUMSMHD		64			/* the Paragon has 999 message IDs (snd/recv) */
								/* msg buffer for Paragon holds 1MB; = 64x16K */
#define MPPANYNODE	-1
#define MPPANYTAG	-1
/* fragment on async send queue */
struct tmpfrag {
	struct frag *tf_fp;			/* fragment queued */
	long tf_mhdl;				/* msg handle returned by async send */
};
#define PVMMHDNULL	-1	/* null msg handle */
/*
#ifdef IMA_I860
#define NUMSMHD		1
#endif
*/

#endif /*IMA_PGON/IMA_I860*/

#if defined(IMA_SP2MPI) && defined(MPI_H)

#define ASYNCDONE(req)	(!MPI_Test(&req,&mpiflag,&mpista) && mpiflag)
#define ASYNCWAIT(req)	MPI_Wait(&req,&mpista)
#define MSGSIZE(sta)	(MPI_Get_count(&sta,MPI_BYTE,&mpisiz) ? 0 : mpisiz)
#define MSGSENDER(sta)	sta.MPI_SOURCE
#define MSGTAG(sta)		sta.MPI_TAG
#define MSGPROBE(src,tag,info)	\
			(!MPI_Iprobe((int)src,tag,MPI_COMM_WORLD,&mpiflag,&info) && mpiflag)
#define PVMCSEND(tag,buf,len,dest,ptype)	\
					MPI_Bsend(buf,len,MPI_BYTE,(int)dest,tag,MPI_COMM_WORLD)
#define PVMCRECV(src,tag,buf,len,ptype,info) \
					MPI_Recv(buf,len,MPI_BYTE,(int)src,tag,MPI_COMM_WORLD,&info)
#define NUMSMHD	    64		/* max number of outstanding async sends */
#define MPPANYNODE	MPI_ANY_SOURCE
#define MPPANYTAG	MPI_ANY_TAG
/* fragment on async send queue */
struct tmpfrag {
	struct frag *tf_fp;			/* fragment queued */
	MPI_Request tf_mhdl;		/* msg handle returned by async send */
};
#define PVMMHDNULL	MPI_REQUEST_NULL	/* null msg handle */
#define MPIBUFSIZ	0x00400000	/* buffer for Bsend (4M) */

#endif /*IMA_SP2MPI*/

#ifdef IMA_PGON
#define MSGSIZE(info)			info[1]
#define MSGSENDER(info)			info[2]
#define MSGTAG(info)			info[0]
#define MSGPROBE(src,tag,info)	_iprobex(tag,src,-1,info)
#define PVMCRECV(src,tag,buf,len,ptype,info) \
							_crecvx(tag,buf,(long)len,src,ptype,info)
#define ASYNCRECV(src,tag,buf,len,ptype,info) \
							_irecvx(tag,buf,(long)len,src,ptype,info)
#endif
#ifdef IMA_I860
#define MSGSIZE(mid)			_infocount()
#define MSGSENDER(mid)			_infonode()
#define MSGTAG(mid)				_infotype()
#define MSGPROBE(src,tag,info)	_iprobe(tag)
#define PVMCRECV(src,tag,buf,len,ptype,info) _crecv(tag,buf,(long)len)
#endif

/* nodes in use */

struct nodeset {
	struct nodeset *n_link;		/* linked list */
	struct nodeset *n_rlink;
	int n_size;					/* number of nodes */
	int n_first;				/* the first node in the set */
	int n_ptype;				/* (PGON) ptype of tasks on the nodes  */
	int n_alive;				/* number of active nodes */
	int n_ptid;					/* tid of task who spawned us */
#ifdef IMA_I860
#define n_cid	n_ptype			/* the global qm_cubeid */
	char *n_name;				/* cube name */
#endif
};

/* tid fields */

#define TIDNODE		0x000007ff	/* 11 bits for node number */
#define TIDPTYPE	0x0001f800	/* 6 bits for process type */

#ifndef TIDONNODE
#define TIDONNODE	0x00020000	/* this bit is set for node tasks */
/* determine if task is a node process */
#define TIDISNODE(x)	(!((x)&(TIDGID|TIDPVMD)) && ((x)&TIDONNODE))
#endif /*TIDONNODE*/

#define NUMPTYPE	64			/* (PGON) num of active proc types allowed */
#define PVMDPTYPE	0			/* process type of pvmd */
#define PDMNODE		128			/* pvmd debug mask */
#define MAXFRAGSIZE	0x00004000	/* max fragment size (16K) */
#ifdef	IMA_PGON
#define SIZEHINFO	10			/* size of hostinfo array */
#else
#define SIZEHINFO	5			/* size of hostinfo array */
#endif

/* extract the ptype bits */
#define TIDTOTYPE(x)	((x)&tidtmask)>>(ffs(tidtmask)-1)

/* pvm internal message types */

#define PMTPACK		999999001	/* packed messages */
#define PMTHOST		(PMTPACK+1)	/* broadcast myhostpart to all nodes */
#define PMTPHYS		(PMTPACK+2)	/* (iPSC/860) msg containing physical node # */
