
#include "pvmwin.h"
#include <fcntl.h>

char pvmtxt[512];
extern char * username;
extern int debugmask;
	 
int win32_write_socket (SOCKET s,const char FAR *tosend, int size)
{
	int nSend=0;

	int size2send=size;

	while (size2send > 0) {
      if ((nSend = send(s, tosend, size2send, 0)) == -1)
		  return nSend;
	
	  tosend += nSend;
	  size2send -= nSend;

	}
/*
	sprintf(pvmtxt,"loclinput, to send: %d yes, send: %d\n",size,size-size2send);
	pvmlogerror(pvmtxt);
*/
	return size-size2send;	/* this should be $size in the end */
}


int win32_read_socket (SOCKET s,char FAR *torecv, int size)
{
	int nReceived=0;

	int size2recv=size;
	
	while (size2recv > 0) {
      
      if ((nReceived = recv(s, torecv, size2recv, 0)) == -1)
		  return nReceived;
	  
	  torecv += nReceived;
	  size2recv -= nReceived;

	}
/*
	sprintf(pvmtxt,"loclinput, to read: %d yes, read: %d\n",size,size-size2recv);
	pvmlogerror(pvmtxt);
*/ 
	return size-size2recv;
}

int gettimeofday(struct timeval *t, struct timezone *tzp)
{
	struct _timeb timebuffer;
	
   	_ftime( &timebuffer );	/* this calls the time and returns sec ** msec*/
   	t->tv_sec=timebuffer.time;
   	t->tv_usec=timebuffer.millitm*1000;
 	return 1;
}	
				
void
Wait(HANDLE id, DWORD *prv)
{
	if (!WaitForSingleObject(id, INFINITE)) {
		*prv = 2;
	} else {
		if (!GetExitCodeThread(id, prv)) {
			*prv = 4;
		}
	}
}

void nt_rpc_report( char *s)
{
	printf("Error: %s: %d\n",s,GetLastError());
}

void ErrorHandler(char *s)
{
	printf("Error: %s: %d\n",s,GetLastError());
}

int win32_close_file(HANDLE f)
{
	int success;
	success = CloseHandle(f);
	return success;
	
}
HANDLE win32_create_file(char *TMP_AREA, int mode)
{

	HANDLE hFile; 
    PSECURITY_DESCRIPTOR pSD; 
    PACL pACLNew; 
    DWORD cbACL = 1024; 
    PSID pSID; 
    DWORD cbSID = 1024; 
    LPSTR szUserName;
	DWORD dwUserNameLength;
    LPSTR lpszDomain; 
    DWORD cchDomainName = 80; 
    PSID_NAME_USE psnuType; 
 
    /* Initialize a new security descriptor. */ 
 

    pSD = (PSECURITY_DESCRIPTOR) LocalAlloc(LPTR, 
        SECURITY_DESCRIPTOR_MIN_LENGTH);  /* defined in WINNT.H  */ 
    if (pSD == NULL) { 
        ErrorHandler("LocalAlloc"); 
        return FALSE; 
    } 
 
    if (!InitializeSecurityDescriptor(pSD, 
            SECURITY_DESCRIPTOR_REVISION)) { 
	
        ErrorHandler("InitializeSecurityDescriptor"); 
        goto Cleanup; 
    } 
 
    /* Initialize a new ACL.                 */ 
 
    pACLNew = (PACL) LocalAlloc(LPTR, cbACL); 
    if (pACLNew == NULL) { 
        ErrorHandler("LocalAlloc"); 
        goto Cleanup; 
    } 
 
    if (!InitializeAcl(pACLNew, cbACL, ACL_REVISION2)) { 
		if (GetLastError() == ERROR_CALL_NOT_IMPLEMENTED) {
			return -2;
		}
        ErrorHandler("InitializeAcl"); 
        goto Cleanup; 
    } 
 
    /* Retrieve the SID for User        */ 
	if (username)
		szUserName=username;
	else
 		szUserName=MyGetUserName();

    pSID = (PSID) LocalAlloc(LPTR, cbSID); 
    psnuType = (PSID_NAME_USE) LocalAlloc(LPTR, 1024); 
    lpszDomain = (LPSTR) LocalAlloc(LPTR, cchDomainName); 
    if (pSID == NULL || psnuType == NULL || 
        lpszDomain == NULL) { 
        ErrorHandler("LocalAlloc"); 
        goto Cleanup; 
    } 
 
    if (!LookupAccountName((LPSTR) NULL, /* local name */ 
            szUserName, 
            pSID, 
            &cbSID, 
            lpszDomain, 
            &cchDomainName, 
            psnuType)) { 
        ErrorHandler("LookupAccountName"); 
        goto Cleanup; 
    } 
    if (!IsValidSid(pSID))    
        ErrorHandler("SID is not valid.\n"); 
   
 
    /* Allow read but not write access to the file. */ 
 
    if (!AddAccessAllowedAce(pACLNew, 
            ACL_REVISION2, 
            GENERIC_ALL, 
            pSID)) { 
        ErrorHandler("AddAccessAllowedAce"); 
        goto Cleanup; 
    } 
 
    /* Add a new ACL to the security descriptor.          */ 
 
    if (!SetSecurityDescriptorDacl(pSD, 
            TRUE,              /* fDaclPresent flag  */ 
            pACLNew, 
            FALSE)) {          /* not a default disc. ACL */ 
        ErrorHandler("SetSecurityDescriptorDacl"); 
        goto Cleanup; 
    } 

	hFile = CreateFile(TMP_AREA,
					GENERIC_WRITE | GENERIC_READ,
					// FILE_SHARE_READ | FILE_SHARE_WRITE,
					0,
					NULL,
					mode,
					FILE_ATTRIBUTE_NORMAL,
					NULL);
if (GetLastError() == ERROR_ALREADY_EXISTS)
	if (mode == CREATE_NEW)
		return -1;

if (hFile == INVALID_HANDLE_VALUE)
{
	return -1;
}
    /* Apply the new security descriptor to the file. */ 
 
if (!SetFileSecurity(TMP_AREA, 
          DACL_SECURITY_INFORMATION, 
          pSD)) { 
        ErrorHandler("SetFileSecurity"); 
        goto Cleanup; 
} 
    
// printf("Successfully added access-allowed ACE to file's DACL.\n");

return hFile;

   Cleanup: 
        FreeSid(pSID); 
        if(pSD != NULL) 
            LocalFree((HLOCAL) pSD); 
        if(pACLNew != NULL) 
            LocalFree((HLOCAL) pACLNew); 
        if(psnuType != NULL) 
            LocalFree((HLOCAL) psnuType); 
        if(lpszDomain != NULL) 
            LocalFree((HLOCAL) lpszDomain); 
	return 0;
  }

int win32_write_file(HANDLE f, char *s,int size)
{
	int sizewritten=0;

	if (!WriteFile(f,s,size,&sizewritten,NULL)) {
		sprintf(pvmtxt,"Could not write to file :%d \n",GetLastError());
		pvmlogerror(pvmtxt);
		return 0;
	}
	return sizewritten;

}
int win32_read_file(HANDLE f, char *s,int size)
{
	int sizeread=0;
	if (!ReadFile(f,s,size,&sizeread,NULL)) {
	sprintf(pvmtxt,"Could not read data from file :%d \n",GetLastError());
		pvmlogerror(pvmtxt);
		return -1;
	}
	return sizeread;

}

HANDLE win32_open_file(char *TMP_AREA)
{
	HANDLE hF;

	hF= win32_create_file(TMP_AREA,OPEN_EXISTING);
	if (hF == INVALID_HANDLE_VALUE)
		printf("Could not open file %s: %d \n",TMP_AREA,GetLastError());
	return hF;
}

int kill( int pid, int p_handle, int signal)
{


	char pvmtxt[32];
	HANDLE hProcess;

	// DebugBreak();
	if (p_handle)
	if (!TerminateProcess((HANDLE)p_handle,signal)) {
		sprintf(pvmtxt,"Unable to terminate process: %d \n",p_handle);
		pvmlogerror(pvmtxt);
	} else return TRUE;

	hProcess = OpenProcess(PROCESS_ALL_ACCESS,FALSE,pid);

	if (hProcess) {
		if (!TerminateProcess(hProcess,signal)) {
			sprintf(pvmtxt,"Unable to terminate process: %d \n",hProcess);
			pvmlogerror(pvmtxt);
		} else {CloseHandle (hProcess);return TRUE;}
	}
	CloseHandle (hProcess);
	return TRUE;
}

char *MyGetUserName()
{

	char *thisname=0;
	char myuser[64];	
	DWORD szuser=64;
	char pvmtxt[128];
	if (!GetUserName(myuser,&szuser)) {
		sprintf(pvmtxt,"You are not logged on to this machine :%d \n Continued by provided username",GetLastError());
		return NULL;
	}
	thisname = malloc (16 *sizeof(char));
	strncpy(thisname,myuser,16);
	return thisname;

}
	   			  
int win32_delete_file(char *TMP_AREA)
{
  return (!DeleteFile(TMP_AREA));
}
