!***begin prologue  fthci
!***date written   860701   (yymmdd)
!***revision date  900509   (yymmdd)
!***revision date  000928   (yymmdd)
!***category no.  j1a3
!***keywords  fast fourier transform, cosine transform, multiple
!             sequences
!***authors  r.a. sweet, l.l. lindgren and r.f boisvert (nist)
!            s.r. clarke (s.clarke@maths.monash.edu.au)
!***purpose  initialize for fthc.
!***description
!
!  subroutine fthci initializes the array wsave which is used in
!  subroutine fthc.  the prime factorization of n together with
!  a tabulation of the trigonometric functions are computed and
!  stored in wsave.
!
!  input and output parameter
!
!  wsave   a real work array of length 2*n+15, where n is
!          the length of the sequence to be transformed.  the method
!          is most efficient when n-1 is a product of small primes.
!          different wsave arrays are required for different values
!          of n.  the contents of wsave must not be changed between
!          calls of sint.
!
!  -----------------------------------------------------------------
!
!  fthci is a straightforward extension of the subprogram costi
!  originally developed by p. n. swarztrauber of ncar.
!
!***references  p. n. swarztrauber, vectorizing the ffts, in parallel
!               computations, (g. rodrigue, ed.), academic press, 1982,
!               pp. 51-83.
!***end prologue  fthci
!
!     fftpk, version 3, sept 2000
!
module HalfCosInit
  use PiMachine
  use RealInit
  implicit none
  private
  public fthci,fthciq
  interface fthci
    module procedure sfthci,dfthci
  end interface
contains
!
!	returns the appropriate length for wsave, given the length of the
!	arrary to be transformed
!
  integer function fthciq(n)
    integer, intent(in) :: n
!
    fthciq = 2*n+15
!
  end function
!
!     single precision version
!
  subroutine sfthci(wsave)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:),target :: wsave(:)
!
    real(kr), dimension(:), pointer :: wp
    real(kr), parameter :: two=2._kr
    real(kr) arg
    integer n,nm1,np1,ns2,k

    n = (size(wsave)-15)/2
    nm1=n-1
    np1=n+1
    ns2=n/2
    arg = pimach(.0_kr)/real(nm1,kr)

    if (n<=3) return
    wsave(2:ns2) = two*sin(arg*(/ (real(k-1,kr),k=2,ns2) /))
    wsave(nm1:ns2+1:-1) = two*cos(arg*(/ (real(k-1,kr),k=2,ns2) /))
    wp => wsave(n+2:)
    call fti (wp)
  end subroutine
!
!     double precision version
!
  subroutine dfthci(wsave)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:),target :: wsave(:)
!
    real(kr), dimension(:), pointer :: wp
    real(kr), parameter :: two=2._kr
    real(kr) arg
    integer n,nm1,np1,ns2,k

    n = (size(wsave)-15)/2
    nm1=n-1
    np1=n+1
    ns2=n/2
    arg = pimach(.0_kr)/real(nm1,kr)

    if (n<=3) return
    wsave(2:ns2) = two*sin(arg*(/ (real(k-1,kr),k=2,ns2) /))
    wsave(nm1:ns2+1:-1) = two*cos(arg*(/ (real(k-1,kr),k=2,ns2) /))
    wp => wsave(n+2:)
    call fti (wp)
  end subroutine
end module HalfCosInit
