!***begin prologue  fthsi
!***date written   860701   (yymmdd)
!***revision date  900509   (yymmdd)
!***revision date  000928   (yymmdd)
!***category no.  j1a3
!***keywords  fast fourier transform, sine transform, multiple
!             sequences
!***authors  r.a. sweet, l.l. lindgren and r.f boisvert (nist)
!            s.r. clarke (s.clarke@maths.monash.edu.au)
!***purpose  initialize for fths.
!***description
!
!  subroutine fthsi initializes the array wsave which is used in
!  subroutine fths.  the prime factorization of n+1 
!  with a tabulation of the trigonometric functions is computed and
!  stored in wsave.
!
!  input and output parameter
!
!  wsave   a real work array of length 2*n+15, where n is
!          the length of the sequence to be transformed.  the method
!          is most efficient when n+1 is a product of small primes.
!          different wsave arrays are required for different values
!          of n.  the contents of wsave must not be changed between
!          calls of fths.
!
!  -----------------------------------------------------------------
!
!  fthsi is a straightforward translation of the subprogram sinti
!  originally developed p. n. swarztrauber of ncar.
!
!***references  p. n. swarztrauber, vectorizing the ffths, in parallel
!               computations, (g. rodrigue, ed.), academic press, 1982,
!               pp. 51-83.
!***end prologue  fthsi
!
!     fftpk, version 3, sept 2000
!
module HalfSinInit
  use PiMachine
  use RealInit
  implicit none
  private
  public fthsi,fthsiq
  interface fthsi
    module procedure sfthsi,dfthsi
  end interface
contains
!
!	returns the appropriate length for wsave, given the length of the
!	arrary to be transformed
!
  integer function fthsiq(n)
    integer, intent(in) :: n
!
    fthsiq = 2*n+15
!
  end function
!
!     single precision version
!
  subroutine sfthsi(wsave)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), target :: wsave
!
    real(kr), dimension(:), pointer :: wp
    real(kr) arg
    integer n,np1,ns2,k

    n=(size(wsave)-15)/2
    np1=n+1
    ns2=n/2
    arg = pimach(.0_kr)/real(np1,kr)

    if (n<=1) return
    wsave(:ns2) = 2._kr*sin(arg*(/ (real(k,kr),k=1,ns2) /))
    wp => wsave(n:)
    call fti (wp)
    
  return
  end subroutine
!
!     double precision version
!
  subroutine dfthsi(wsave)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), target :: wsave
!
    real(kr), dimension(:), pointer :: wp
    real(kr) arg
    integer n,np1,ns2,k

    n=(size(wsave)-15)/2
    np1=n+1
    ns2=n/2
    arg = pimach(.0_kr)/real(np1,kr)

    if (n<=1) return
    wsave(:ns2) = 2._kr*sin(arg*(/ (real(k,kr),k=1,ns2) /))
    wp => wsave(n:)
    call fti (wp)
    
  return
  end subroutine
end module HalfSinInit
