!***begin prologue fti
!***date written   860701   (yymmdd)
!***revision date  900509   (yymmdd)
!***revision date  000928   (yymmdd)
!***category no.  j1a1
!***keywords  fast fourier transform, real periodic transform,
!             multiple sequences
!***authors  r.a. sweet, l.l. lindgren and r.f boisvert (nist)
!            s.r. clarke (s.clarke@maths.monash.edu.au)
!***purpose  initialization for ftrf, ftrb, ftcf and ftcb.
!***description
!
!  subroutine fti initializes the array wsave which is used in
!  both ftrf, ftrb, ftcf and ftcb. the prime factorization of n
!  and a tabulation of certain trigonometric functions are computed and
!  stored in the array wsave.
!
!  input and output parameter
!
!  wsave   a real work array of dimension n+15, where n is the
!          length of the sequence to be transformed
!          the same work array can be used for both ft[rc]f and ft[rc]b
!          as long as n remains unchanged.  different wsave arrays
!          are required for different values of n.  the contents of
!          wsave must not be changed between calls of ft[rc]f and ft[rc]b.
!
!
!  fti is a translation of the subprogram rffti which was
!  originally developed by p. n. swarztrauber of ncar.
!
!
!***references  p. n. swarztrauber, vectorizing the ffts, in parallel
!               computations, (g. rodrigue, ed.), academic press, 1982,
!               pp. 51-83.
!***end prologue  fti
!
!     fftpk, version 3, sept 2000
!
module RealInit
  use PiMachine
  implicit none
  private
  public fti,ftiq
  interface fti
    module procedure sftri,dftri
  end interface
contains
!
!	returns the appropriate length for wsave, given the length of the
!	arrary to be transformed
!
  integer function ftiq(n)
    integer, intent(in) :: n
!
    ftiq = n+15
!
  end function
!
!    single precision version
!
  subroutine sftri (wsave)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(inout) :: wsave
    integer, dimension(15) :: fac
!
    real(kr), parameter :: two=2._kr
    integer, dimension(4) :: ntryh=(/4,2,3,5/)
    real(kr), dimension((size(wsave)-15)/2) :: arg,dumi
    real(kr) argh,argld
    integer n,nl,nf,j,ntry,nq,nr,i,is,nfm1,l1,ld,l2,ido,id2m1,ipm,ii,k1,ip

    n=size(wsave)-15
!
    nl = n
    nf = 0
    j = 1
    ntry = ntryh(j)
    do
      nq = nl/ntry
      nr = nl-ntry*nq
      if (nr/=0) then
        j = j+1
        select case (j)
        case (:4)
          ntry = ntryh(j)
        case (5:)
          ntry = ntry+2
        end select
        cycle
      endif
      nf = nf+1
      fac(nf+2) = ntry
      nl = nq
      if (ntry==2) then
        fac(nf+2:4:-1) = fac(nf+1:3:-1)
        fac(3) = 2
      endif
      if (nl==1) exit
    enddo
    fac(1) = n
    fac(2) = nf
    wsave(n+1:) = fac
!
    argh = two*pimach(.0_kr)/real(n,kr)
    is = 0
    nfm1 = nf-1
    l1 = 1
    if (nfm1==0) return
    dumi(:n/2) = (/ (real(ii,kr),ii=1,n/2) /)
    do k1=1,nfm1
      ip = fac(k1+2)
      ld = 0
      l2 = l1*ip
      ido = n/l2
      ipm = ip-1
      id2m1 = (ido-1)/2
      do j=1,ipm
        ld = ld+l1
        i = is
        argld = real(ld,kr)*argh
        arg(:id2m1) = dumi(:id2m1)*argld
        wsave(is+1:is+ido-2:2) = cos(arg(:id2m1))
        wsave(is+2:is+ido-1:2) = sin(arg(:id2m1))
        is = is+ido
      enddo
      l1 = l2
    enddo
!    
  return
  end subroutine
!
!    double precision version
!
  subroutine dftri (wsave)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(inout) :: wsave
    integer, dimension(15) :: fac
!
    real(kr), parameter :: two=2._kr
    integer, dimension(4) :: ntryh=(/4,2,3,5/)
    real(kr), dimension((size(wsave)-15)/2) :: arg,dumi
    real(kr) argh,argld
    integer n,nl,nf,j,ntry,nq,nr,i,is,nfm1,l1,ld,l2,ido,id2m1,ipm,ii,k1,ip

    n=size(wsave)-15
!
    nl = n
    nf = 0
    j = 1
    ntry = ntryh(j)
    do
      nq = nl/ntry
      nr = nl-ntry*nq
      if (nr/=0) then
        j = j+1
        select case (j)
        case (:4)
          ntry = ntryh(j)
        case (5:)
          ntry = ntry+2
        end select
        cycle
      endif
      nf = nf+1
      fac(nf+2) = ntry
      nl = nq
      if (ntry==2) then
        fac(nf+2:4:-1) = fac(nf+1:3:-1)
        fac(3) = 2
      endif
      if (nl==1) exit
    enddo
    fac(1) = n
    fac(2) = nf
    wsave(n+1:) = fac
!
    argh = two*pimach(.0_kr)/real(n,kr)
    is = 0
    nfm1 = nf-1
    l1 = 1
    if (nfm1==0) return
    dumi(:n/2) = (/ (real(ii,kr),ii=1,n/2) /)
    do k1=1,nfm1
      ip = fac(k1+2)
      ld = 0
      l2 = l1*ip
      ido = n/l2
      ipm = ip-1
      id2m1 = (ido-1)/2
      do j=1,ipm
        ld = ld+l1
        i = is
        argld = real(ld,kr)*argh
        arg(:id2m1) = dumi(:id2m1)*argld
        wsave(is+1:is+ido-2:2) = cos(arg(:id2m1))
        wsave(is+2:is+ido-1:2) = sin(arg(:id2m1))
        is = is+ido
      enddo
      l1 = l2
    enddo
    
  return
  end subroutine
end module RealInit
