!***begin prologue  ftqi
!***date written   860701   (yymmdd)
!***revision date  900509   (yymmdd)
!***revision date  000928   (yymmdd)
!***category no.  j1a3
!***keywords  fast fourier transform, cosine transform, odd wave
!             numbers, multiple sequences
!***authors  r.a. sweet, l.l. lindgren and r.f boisvert (nist)
!            s.r. clarke (s.clarke@maths.monash.edu.au)
!***purpose  initialize for ftqcf, ftqcb, ftqsf and ftqsb.
!***description
!
!  subroutine ftqci initializes the array wsave which is used in
!  ftqcf, ftqcb, ftqsf and ftqsb.  the prime factorization of n
!  and a tabulation of the trigonometric functions are computed and
!  stored in wsave.
!
!  input and output parameter
!
!  wsave   a real work array which must be dimensioned 2*n+15, where n
!          is the length of the array to be transformed.  the method
!          is most efficient when n is a product of small primes.
!          the same work array can be used for both ftq[cs][fb],
!          as long as n remains unchanged.  different wsave arrays
!          are required for different values of n.  the contents of
!          wsave must not be changed between calls of ftq[cs]f and ftq[cs]b.
!
!***references  p. n. swarztrauber, vectorizing the ffts, in parallel
!               computations, (g. rodrigue, ed.), academic press, 1982,
!               pp. 51-83.
!
!***ftqi is a straightforward translation of cosqi and sinqi originally
!   developed by p.n. swarztrauber of ncar.
!
!***end prologue  ftqi
!
!     fftpk, version 3, sept 2000
!
module QuartInit
  use PiMachine
  use RealInit
  implicit none
  private
  public ftqi,ftqiq
  interface ftqi
    module procedure sftqi,dftqi
  end interface
contains
!
!	returns the appropriate length for wsave, given the length of the
!	arrary to be transformed
!
  integer function ftqiq(n)
    integer, intent(in) :: n
!
    ftqiq = 2*n+15
!
  end function
!
!     single precision version
!
  subroutine sftqi(wsave)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(inout), target :: wsave
!
    real(kr), dimension(:), pointer :: wp
    real(kr), parameter :: two=2._kr
    real(kr) dt
    integer n,k

    n = (size(wsave)-15)/2
    dt = pimach(.0_kr)/(two*real(n,kr))
    wsave(:n) = cos(dt*(/ (real(k,kr),k=1,n) /))
    wp => wsave(n+1:)
    call fti(wp)
  end subroutine
!
!     double precision version
!
  subroutine dftqi(wsave)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(inout), target :: wsave
!
    real(kr), dimension(:), pointer :: wp
    real(kr), parameter :: two=2._kr
    real(kr) dt
    integer n,k

    n = (size(wsave)-15)/2
    dt = pimach(.0_kr)/(two*real(n,kr))
    wsave(:n) = cos(dt*(/ (real(k,kr),k=1,n) /))
    wp => wsave(n+1:)
    call fti(wp)
  end subroutine
end module QuartInit
