!
!     fftpk, version 3, sept. 2000
!
module Radix2b
  implicit none
  private
  public radb2
  interface radb2
    module procedure sradb2,dradb2,svradb2,dvradb2
  end interface
contains
!
!     single precision scalar version
!
  subroutine sradb2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(ido,2,l1) :: cc
    real(kr), dimension(ido,l1,2) :: ch
    integer m,n,idp2,i,ic
!
    n = size(cci) 
    cc = reshape(cci,(/ido,2,l1/))
    ch(1,:,1) = cc(1,1,:)+cc(ido,2,:)
    ch(1,:,2) = cc(1,1,:)-cc(ido,2,:)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) = cc(i-1,1,:)+cc(ic-1,2,:)
      ch(i,:,1) = cc(i,1,:)-cc(ic,2,:)
      ch(i-1,:,2) = wa1(i-2)*(cc(i-1,1,:)-cc(ic-1,2,:)) &
                      -wa1(i-1)*(cc(i,1,:)+cc(ic,2,:))
      ch(i,:,2) = wa1(i-2)*(cc(i,1,:)+cc(ic,2,:)) &
                      +wa1(i-1)*(cc(i-1,1,:)-cc(ic-1,2,:))
    enddo
    if (mod(ido,2) == 0) then
      ch(ido,:,1) = cc(ido,1,:)+cc(ido,1,:)
      ch(ido,:,2) = -(cc(1,2,:)+cc(1,2,:))
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!     double precision scalar version
!
  subroutine dradb2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(ido,2,l1) :: cc
    real(kr), dimension(ido,l1,2) :: ch
    integer n,idp2,i,ic
!
    n = size(cci)
    cc = reshape(cci,(/ido,2,l1/))
    ch(1,:,1) = cc(1,1,:)+cc(ido,2,:)
    ch(1,:,2) = cc(1,1,:)-cc(ido,2,:)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) = cc(i-1,1,:)+cc(ic-1,2,:)
      ch(i,:,1) = cc(i,1,:)-cc(ic,2,:)
      ch(i-1,:,2) = wa1(i-2)*(cc(i-1,1,:)-cc(ic-1,2,:)) &
                      -wa1(i-1)*(cc(i,1,:)+cc(ic,2,:))
      ch(i,:,2) = wa1(i-2)*(cc(i,1,:)+cc(ic,2,:)) &
                      +wa1(i-1)*(cc(i-1,1,:)-cc(ic-1,2,:))
    enddo
    if (mod(ido,2) == 0) then
      ch(ido,:,1) = cc(ido,1,:)+cc(ido,1,:)
      ch(ido,:,2) = -(cc(1,2,:)+cc(1,2,:))
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!     single precision vector version
!
  subroutine svradb2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(size(cci,1),ido,2,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,2) :: ch
    integer m,n,idp2,i,ic
!
    m = size(cci,1) 
    n = size(cci,2)
    cc = reshape(cci,(/m,ido,2,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+cc(:,ido,2,:)
    ch(:,1,:,2) = cc(:,1,1,:)-cc(:,ido,2,:)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) = cc(:,i-1,1,:)+cc(:,ic-1,2,:)
      ch(:,i,:,1) = cc(:,i,1,:)-cc(:,ic,2,:)
      ch(:,i-1,:,2) = wa1(i-2)*(cc(:,i-1,1,:)-cc(:,ic-1,2,:)) &
                      -wa1(i-1)*(cc(:,i,1,:)+cc(:,ic,2,:))
      ch(:,i,:,2) = wa1(i-2)*(cc(:,i,1,:)+cc(:,ic,2,:)) &
                      +wa1(i-1)*(cc(:,i-1,1,:)-cc(:,ic-1,2,:))
    enddo
    if (mod(ido,2) == 0) then
      ch(:,ido,:,1) = cc(:,ido,1,:)+cc(:,ido,1,:)
      ch(:,ido,:,2) = -(cc(:,1,2,:)+cc(:,1,2,:))
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!     double precision vector version
!
  subroutine dvradb2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(size(cci,1),ido,2,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,2) :: ch
    integer m,n,idp2,i,ic
!
    m = size(cci,1) 
    n = size(cci,2)
    cc = reshape(cci,(/m,ido,2,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+cc(:,ido,2,:)
    ch(:,1,:,2) = cc(:,1,1,:)-cc(:,ido,2,:)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) = cc(:,i-1,1,:)+cc(:,ic-1,2,:)
      ch(:,i,:,1) = cc(:,i,1,:)-cc(:,ic,2,:)
      ch(:,i-1,:,2) = wa1(i-2)*(cc(:,i-1,1,:)-cc(:,ic-1,2,:)) &
                      -wa1(i-1)*(cc(:,i,1,:)+cc(:,ic,2,:))
      ch(:,i,:,2) = wa1(i-2)*(cc(:,i,1,:)+cc(:,ic,2,:)) &
                      +wa1(i-1)*(cc(:,i-1,1,:)-cc(:,ic-1,2,:))
    enddo
    if (mod(ido,2) == 0) then
      ch(:,ido,:,1) = cc(:,ido,1,:)+cc(:,ido,1,:)
      ch(:,ido,:,2) = -(cc(:,1,2,:)+cc(:,1,2,:))
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix2b
