!
!     fftpk, version 3, sept. 2000
!
module Radix3b
  use PiMachine
  implicit none
  private
  public radb3
  interface radb3
    module procedure sradb3,dradb3,svradb3,dvradb3
  end interface
contains
!
!     single precision scalar version
!
  subroutine sradb3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,three=3._kr
    real(kr), dimension(ido,3,l1) :: cc
    real(kr), dimension(ido,l1,3) :: ch
    real(kr) arg,taur,taui
    integer n,idp2,i,ic

    arg=two*pimach(.0_kr)/three
    taur=cos(arg)
    taui=sin(arg)
    n=size(cci)
    cc = reshape(cci,(/ido,3,l1/))
    ch(1,:,1) = cc(1,1,:)+two*cc(ido,2,:)
    ch(1,:,2) = cc(1,1,:)+two*(taur*cc(ido,2,:)-taui*cc(1,3,:))
    ch(1,:,3) = cc(1,1,:)+two*(taur*cc(ido,2,:)+taui*cc(1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) = cc(i-1,1,:)+(cc(i-1,3,:)+cc(ic-1,2,:))
      ch(i,:,1) = cc(i,1,:)+(cc(i,3,:)-cc(ic,2,:))
      ch(i-1,:,2) = &
         wa1(i-2)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
         -(taui*(cc(i,3,:)+cc(ic,2,:)))) &
         -wa1(i-1)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
         +(taui*(cc(i-1,3,:)-cc(ic-1,2,:))))
      ch(i,:,2) =  &
          wa1(i-2)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          +(taui*(cc(i-1,3,:)-cc(ic-1,2,:)))) &
          +wa1(i-1)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          -(taui*(cc(i,3,:)+cc(ic,2,:))))
      ch(i-1,:,3) =  &
          wa2(i-2)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          +(taui*(cc(i,3,:)+cc(ic,2,:)))) &
          -wa2(i-1)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          -(taui*(cc(i-1,3,:)-cc(ic-1,2,:))))
      ch(i,:,3) = &
          wa2(i-2)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          -(taui*(cc(i-1,3,:)-cc(ic-1,2,:)))) &
          +wa2(i-1)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          +(taui*(cc(i,3,:)+cc(ic,2,:))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!     double precision scalar version
!
  subroutine dradb3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,three=3._kr
    real(kr), dimension(ido,3,l1) :: cc
    real(kr), dimension(ido,l1,3) :: ch
    real(kr) arg,taur,taui
    integer n,idp2,i,ic

    arg=two*pimach(.0_kr)/three
    taur=cos(arg)
    taui=sin(arg)
    n=size(cci)
    cc = reshape(cci,(/ido,3,l1/))
    ch(1,:,1) = cc(1,1,:)+two*cc(ido,2,:)
    ch(1,:,2) = cc(1,1,:)+two*(taur*cc(ido,2,:)-taui*cc(1,3,:))
    ch(1,:,3) = cc(1,1,:)+two*(taur*cc(ido,2,:)+taui*cc(1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) = cc(i-1,1,:)+(cc(i-1,3,:)+cc(ic-1,2,:))
      ch(i,:,1) = cc(i,1,:)+(cc(i,3,:)-cc(ic,2,:))
      ch(i-1,:,2) = &
         wa1(i-2)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
         -(taui*(cc(i,3,:)+cc(ic,2,:)))) &
         -wa1(i-1)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
         +(taui*(cc(i-1,3,:)-cc(ic-1,2,:))))
      ch(i,:,2) =  &
          wa1(i-2)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          +(taui*(cc(i-1,3,:)-cc(ic-1,2,:)))) &
          +wa1(i-1)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          -(taui*(cc(i,3,:)+cc(ic,2,:))))
      ch(i-1,:,3) =  &
          wa2(i-2)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          +(taui*(cc(i,3,:)+cc(ic,2,:)))) &
          -wa2(i-1)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          -(taui*(cc(i-1,3,:)-cc(ic-1,2,:))))
      ch(i,:,3) = &
          wa2(i-2)*((cc(i,1,:)+taur*(cc(i,3,:)-cc(ic,2,:))) &
          -(taui*(cc(i-1,3,:)-cc(ic-1,2,:)))) &
          +wa2(i-1)*((cc(i-1,1,:)+taur*(cc(i-1,3,:)+cc(ic-1,2,:))) &
          +(taui*(cc(i,3,:)+cc(ic,2,:))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!     single precision vector version
!
  subroutine svradb3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c3=3._kr
    real(kr), dimension(size(cci,1),ido,3,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,3) :: ch
    real(kr) arg,taur,taui
    integer m,n,idp2,i,ic

    arg=c2*pimach(.0_kr)/c3 
    taur=cos(arg) 
    taui=sin(arg)
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,3,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+c2*cc(:,ido,2,:)
    ch(:,1,:,2) = cc(:,1,1,:)+c2*(taur*cc(:,ido,2,:)-taui*cc(:,1,3,:))
    ch(:,1,:,3) = cc(:,1,1,:)+c2*(taur*cc(:,ido,2,:)+taui*cc(:,1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) = cc(:,i-1,1,:)+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))
      ch(:,i,:,1) = cc(:,i,1,:)+(cc(:,i,3,:)-cc(:,ic,2,:))
      ch(:,i-1,:,2) = &
         wa1(i-2)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
         -(taui*(cc(:,i,3,:)+cc(:,ic,2,:)))) &
         -wa1(i-1)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
         +(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:))))
      ch(:,i,:,2) =  &
          wa1(i-2)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          +(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))) &
          +wa1(i-1)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          -(taui*(cc(:,i,3,:)+cc(:,ic,2,:))))
      ch(:,i-1,:,3) =  &
          wa2(i-2)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          +(taui*(cc(:,i,3,:)+cc(:,ic,2,:)))) &
          -wa2(i-1)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          -(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:))))
      ch(:,i,:,3) = &
          wa2(i-2)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          -(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))) &
          +wa2(i-1)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          +(taui*(cc(:,i,3,:)+cc(:,ic,2,:))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!     double precision vector version
!
  subroutine dvradb3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c3=3._kr
    real(kr), dimension(size(cci,1),ido,3,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,3) :: ch
    real(kr) arg,taur,taui
    integer m,n,idp2,i,ic

    arg=c2*pimach(.0_kr)/c3 
    taur=cos(arg) 
    taui=sin(arg)
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,3,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+c2*cc(:,ido,2,:)
    ch(:,1,:,2) = cc(:,1,1,:)+c2*(taur*cc(:,ido,2,:)-taui*cc(:,1,3,:))
    ch(:,1,:,3) = cc(:,1,1,:)+c2*(taur*cc(:,ido,2,:)+taui*cc(:,1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) = cc(:,i-1,1,:)+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))
      ch(:,i,:,1) = cc(:,i,1,:)+(cc(:,i,3,:)-cc(:,ic,2,:))
      ch(:,i-1,:,2) = &
         wa1(i-2)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
         -(taui*(cc(:,i,3,:)+cc(:,ic,2,:)))) &
         -wa1(i-1)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
         +(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:))))
      ch(:,i,:,2) =  &
          wa1(i-2)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          +(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))) &
          +wa1(i-1)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          -(taui*(cc(:,i,3,:)+cc(:,ic,2,:))))
      ch(:,i-1,:,3) =  &
          wa2(i-2)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          +(taui*(cc(:,i,3,:)+cc(:,ic,2,:)))) &
          -wa2(i-1)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          -(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:))))
      ch(:,i,:,3) = &
          wa2(i-2)*((cc(:,i,1,:)+taur*(cc(:,i,3,:)-cc(:,ic,2,:))) &
          -(taui*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))) &
          +wa2(i-1)*((cc(:,i-1,1,:)+taur*(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          +(taui*(cc(:,i,3,:)+cc(:,ic,2,:))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix3b
