!
! fftpk, version 3, sept. 1990
!
module Radix4b
  implicit none
  private
  public radb4
  interface radb4
    module procedure sradb4,dradb4,svradb4,dvradb4
  end interface
contains
!
!   single precision scalar version
!
  subroutine sradb4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr
    real(kr), dimension(ido,4,l1) :: cc
    real(kr), dimension(ido,l1,4) :: ch
    real(kr) sqrt2
    integer n,idp2,i,ic
!
    sqrt2 = sqrt(two)
    n=size(cci)
    cc = reshape(cci,(/ido,4,l1/))
!
    ch(1,:,3) = (cc(1,1,:)+cc(ido,4,:))-(cc(ido,2,:)+cc(ido,2,:))
    ch(1,:,1) = (cc(1,1,:)+cc(ido,4,:))+(cc(ido,2,:)+cc(ido,2,:))
    ch(1,:,4) = (cc(1,1,:)-cc(ido,4,:))+(cc(1,3,:)+cc(1,3,:))
    ch(1,:,2) = (cc(1,1,:)-cc(ido,4,:))-(cc(1,3,:)+cc(1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
       ch(i-1,:,1) = &
           (cc(i-1,1,:)+cc(ic-1,4,:))+(cc(i-1,3,:)+cc(ic-1,2,:))
       ch(i,:,1) = &
           (cc(i,1,:)-cc(ic,4,:))+(cc(i,3,:)-cc(ic,2,:))
       ch(i-1,:,2) = &
           wa1(i-2)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           -(cc(i,3,:)+cc(ic,2,:)))-wa1(i-1)*((cc(i,1,:)+cc(ic,4,:)) &
           +(cc(i-1,3,:)-cc(ic-1,2,:)))
       ch(i,:,2) = &
           wa1(i-2)*((cc(i,1,:)+cc(ic,4,:)) &
           +(cc(i-1,3,:)-cc(ic-1,2,:))) &
           +wa1(i-1)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           -(cc(i,3,:)+cc(ic,2,:)))
       ch(i-1,:,3) = &
          wa2(i-2)*((cc(i-1,1,:)+cc(ic-1,4,:)) &
          -(cc(i-1,3,:)+cc(ic-1,2,:))) &
          -wa2(i-1)*((cc(i,1,:)-cc(ic,4,:))-(cc(i,3,:)-cc(ic,2,:)))
       ch(i,:,3) = &
           wa2(i-2)*((cc(i,1,:)-cc(ic,4,:))-(cc(i,3,:)-cc(ic,2,:))) &
           +wa2(i-1)*((cc(i-1,1,:)+cc(ic-1,4,:)) &
           -(cc(i-1,3,:)+cc(ic-1,2,:)))
       ch(i-1,:,4) = &
           wa3(i-2)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           +(cc(i,3,:)+cc(ic,2,:))) &
           -wa3(i-1)*((cc(i,1,:)+cc(ic,4,:)) &
           -(cc(i-1,3,:)-cc(ic-1,2,:)))
       ch(i,:,4) = &
           wa3(i-2)*((cc(i,1,:)+cc(ic,4,:)) &
           -(cc(i-1,3,:)-cc(ic-1,2,:))) &
           +wa3(i-1)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           +(cc(i,3,:)+cc(ic,2,:)))
    enddo
    if (mod(ido,2)==0) then
      ch(ido,:,1) = (cc(ido,1,:)+cc(ido,3,:)) &
                      +(cc(ido,1,:)+cc(ido,3,:))
      ch(ido,:,2) = sqrt2*((cc(ido,1,:)-cc(ido,3,:)) &
                      -(cc(1,2,:)+cc(1,4,:)))
      ch(ido,:,3) = (cc(1,4,:)-cc(1,2,:))+(cc(1,4,:)-cc(1,2,:))
      ch(ido,:,4) = -sqrt2*((cc(ido,1,:)-cc(ido,3,:)) &
                      +(cc(1,2,:)+cc(1,4,:)))
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!   double precision scalar version
!
  subroutine dradb4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr
    real(kr), dimension(ido,4,l1) :: cc
    real(kr), dimension(ido,l1,4) :: ch
    real(kr) sqrt2
    integer n,idp2,i,ic
!
    sqrt2 = sqrt(two)
    n=size(cci)
    cc = reshape(cci,(/ido,4,l1/))
!
    ch(1,:,3) = (cc(1,1,:)+cc(ido,4,:))-(cc(ido,2,:)+cc(ido,2,:))
    ch(1,:,1) = (cc(1,1,:)+cc(ido,4,:))+(cc(ido,2,:)+cc(ido,2,:))
    ch(1,:,4) = (cc(1,1,:)-cc(ido,4,:))+(cc(1,3,:)+cc(1,3,:))
    ch(1,:,2) = (cc(1,1,:)-cc(ido,4,:))-(cc(1,3,:)+cc(1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
       ch(i-1,:,1) = &
           (cc(i-1,1,:)+cc(ic-1,4,:))+(cc(i-1,3,:)+cc(ic-1,2,:))
       ch(i,:,1) = &
           (cc(i,1,:)-cc(ic,4,:))+(cc(i,3,:)-cc(ic,2,:))
       ch(i-1,:,2) = &
           wa1(i-2)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           -(cc(i,3,:)+cc(ic,2,:)))-wa1(i-1)*((cc(i,1,:)+cc(ic,4,:)) &
           +(cc(i-1,3,:)-cc(ic-1,2,:)))
       ch(i,:,2) = &
           wa1(i-2)*((cc(i,1,:)+cc(ic,4,:)) &
           +(cc(i-1,3,:)-cc(ic-1,2,:))) &
           +wa1(i-1)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           -(cc(i,3,:)+cc(ic,2,:)))
       ch(i-1,:,3) = &
          wa2(i-2)*((cc(i-1,1,:)+cc(ic-1,4,:)) &
          -(cc(i-1,3,:)+cc(ic-1,2,:))) &
          -wa2(i-1)*((cc(i,1,:)-cc(ic,4,:))-(cc(i,3,:)-cc(ic,2,:)))
       ch(i,:,3) = &
           wa2(i-2)*((cc(i,1,:)-cc(ic,4,:))-(cc(i,3,:)-cc(ic,2,:))) &
           +wa2(i-1)*((cc(i-1,1,:)+cc(ic-1,4,:)) &
           -(cc(i-1,3,:)+cc(ic-1,2,:)))
       ch(i-1,:,4) = &
           wa3(i-2)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           +(cc(i,3,:)+cc(ic,2,:))) &
           -wa3(i-1)*((cc(i,1,:)+cc(ic,4,:)) &
           -(cc(i-1,3,:)-cc(ic-1,2,:)))
       ch(i,:,4) = &
           wa3(i-2)*((cc(i,1,:)+cc(ic,4,:)) &
           -(cc(i-1,3,:)-cc(ic-1,2,:))) &
           +wa3(i-1)*((cc(i-1,1,:)-cc(ic-1,4,:)) &
           +(cc(i,3,:)+cc(ic,2,:)))
    enddo
    if (mod(ido,2)==0) then
      ch(ido,:,1) = (cc(ido,1,:)+cc(ido,3,:)) &
                      +(cc(ido,1,:)+cc(ido,3,:))
      ch(ido,:,2) = sqrt2*((cc(ido,1,:)-cc(ido,3,:)) &
                      -(cc(1,2,:)+cc(1,4,:)))
      ch(ido,:,3) = (cc(1,4,:)-cc(1,2,:))+(cc(1,4,:)-cc(1,2,:))
      ch(ido,:,4) = -sqrt2*((cc(ido,1,:)-cc(ido,3,:)) &
                      +(cc(1,2,:)+cc(1,4,:)))
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!   single precision vector version
!
  subroutine svradb4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr
    real(kr), dimension(size(cci,1),ido,4,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,4) :: ch
    real(kr) sqrt2
    integer m,n,idp2,i,ic
!
    sqrt2 = sqrt(c2)
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,4,l1/))
!
    ch(:,1,:,3) = (cc(:,1,1,:)+cc(:,ido,4,:))-(cc(:,ido,2,:)+cc(:,ido,2,:))
    ch(:,1,:,1) = (cc(:,1,1,:)+cc(:,ido,4,:))+(cc(:,ido,2,:)+cc(:,ido,2,:))
    ch(:,1,:,4) = (cc(:,1,1,:)-cc(:,ido,4,:))+(cc(:,1,3,:)+cc(:,1,3,:))
    ch(:,1,:,2) = (cc(:,1,1,:)-cc(:,ido,4,:))-(cc(:,1,3,:)+cc(:,1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
       ch(:,i-1,:,1) = &
           (cc(:,i-1,1,:)+cc(:,ic-1,4,:))+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))
       ch(:,i,:,1) = &
           (cc(:,i,1,:)-cc(:,ic,4,:))+(cc(:,i,3,:)-cc(:,ic,2,:))
       ch(:,i-1,:,2) = &
           wa1(i-2)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           -(cc(:,i,3,:)+cc(:,ic,2,:)))-wa1(i-1)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           +(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))
       ch(:,i,:,2) = &
           wa1(i-2)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           +(cc(:,i-1,3,:)-cc(:,ic-1,2,:))) &
           +wa1(i-1)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           -(cc(:,i,3,:)+cc(:,ic,2,:)))
       ch(:,i-1,:,3) = &
          wa2(i-2)*((cc(:,i-1,1,:)+cc(:,ic-1,4,:)) &
          -(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          -wa2(i-1)*((cc(:,i,1,:)-cc(:,ic,4,:))-(cc(:,i,3,:)-cc(:,ic,2,:)))
       ch(:,i,:,3) = &
           wa2(i-2)*((cc(:,i,1,:)-cc(:,ic,4,:))-(cc(:,i,3,:)-cc(:,ic,2,:))) &
           +wa2(i-1)*((cc(:,i-1,1,:)+cc(:,ic-1,4,:)) &
           -(cc(:,i-1,3,:)+cc(:,ic-1,2,:)))
       ch(:,i-1,:,4) = &
           wa3(i-2)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           +(cc(:,i,3,:)+cc(:,ic,2,:))) &
           -wa3(i-1)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           -(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))
       ch(:,i,:,4) = &
           wa3(i-2)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           -(cc(:,i-1,3,:)-cc(:,ic-1,2,:))) &
           +wa3(i-1)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           +(cc(:,i,3,:)+cc(:,ic,2,:)))
    enddo
    if (mod(ido,2)==0) then
      ch(:,ido,:,1) = (cc(:,ido,1,:)+cc(:,ido,3,:)) &
                      +(cc(:,ido,1,:)+cc(:,ido,3,:))
      ch(:,ido,:,2) = sqrt2*((cc(:,ido,1,:)-cc(:,ido,3,:)) &
                      -(cc(:,1,2,:)+cc(:,1,4,:)))
      ch(:,ido,:,3) = (cc(:,1,4,:)-cc(:,1,2,:))+(cc(:,1,4,:)-cc(:,1,2,:))
      ch(:,ido,:,4) = -sqrt2*((cc(:,ido,1,:)-cc(:,ido,3,:)) &
                      +(cc(:,1,2,:)+cc(:,1,4,:)))
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!   double precision vector version
!
  subroutine dvradb4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr
    real(kr), dimension(size(cci,1),ido,4,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,4) :: ch
    real(kr) sqrt2
    integer m,n,idp2,i,ic
!
    sqrt2 = sqrt(c2)
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,4,l1/))
!
    ch(:,1,:,3) = (cc(:,1,1,:)+cc(:,ido,4,:))-(cc(:,ido,2,:)+cc(:,ido,2,:))
    ch(:,1,:,1) = (cc(:,1,1,:)+cc(:,ido,4,:))+(cc(:,ido,2,:)+cc(:,ido,2,:))
    ch(:,1,:,4) = (cc(:,1,1,:)-cc(:,ido,4,:))+(cc(:,1,3,:)+cc(:,1,3,:))
    ch(:,1,:,2) = (cc(:,1,1,:)-cc(:,ido,4,:))-(cc(:,1,3,:)+cc(:,1,3,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
       ch(:,i-1,:,1) = &
           (cc(:,i-1,1,:)+cc(:,ic-1,4,:))+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))
       ch(:,i,:,1) = &
           (cc(:,i,1,:)-cc(:,ic,4,:))+(cc(:,i,3,:)-cc(:,ic,2,:))
       ch(:,i-1,:,2) = &
           wa1(i-2)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           -(cc(:,i,3,:)+cc(:,ic,2,:)))-wa1(i-1)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           +(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))
       ch(:,i,:,2) = &
           wa1(i-2)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           +(cc(:,i-1,3,:)-cc(:,ic-1,2,:))) &
           +wa1(i-1)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           -(cc(:,i,3,:)+cc(:,ic,2,:)))
       ch(:,i-1,:,3) = &
          wa2(i-2)*((cc(:,i-1,1,:)+cc(:,ic-1,4,:)) &
          -(cc(:,i-1,3,:)+cc(:,ic-1,2,:))) &
          -wa2(i-1)*((cc(:,i,1,:)-cc(:,ic,4,:))-(cc(:,i,3,:)-cc(:,ic,2,:)))
       ch(:,i,:,3) = &
           wa2(i-2)*((cc(:,i,1,:)-cc(:,ic,4,:))-(cc(:,i,3,:)-cc(:,ic,2,:))) &
           +wa2(i-1)*((cc(:,i-1,1,:)+cc(:,ic-1,4,:)) &
           -(cc(:,i-1,3,:)+cc(:,ic-1,2,:)))
       ch(:,i-1,:,4) = &
           wa3(i-2)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           +(cc(:,i,3,:)+cc(:,ic,2,:))) &
           -wa3(i-1)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           -(cc(:,i-1,3,:)-cc(:,ic-1,2,:)))
       ch(:,i,:,4) = &
           wa3(i-2)*((cc(:,i,1,:)+cc(:,ic,4,:)) &
           -(cc(:,i-1,3,:)-cc(:,ic-1,2,:))) &
           +wa3(i-1)*((cc(:,i-1,1,:)-cc(:,ic-1,4,:)) &
           +(cc(:,i,3,:)+cc(:,ic,2,:)))
    enddo
    if (mod(ido,2)==0) then
      ch(:,ido,:,1) = (cc(:,ido,1,:)+cc(:,ido,3,:)) &
                      +(cc(:,ido,1,:)+cc(:,ido,3,:))
      ch(:,ido,:,2) = sqrt2*((cc(:,ido,1,:)-cc(:,ido,3,:)) &
                      -(cc(:,1,2,:)+cc(:,1,4,:)))
      ch(:,ido,:,3) = (cc(:,1,4,:)-cc(:,1,2,:))+(cc(:,1,4,:)-cc(:,1,2,:))
      ch(:,ido,:,4) = -sqrt2*((cc(:,ido,1,:)-cc(:,ido,3,:)) &
                      +(cc(:,1,2,:)+cc(:,1,4,:)))
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix4b
