!
! fftpk, version 3, sept. 1990
!
 module Radix5b
 use PiMachine
  implicit none
  private
  public radb5
  interface radb5
    module procedure sradb5,dradb5,svradb5,dvradb5
  end interface
contains
!
!   single precision scalar version
!
  subroutine sradb5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,five=5._kr
    real(kr), dimension(ido,5,l1) :: cc
    real(kr), dimension(ido,l1,5) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer :: n,idp2,i,ic
 
    n=size(cci)
    arg=two*pimach(.0_kr)/five
    darg=two*arg
    tr11=cos(arg)
    ti11=sin(arg)
    tr12=cos(darg)
    ti12=sin(darg)
!
    cc = reshape(cci,(/ido,5,l1/))
    ch(1,:,1) = cc(1,1,:)+two*(cc(ido,2,:)+cc(ido,4,:))
    ch(1,:,2) = cc(1,1,:)+two*(tr11*cc(ido,2,:)+tr12*cc(ido,4,:) &
                  -ti11*cc(1,3,:)-ti12*cc(1,5,:))
    ch(1,:,3) = cc(1,1,:)+two*(tr12*cc(ido,2,:)+tr11*cc(ido,4,:) &
                  -ti12*cc(1,3,:)+ti11*cc(1,5,:))
    ch(1,:,4) = cc(1,1,:)+two*(tr12*cc(ido,2,:)+tr11*cc(ido,4,:) &
                  +ti12*cc(1,3,:)-ti11*cc(1,5,:))
    ch(1,:,5) = cc(1,1,:)+two*(tr11*cc(ido,2,:)+tr12*cc(ido,4,:) &
                  +ti11*cc(1,3,:)+ti12*cc(1,5,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) =  &
          cc(i-1,1,:)+(cc(i-1,3,:)+cc(ic-1,2,:))+(cc(i-1,5,:) &
          +cc(ic-1,4,:))
      ch(i,:,1) =  &
          cc(i,1,:)+(cc(i,3,:)-cc(ic,2,:))+(cc(i,5,:)-cc(ic,4,:))
      ch(i-1,:,2) =  &
          wa1(i-2)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa1(i-1)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,2) =  &
          wa1(i-2)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa1(i-1)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti11*(cc(i,3,:)+cc(ic,2,:)) &
          +ti12*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,3) =  &
          wa2(i-2)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti12*(cc(i,3,:)+cc(ic,2,:)) &
          -ti11*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa2(i-1)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,3) =  &
         wa2(i-2)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) & 
         +tr11*(cc(i,5,:)-cc(ic,4,:))) &
         +(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
         -ti11*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
         +wa2(i-1)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
         +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
         -(ti12*(cc(i,3,:)+cc(ic,2,:)) &
         -ti11*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,4) =  &
          wa3(i-2)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti12*(cc(i,3,:)+cc(ic,2,:)) &
          -ti11*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa3(i-1)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,4) =  &
          wa3(i-2)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa3(i-1)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti12*(cc(i,3,:)+cc(ic,2,:))-ti11*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,5) =  &
          wa4(i-2)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa4(i-1)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,5) =  &
          wa4(i-2)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa4(i-1)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!   double precision vector version
!
  subroutine dradb5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,five=5._kr
    real(kr), dimension(ido,5,l1) :: cc
    real(kr), dimension(ido,l1,5) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer :: n,idp2,i,ic
 
    n=size(cci)
    arg=two*pimach(.0_kr)/five
    darg=two*arg
    tr11=cos(arg)
    ti11=sin(arg)
    tr12=cos(darg)
    ti12=sin(darg)
!
    cc = reshape(cci,(/ido,5,l1/))
    ch(1,:,1) = cc(1,1,:)+two*(cc(ido,2,:)+cc(ido,4,:))
    ch(1,:,2) = cc(1,1,:)+two*(tr11*cc(ido,2,:)+tr12*cc(ido,4,:) &
                  -ti11*cc(1,3,:)-ti12*cc(1,5,:))
    ch(1,:,3) = cc(1,1,:)+two*(tr12*cc(ido,2,:)+tr11*cc(ido,4,:) &
                  -ti12*cc(1,3,:)+ti11*cc(1,5,:))
    ch(1,:,4) = cc(1,1,:)+two*(tr12*cc(ido,2,:)+tr11*cc(ido,4,:) &
                  +ti12*cc(1,3,:)-ti11*cc(1,5,:))
    ch(1,:,5) = cc(1,1,:)+two*(tr11*cc(ido,2,:)+tr12*cc(ido,4,:) &
                  +ti11*cc(1,3,:)+ti12*cc(1,5,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,:,1) =  &
          cc(i-1,1,:)+(cc(i-1,3,:)+cc(ic-1,2,:))+(cc(i-1,5,:) &
          +cc(ic-1,4,:))
      ch(i,:,1) =  &
          cc(i,1,:)+(cc(i,3,:)-cc(ic,2,:))+(cc(i,5,:)-cc(ic,4,:))
      ch(i-1,:,2) =  &
          wa1(i-2)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa1(i-1)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,2) =  &
          wa1(i-2)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa1(i-1)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti11*(cc(i,3,:)+cc(ic,2,:)) &
          +ti12*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,3) =  &
          wa2(i-2)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          -(ti12*(cc(i,3,:)+cc(ic,2,:)) &
          -ti11*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa2(i-1)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          +(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,3) =  &
         wa2(i-2)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) & 
         +tr11*(cc(i,5,:)-cc(ic,4,:))) &
         +(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
         -ti11*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
         +wa2(i-1)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
         +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
         -(ti12*(cc(i,3,:)+cc(ic,2,:)) &
         -ti11*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,4) =  &
          wa3(i-2)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti12*(cc(i,3,:)+cc(ic,2,:)) &
          -ti11*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa3(i-1)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,4) =  &
          wa3(i-2)*((cc(i,1,:)+tr12*(cc(i,3,:)-cc(ic,2,:)) &
          +tr11*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti12*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          -ti11*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa3(i-1)*((cc(i-1,1,:)+tr12*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr11*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti12*(cc(i,3,:)+cc(ic,2,:))-ti11*(cc(i,5,:)+cc(ic,4,:))))
      ch(i-1,:,5) =  &
          wa4(i-2)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:)))) &
          -wa4(i-1)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:))))
      ch(i,:,5) =  &
          wa4(i-2)*((cc(i,1,:)+tr11*(cc(i,3,:)-cc(ic,2,:)) &
          +tr12*(cc(i,5,:)-cc(ic,4,:))) &
          -(ti11*(cc(i-1,3,:)-cc(ic-1,2,:)) &
          +ti12*(cc(i-1,5,:)-cc(ic-1,4,:)))) &
          +wa4(i-1)*((cc(i-1,1,:)+tr11*(cc(i-1,3,:)+cc(ic-1,2,:)) &
          +tr12*(cc(i-1,5,:)+cc(ic-1,4,:))) &
          +(ti11*(cc(i,3,:)+cc(ic,2,:))+ti12*(cc(i,5,:)+cc(ic,4,:))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!   single precision vector version
!
  subroutine svradb5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c5=5._kr
    real(kr), dimension(size(cci,1),ido,5,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,5) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer :: m,n,idp2,i,ic
 
    m = size(cci,1) 
    n=size(cci,2)
    arg=c2*pimach(.0_kr)/c5 
    darg=c2*arg
    tr11=cos(arg) 
    ti11=sin(arg) 
    tr12=cos(darg) 
    ti12=sin(darg)
!
    cc = reshape(cci,(/m,ido,5,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+c2*(cc(:,ido,2,:)+cc(:,ido,4,:))
    ch(:,1,:,2) = cc(:,1,1,:)+c2*(tr11*cc(:,ido,2,:)+tr12*cc(:,ido,4,:) &
                  -ti11*cc(:,1,3,:)-ti12*cc(:,1,5,:))
    ch(:,1,:,3) = cc(:,1,1,:)+c2*(tr12*cc(:,ido,2,:)+tr11*cc(:,ido,4,:) &
                  -ti12*cc(:,1,3,:)+ti11*cc(:,1,5,:))
    ch(:,1,:,4) = cc(:,1,1,:)+c2*(tr12*cc(:,ido,2,:)+tr11*cc(:,ido,4,:) &
                  +ti12*cc(:,1,3,:)-ti11*cc(:,1,5,:))
    ch(:,1,:,5) = cc(:,1,1,:)+c2*(tr11*cc(:,ido,2,:)+tr12*cc(:,ido,4,:) &
                  +ti11*cc(:,1,3,:)+ti12*cc(:,1,5,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) =  &
          cc(:,i-1,1,:)+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))+(cc(:,i-1,5,:) &
          +cc(:,ic-1,4,:))
      ch(:,i,:,1) =  &
          cc(:,i,1,:)+(cc(:,i,3,:)-cc(:,ic,2,:))+(cc(:,i,5,:)-cc(:,ic,4,:))
      ch(:,i-1,:,2) =  &
          wa1(i-2)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa1(i-1)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,2) =  &
          wa1(i-2)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa1(i-1)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti11*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          +ti12*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,3) =  &
          wa2(i-2)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          -ti11*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa2(i-1)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,3) =  &
         wa2(i-2)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) & 
         +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
         +(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
         -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
         +wa2(i-1)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
         +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
         -(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
         -ti11*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,4) =  &
          wa3(i-2)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          -ti11*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa3(i-1)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,4) =  &
          wa3(i-2)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa3(i-1)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti12*(cc(:,i,3,:)+cc(:,ic,2,:))-ti11*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,5) =  &
          wa4(i-2)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa4(i-1)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,5) =  &
          wa4(i-2)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa4(i-1)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!   double precision vector version
!
  subroutine dvradb5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(out) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c5=5._kr
    real(kr), dimension(size(cci,1),ido,5,l1) :: cc
    real(kr), dimension(size(cci,1),ido,l1,5) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer :: m,n,idp2,i,ic
 
    m = size(cci,1) 
    n=size(cci,2)
    arg=c2*pimach(.0_kr)/c5 
    darg=c2*arg
    tr11=cos(arg) 
    ti11=sin(arg) 
    tr12=cos(darg) 
    ti12=sin(darg)
!
    cc = reshape(cci,(/m,ido,5,l1/))
    ch(:,1,:,1) = cc(:,1,1,:)+c2*(cc(:,ido,2,:)+cc(:,ido,4,:))
    ch(:,1,:,2) = cc(:,1,1,:)+c2*(tr11*cc(:,ido,2,:)+tr12*cc(:,ido,4,:) &
                  -ti11*cc(:,1,3,:)-ti12*cc(:,1,5,:))
    ch(:,1,:,3) = cc(:,1,1,:)+c2*(tr12*cc(:,ido,2,:)+tr11*cc(:,ido,4,:) &
                  -ti12*cc(:,1,3,:)+ti11*cc(:,1,5,:))
    ch(:,1,:,4) = cc(:,1,1,:)+c2*(tr12*cc(:,ido,2,:)+tr11*cc(:,ido,4,:) &
                  +ti12*cc(:,1,3,:)-ti11*cc(:,1,5,:))
    ch(:,1,:,5) = cc(:,1,1,:)+c2*(tr11*cc(:,ido,2,:)+tr12*cc(:,ido,4,:) &
                  +ti11*cc(:,1,3,:)+ti12*cc(:,1,5,:))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,:,1) =  &
          cc(:,i-1,1,:)+(cc(:,i-1,3,:)+cc(:,ic-1,2,:))+(cc(:,i-1,5,:) &
          +cc(:,ic-1,4,:))
      ch(:,i,:,1) =  &
          cc(:,i,1,:)+(cc(:,i,3,:)-cc(:,ic,2,:))+(cc(:,i,5,:)-cc(:,ic,4,:))
      ch(:,i-1,:,2) =  &
          wa1(i-2)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa1(i-1)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,2) =  &
          wa1(i-2)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa1(i-1)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti11*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          +ti12*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,3) =  &
          wa2(i-2)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          -(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          -ti11*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa2(i-1)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          +(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,3) =  &
         wa2(i-2)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) & 
         +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
         +(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
         -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
         +wa2(i-1)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
         +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
         -(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
         -ti11*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,4) =  &
          wa3(i-2)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti12*(cc(:,i,3,:)+cc(:,ic,2,:)) &
          -ti11*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa3(i-1)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,4) =  &
          wa3(i-2)*((cc(:,i,1,:)+tr12*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr11*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti12*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          -ti11*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa3(i-1)*((cc(:,i-1,1,:)+tr12*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr11*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti12*(cc(:,i,3,:)+cc(:,ic,2,:))-ti11*(cc(:,i,5,:)+cc(:,ic,4,:))))
      ch(:,i-1,:,5) =  &
          wa4(i-2)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:)))) &
          -wa4(i-1)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:))))
      ch(:,i,:,5) =  &
          wa4(i-2)*((cc(:,i,1,:)+tr11*(cc(:,i,3,:)-cc(:,ic,2,:)) &
          +tr12*(cc(:,i,5,:)-cc(:,ic,4,:))) &
          -(ti11*(cc(:,i-1,3,:)-cc(:,ic-1,2,:)) &
          +ti12*(cc(:,i-1,5,:)-cc(:,ic-1,4,:)))) &
          +wa4(i-1)*((cc(:,i-1,1,:)+tr11*(cc(:,i-1,3,:)+cc(:,ic-1,2,:)) &
          +tr12*(cc(:,i-1,5,:)+cc(:,ic-1,4,:))) &
          +(ti11*(cc(:,i,3,:)+cc(:,ic,2,:))+ti12*(cc(:,i,5,:)+cc(:,ic,4,:))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix5b
