!
!     fftpk, version 3, sept. 2000
!
module Radixgb
  use PiMachine
  implicit none
  private
  public radbg
  interface radbg
    module procedure sradbg,dradbg,svradbg,dvradbg
  end interface
contains
!
!  single precision scalar version
!
  subroutine sradbg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: zero=.0_kr,one=1._kr,two=2.0_kr
    real(kr), dimension(ido,l1,ip) :: ch,c1
    real(kr), dimension(ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc

    n = size(cci)
    ch = reshape(chi,(/ido,l1,ip/))
    cc = reshape(cci,(/ido,ip,l1/))

    arg = two*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    idp2 = ido+2
    nbd = (ido-1)/2
    ipp2 = ip+2
    ipph = (ip+1)/2
!
    ch(:,:,1) = cc(:,1,:)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      ch(1,:,j) = cc(ido,j2-2,:)+cc(ido,j2-2,:)
      ch(1,:,jc) = cc(1,j2-1,:)+cc(1,j2-1,:)
    enddo
    if (ido >= 3) then
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          ic = idp2-i
          ch(i-1,:,j) = cc(i-1,2*j-1,:)+cc(ic-1,2*j-2,:)
          ch(i-1,:,jc) = cc(i-1,2*j-1,:)-cc(ic-1,2*j-2,:)
          ch(i,:,j) = cc(i,2*j-1,:)-cc(ic,2*j-2,:)
          ch(i,:,jc) = cc(i,2*j-1,:)+cc(ic,2*j-2,:)
        enddo
      enddo
    endif
!
    c1 = reshape(cc,(/ido,l1,ip/))
    ar1 = one
    ai1 = zero
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      c1(:,:,l) = ch(:,:,1)+ar1*ch(:,:,2)
      c1(:,:,lc) = ai1*ch(:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        c1(:,:,l) = c1(:,:,l)+ar2*ch(:,:,j)
        c1(:,:,lc) = c1(:,:,lc)+ai2*ch(:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,1) = ch(:,:,1)+ch(:,:,j)
    enddo
    do j=2,ipph
      jc = ipp2-j
      ch(1,:,j) = c1(1,:,j)-c1(1,:,jc)
      ch(1,:,jc) = c1(1,:,j)+c1(1,:,jc)
    enddo
!
    if (ido /= 1) then
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          ch(i-1,:,j) = c1(i-1,:,j)-c1(i,:,jc)
          ch(i-1,:,jc) = c1(i-1,:,j)+c1(i,:,jc)
          ch(i,:,j) = c1(i,:,j)+c1(i-1,:,jc)
          ch(i,:,jc) = c1(i,:,j)-c1(i-1,:,jc)
        enddo
      enddo
      c1(:,:,1) = ch(:,:,1)
      do j=2,ip
        c1(1,:,j) = ch(1,:,j)
      enddo
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          c1(i-1,:,j) = wa(idij-1)*ch(i-1,:,j)-wa(idij)*ch(i,:,j)
          c1(i,:,j) = wa(idij-1)*ch(i,:,j)+wa(idij)*ch(i-1,:,j)
        enddo
      enddo
    endif
    cci = reshape(c1,(/n/))
    chi = reshape(ch,(/n/))
  end subroutine
!
!  double precision scalar version
!
  subroutine dradbg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: zero=.0_kr,one=1._kr,two=2.0_kr
    real(kr), dimension(ido,l1,ip) :: ch,c1
    real(kr), dimension(ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc

    n = size(cci)
    ch = reshape(chi,(/ido,l1,ip/))
    cc = reshape(cci,(/ido,ip,l1/))

    arg = two*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    idp2 = ido+2
    nbd = (ido-1)/2
    ipp2 = ip+2
    ipph = (ip+1)/2
!
    ch(:,:,1) = cc(:,1,:)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      ch(1,:,j) = cc(ido,j2-2,:)+cc(ido,j2-2,:)
      ch(1,:,jc) = cc(1,j2-1,:)+cc(1,j2-1,:)
    enddo
    if (ido >= 3) then
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          ic = idp2-i
          ch(i-1,:,j) = cc(i-1,2*j-1,:)+cc(ic-1,2*j-2,:)
          ch(i-1,:,jc) = cc(i-1,2*j-1,:)-cc(ic-1,2*j-2,:)
          ch(i,:,j) = cc(i,2*j-1,:)-cc(ic,2*j-2,:)
          ch(i,:,jc) = cc(i,2*j-1,:)+cc(ic,2*j-2,:)
        enddo
      enddo
    endif
!
    c1 = reshape(cc,(/ido,l1,ip/))
    ar1 = one
    ai1 = zero
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      c1(:,:,l) = ch(:,:,1)+ar1*ch(:,:,2)
      c1(:,:,lc) = ai1*ch(:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        c1(:,:,l) = c1(:,:,l)+ar2*ch(:,:,j)
        c1(:,:,lc) = c1(:,:,lc)+ai2*ch(:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,1) = ch(:,:,1)+ch(:,:,j)
    enddo
    do j=2,ipph
      jc = ipp2-j
      ch(1,:,j) = c1(1,:,j)-c1(1,:,jc)
      ch(1,:,jc) = c1(1,:,j)+c1(1,:,jc)
    enddo
!
    if (ido /= 1) then
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          ch(i-1,:,j) = c1(i-1,:,j)-c1(i,:,jc)
          ch(i-1,:,jc) = c1(i-1,:,j)+c1(i,:,jc)
          ch(i,:,j) = c1(i,:,j)+c1(i-1,:,jc)
          ch(i,:,jc) = c1(i,:,j)-c1(i-1,:,jc)
        enddo
      enddo
      c1(:,:,1) = ch(:,:,1)
      do j=2,ip
        c1(1,:,j) = ch(1,:,j)
      enddo
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          c1(i-1,:,j) = wa(idij-1)*ch(i-1,:,j)-wa(idij)*ch(i,:,j)
          c1(i,:,j) = wa(idij-1)*ch(i,:,j)+wa(idij)*ch(i-1,:,j)
        enddo
      enddo
    endif
    cci = reshape(c1,(/n/))
    chi = reshape(ch,(/n/))
  end subroutine
!
!  single precision vector version
!
  subroutine svradbg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:,:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: c2=2.0_kr
    real(kr), dimension(size(cci,1),ido,l1,ip) :: ch,c1
    real(kr), dimension(size(cci,1),ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer m,n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc

    m = size(cci,1)
    n = size(cci,2)
    ch = reshape(chi,(/m,ido,l1,ip/))
    cc = reshape(cci,(/m,ido,ip,l1/))

    arg = c2*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    idp2 = ido+2
    nbd = (ido-1)/2
    ipp2 = ip+2
    ipph = (ip+1)/2
!
    ch(:,:,:,1) = cc(:,:,1,:)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      ch(:,1,:,j) = cc(:,ido,j2-2,:)+cc(:,ido,j2-2,:)
      ch(:,1,:,jc) = cc(:,1,j2-1,:)+cc(:,1,j2-1,:)
    enddo
    if (ido==1) go to 116
    do j=2,ipph
      jc = ipp2-j
      do i=3,ido,2
        ic = idp2-i
        ch(:,i-1,:,j) = cc(:,i-1,2*j-1,:)+cc(:,ic-1,2*j-2,:)
        ch(:,i-1,:,jc) = cc(:,i-1,2*j-1,:)-cc(:,ic-1,2*j-2,:)
        ch(:,i,:,j) = cc(:,i,2*j-1,:)-cc(:,ic,2*j-2,:)
        ch(:,i,:,jc) = cc(:,i,2*j-1,:)+cc(:,ic,2*j-2,:)
      enddo
    enddo
!
116 c1 = reshape(cc,(/m,ido,l1,ip/))
    ar1 = 1.
    ai1 = 0.
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      c1(:,:,:,l) = ch(:,:,:,1)+ar1*ch(:,:,:,2)
      c1(:,:,:,lc) = ai1*ch(:,:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        c1(:,:,:,l) = c1(:,:,:,l)+ar2*ch(:,:,:,j)
        c1(:,:,:,lc) = c1(:,:,:,lc)+ai2*ch(:,:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,:,1) = ch(:,:,:,1)+ch(:,:,:,j)
    enddo
    do j=2,ipph
      jc = ipp2-j
      ch(:,1,:,j) = c1(:,1,:,j)-c1(:,1,:,jc)
      ch(:,1,:,jc) = c1(:,1,:,j)+c1(:,1,:,jc)
    enddo
!
    if (ido==1) goto 100
    do j=2,ipph
      jc = ipp2-j
      do i=3,ido,2
        ch(:,i-1,:,j) = c1(:,i-1,:,j)-c1(:,i,:,jc)
        ch(:,i-1,:,jc) = c1(:,i-1,:,j)+c1(:,i,:,jc)
        ch(:,i,:,j) = c1(:,i,:,j)+c1(:,i-1,:,jc)
        ch(:,i,:,jc) = c1(:,i,:,j)-c1(:,i-1,:,jc)
      enddo
    enddo
    c1(:,:,:,1) = ch(:,:,:,1)
    do j=2,ip
      c1(:,1,:,j) = ch(:,1,:,j)
    enddo
    is = -ido
    do j=2,ip
      is = is+ido
      idij = is
      do i=3,ido,2
        idij = idij+2
        c1(:,i-1,:,j) = wa(idij-1)*ch(:,i-1,:,j)-wa(idij)*ch(:,i,:,j)
        c1(:,i,:,j) = wa(idij-1)*ch(:,i,:,j)+wa(idij)*ch(:,i-1,:,j)
      enddo
    enddo
100 cci = reshape(c1,(/m,n/))
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!  double precision version
!
  subroutine dvradbg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:,:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: c2=2.0_kr
    real(kr), dimension(size(cci,1),ido,l1,ip) :: ch,c1
    real(kr), dimension(size(cci,1),ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer m,n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc

    m = size(cci,1)
    n = size(cci,2)
    ch = reshape(chi,(/m,ido,l1,ip/))
    cc = reshape(cci,(/m,ido,ip,l1/))

    arg = c2*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    idp2 = ido+2
    nbd = (ido-1)/2
    ipp2 = ip+2
    ipph = (ip+1)/2
!
    ch(:,:,:,1) = cc(:,:,1,:)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      ch(:,1,:,j) = cc(:,ido,j2-2,:)+cc(:,ido,j2-2,:)
      ch(:,1,:,jc) = cc(:,1,j2-1,:)+cc(:,1,j2-1,:)
    enddo
    if (ido==1) go to 116
    do j=2,ipph
      jc = ipp2-j
      do i=3,ido,2
        ic = idp2-i
        ch(:,i-1,:,j) = cc(:,i-1,2*j-1,:)+cc(:,ic-1,2*j-2,:)
        ch(:,i-1,:,jc) = cc(:,i-1,2*j-1,:)-cc(:,ic-1,2*j-2,:)
        ch(:,i,:,j) = cc(:,i,2*j-1,:)-cc(:,ic,2*j-2,:)
        ch(:,i,:,jc) = cc(:,i,2*j-1,:)+cc(:,ic,2*j-2,:)
      enddo
    enddo
!
116 c1 = reshape(cc,(/m,ido,l1,ip/))
    ar1 = 1.
    ai1 = 0.
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      c1(:,:,:,l) = ch(:,:,:,1)+ar1*ch(:,:,:,2)
      c1(:,:,:,lc) = ai1*ch(:,:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        c1(:,:,:,l) = c1(:,:,:,l)+ar2*ch(:,:,:,j)
        c1(:,:,:,lc) = c1(:,:,:,lc)+ai2*ch(:,:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,:,1) = ch(:,:,:,1)+ch(:,:,:,j)
    enddo
    do j=2,ipph
      jc = ipp2-j
      ch(:,1,:,j) = c1(:,1,:,j)-c1(:,1,:,jc)
      ch(:,1,:,jc) = c1(:,1,:,j)+c1(:,1,:,jc)
    enddo
!
    if (ido==1) goto 100
    do j=2,ipph
      jc = ipp2-j
      do i=3,ido,2
        ch(:,i-1,:,j) = c1(:,i-1,:,j)-c1(:,i,:,jc)
        ch(:,i-1,:,jc) = c1(:,i-1,:,j)+c1(:,i,:,jc)
        ch(:,i,:,j) = c1(:,i,:,j)+c1(:,i-1,:,jc)
        ch(:,i,:,jc) = c1(:,i,:,j)-c1(:,i-1,:,jc)
      enddo
    enddo
    c1(:,:,:,1) = ch(:,:,:,1)
    do j=2,ip
      c1(:,1,:,j) = ch(:,1,:,j)
    enddo
    is = -ido
    do j=2,ip
      is = is+ido
      idij = is
      do i=3,ido,2
        idij = idij+2
        c1(:,i-1,:,j) = wa(idij-1)*ch(:,i-1,:,j)-wa(idij)*ch(:,i,:,j)
        c1(:,i,:,j) = wa(idij-1)*ch(:,i,:,j)+wa(idij)*ch(:,i-1,:,j)
      enddo
    enddo
100 cci = reshape(c1,(/m,n/))
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radixgb
