!
!     fftpk, version 3, sept. 2000
!
module Radix2f
  implicit none
  private
  public radf2
  interface radf2
    module procedure sradf2,dradf2,svradf2,dvradf2
  end interface
contains
!
!     single precision scalar version
!
  subroutine sradf2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(ido,2,l1) :: ch
    real(kr), dimension(ido,l1,2) :: cc
    integer n,idp2,i,ic
!
    n=size(cci)
    cc = reshape(cci,(/ido,l1,2/))
!
    ch(1,1,:) = cc(1,:,1)+cc(1,:,2)
    ch(ido,2,:) = cc(1,:,1)-cc(1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i,1,:) = cc(i,:,1)+(wa1(i-2)*cc(i,:,2) &
                     -wa1(i-1)*cc(i-1,:,2))
      ch(ic,2,:) = (wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
                       -cc(i,:,1)
      ch(i-1,1,:) = cc(i-1,:,1)+(wa1(i-2)*cc(i-1,:,2) &
                       +wa1(i-1)*cc(i,:,2))
      ch(ic-1,2,:) = cc(i-1,:,1)-(wa1(i-2)*cc(i-1,:,2) &
                       +wa1(i-1)*cc(i,:,2))
    enddo
    if (mod(ido,2)/=1) then
      ch(1,2,:) = -cc(ido,:,2)
      ch(ido,1,:) = cc(ido,:,1)
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!     double precision scalar version
!
  subroutine dradf2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(ido,2,l1) :: ch
    real(kr), dimension(ido,l1,2) :: cc
    integer n,idp2,i,ic
!
    n=size(cci)
    cc = reshape(cci,(/ido,l1,2/))
!
    ch(1,1,:) = cc(1,:,1)+cc(1,:,2)
    ch(ido,2,:) = cc(1,:,1)-cc(1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i,1,:) = cc(i,:,1)+(wa1(i-2)*cc(i,:,2) &
                     -wa1(i-1)*cc(i-1,:,2))
      ch(ic,2,:) = (wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
                       -cc(i,:,1)
      ch(i-1,1,:) = cc(i-1,:,1)+(wa1(i-2)*cc(i-1,:,2) &
                       +wa1(i-1)*cc(i,:,2))
      ch(ic-1,2,:) = cc(i-1,:,1)-(wa1(i-2)*cc(i-1,:,2) &
                       +wa1(i-1)*cc(i,:,2))
    enddo
    if (mod(ido,2)/=1) then
      ch(1,2,:) = -cc(ido,:,2)
      ch(ido,1,:) = cc(ido,:,1)
    endif
    chi = reshape(ch,(/n/))
  end subroutine
!
!     single precision vector version
!
  subroutine svradf2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(size(cci,1),ido,2,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,2) :: cc
    integer m,n,idp2,i,ic
!
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,l1,2/))
!
    ch(:,1,1,:) = cc(:,1,:,1)+cc(:,1,:,2)
    ch(:,ido,2,:) = cc(:,1,:,1)-cc(:,1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i,1,:) = cc(:,i,:,1)+(wa1(i-2)*cc(:,i,:,2) &
                     -wa1(i-1)*cc(:,i-1,:,2))
      ch(:,ic,2,:) = (wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
                       -cc(:,i,:,1)
      ch(:,i-1,1,:) = cc(:,i-1,:,1)+(wa1(i-2)*cc(:,i-1,:,2) &
                       +wa1(i-1)*cc(:,i,:,2))
      ch(:,ic-1,2,:) = cc(:,i-1,:,1)-(wa1(i-2)*cc(:,i-1,:,2) &
                       +wa1(i-1)*cc(:,i,:,2))
    enddo
    if (mod(ido,2)/=1) then
      ch(:,1,2,:) = -cc(:,ido,:,2)
      ch(:,ido,1,:) = cc(:,ido,:,1)
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!     double precision vector version
!
  subroutine dvradf2 (ido,l1,cci,chi,wa1)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1
    integer, intent(in) :: ido,l1
!
    real(kr), dimension(size(cci,1),ido,2,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,2) :: cc
    integer m,n,idp2,i,ic
!
    m=size(cci,1) 
    n=size(cci,2)
    cc = reshape(cci,(/m,ido,l1,2/))
!
    ch(:,1,1,:) = cc(:,1,:,1)+cc(:,1,:,2)
    ch(:,ido,2,:) = cc(:,1,:,1)-cc(:,1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i,1,:) = cc(:,i,:,1)+(wa1(i-2)*cc(:,i,:,2) &
                     -wa1(i-1)*cc(:,i-1,:,2))
      ch(:,ic,2,:) = (wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
                       -cc(:,i,:,1)
      ch(:,i-1,1,:) = cc(:,i-1,:,1)+(wa1(i-2)*cc(:,i-1,:,2) &
                       +wa1(i-1)*cc(:,i,:,2))
      ch(:,ic-1,2,:) = cc(:,i-1,:,1)-(wa1(i-2)*cc(:,i-1,:,2) &
                       +wa1(i-1)*cc(:,i,:,2))
    enddo
    if (mod(ido,2)/=1) then
      ch(:,1,2,:) = -cc(:,ido,:,2)
      ch(:,ido,1,:) = cc(:,ido,:,1)
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix2f
