!
!     fftpk, version 3, sept. 2000
!
module Radix3f
  use PiMachine
  implicit none
  private
  public radf3
  interface radf3
    module procedure sradf3,dradf3,svradf3,dvradf3
  end interface
contains
!
!     single precision scalar version
!
  subroutine sradf3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(0.)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,three=3._kr
    real(kr), dimension(ido,3,l1) :: ch
    real(kr), dimension(ido,l1,3) :: cc
    integer n,idp2,i,ic
    real(kr) arg,taur,taui

    n = size(cci)
    arg=two*pimach(.0_kr)/three
    taur=cos(arg) 
    taui=sin(arg)
!
    cc = reshape(cci,(/ido,l1,3/))
    ch(1,1,:) = cc(1,:,1)+(cc(1,:,2)+cc(1,:,3))
    ch(1,3,:) = taui*(cc(1,:,3)-cc(1,:,2))
    ch(ido,2,:) = cc(1,:,1)+taur*(cc(1,:,2)+cc(1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          cc(i-1,:,1)+((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(i,1,:) = &
          cc(i,:,1)+((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(i-1,3,:) = &
          (cc(i-1,:,1)+taur*((wa1(i-2)*cc(i-1,:,2) &
          +wa1(i-1)*cc(i,:,2))+(wa2(i-2)*cc(i-1,:,3) &
          +wa2(i-1)*cc(i,:,3))))+(taui*((wa1(i-2)*cc(i,:,2) &
          -wa1(i-1)*cc(i-1,:,2)) &
          -(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3))))
      ch(ic-1,2,:) = &
          (cc(i-1,:,1)+taur*((wa1(i-2)*cc(i-1,:,2) &
          +wa1(i-1)*cc(i,:,2))+(wa2(i-2)*cc(i-1,:,3) &
          +wa2(i-1)*cc(i,:,3))))-(taui*((wa1(i-2)*cc(i,:,2) &
          -wa1(i-1)*cc(i-1,:,2))-(wa2(i-2)*cc(i,:,3) &
          -wa2(i-1)*cc(i-1,:,3))))
      ch(i,3,:) = &
          (cc(i,:,1)+taur*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))) &
          +(taui*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))))
      ch(ic,2,:) = &
          (taui*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)))) &
          -(cc(i,:,1)+taur*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine 
!
!     double precision scalar version
!
  subroutine dradf3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(0.d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,three=3._kr
    real(kr), dimension(ido,3,l1) :: ch
    real(kr), dimension(ido,l1,3) :: cc
    integer n,idp2,i,ic
    real(kr) arg,taur,taui

    n = size(cci)
    arg=two*pimach(.0_kr)/three
    taur=cos(arg) 
    taui=sin(arg)
!
    cc = reshape(cci,(/ido,l1,3/))
    ch(1,1,:) = cc(1,:,1)+(cc(1,:,2)+cc(1,:,3))
    ch(1,3,:) = taui*(cc(1,:,3)-cc(1,:,2))
    ch(ido,2,:) = cc(1,:,1)+taur*(cc(1,:,2)+cc(1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          cc(i-1,:,1)+((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(i,1,:) = &
          cc(i,:,1)+((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(i-1,3,:) = &
          (cc(i-1,:,1)+taur*((wa1(i-2)*cc(i-1,:,2) &
          +wa1(i-1)*cc(i,:,2))+(wa2(i-2)*cc(i-1,:,3) &
          +wa2(i-1)*cc(i,:,3))))+(taui*((wa1(i-2)*cc(i,:,2) &
          -wa1(i-1)*cc(i-1,:,2)) &
          -(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3))))
      ch(ic-1,2,:) = &
          (cc(i-1,:,1)+taur*((wa1(i-2)*cc(i-1,:,2) &
          +wa1(i-1)*cc(i,:,2))+(wa2(i-2)*cc(i-1,:,3) &
          +wa2(i-1)*cc(i,:,3))))-(taui*((wa1(i-2)*cc(i,:,2) &
          -wa1(i-1)*cc(i-1,:,2))-(wa2(i-2)*cc(i,:,3) &
          -wa2(i-1)*cc(i-1,:,3))))
      ch(i,3,:) = &
          (cc(i,:,1)+taur*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))) &
          +(taui*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))))
      ch(ic,2,:) = &
          (taui*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)))) &
          -(cc(i,:,1)+taur*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!     single precision vector version
!
  subroutine svradf3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(0.)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c3=3._kr
    real(kr), dimension(size(cci,1),ido,3,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,3) :: cc
    integer m,n,idp2,i,ic
    real(kr) arg,taur,taui

    m=size(cci,1) 
    n = size(cci,2)
    arg=c2*pimach(.0_kr)/c3
    taur=cos(arg) 
    taui=sin(arg)
!
    cc = reshape(cci,(/m,ido,l1,3/))
    ch(:,1,1,:) = cc(:,1,:,1)+(cc(:,1,:,2)+cc(:,1,:,3))
    ch(:,1,3,:) = taui*(cc(:,1,:,3)-cc(:,1,:,2))
    ch(:,ido,2,:) = cc(:,1,:,1)+taur*(cc(:,1,:,2)+cc(:,1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          cc(:,i-1,:,1)+((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,i,1,:) = &
          cc(:,i,:,1)+((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,i-1,3,:) = &
          (cc(:,i-1,:,1)+taur*((wa1(i-2)*cc(:,i-1,:,2) &
          +wa1(i-1)*cc(:,i,:,2))+(wa2(i-2)*cc(:,i-1,:,3) &
          +wa2(i-1)*cc(:,i,:,3))))+(taui*((wa1(i-2)*cc(:,i,:,2) &
          -wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3))))
      ch(:,ic-1,2,:) = &
          (cc(:,i-1,:,1)+taur*((wa1(i-2)*cc(:,i-1,:,2) &
          +wa1(i-1)*cc(:,i,:,2))+(wa2(i-2)*cc(:,i-1,:,3) &
          +wa2(i-1)*cc(:,i,:,3))))-(taui*((wa1(i-2)*cc(:,i,:,2) &
          -wa1(i-1)*cc(:,i-1,:,2))-(wa2(i-2)*cc(:,i,:,3) &
          -wa2(i-1)*cc(:,i-1,:,3))))
      ch(:,i,3,:) = &
          (cc(:,i,:,1)+taur*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))) &
          +(taui*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))))
      ch(:,ic,2,:) = &
          (taui*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)))) &
          -(cc(:,i,:,1)+taur*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine 
!
!     double precision vector version
!
  subroutine dvradf3 (ido,l1,cci,chi,wa1,wa2)
    integer, parameter :: kr=kind(0.d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c3=3._kr
    real(kr), dimension(size(cci,1),ido,3,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,3) :: cc
    integer m,n,idp2,i,ic
    real(kr) arg,taur,taui

    m=size(cci,1) 
    n = size(cci,2)
    arg=c2*pimach(.0_kr)/c3
    taur=cos(arg) 
    taui=sin(arg)
!
    cc = reshape(cci,(/m,ido,l1,3/))
    ch(:,1,1,:) = cc(:,1,:,1)+(cc(:,1,:,2)+cc(:,1,:,3))
    ch(:,1,3,:) = taui*(cc(:,1,:,3)-cc(:,1,:,2))
    ch(:,ido,2,:) = cc(:,1,:,1)+taur*(cc(:,1,:,2)+cc(:,1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          cc(:,i-1,:,1)+((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,i,1,:) = &
          cc(:,i,:,1)+((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,i-1,3,:) = &
          (cc(:,i-1,:,1)+taur*((wa1(i-2)*cc(:,i-1,:,2) &
          +wa1(i-1)*cc(:,i,:,2))+(wa2(i-2)*cc(:,i-1,:,3) &
          +wa2(i-1)*cc(:,i,:,3))))+(taui*((wa1(i-2)*cc(:,i,:,2) &
          -wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3))))
      ch(:,ic-1,2,:) = &
          (cc(:,i-1,:,1)+taur*((wa1(i-2)*cc(:,i-1,:,2) &
          +wa1(i-1)*cc(:,i,:,2))+(wa2(i-2)*cc(:,i-1,:,3) &
          +wa2(i-1)*cc(:,i,:,3))))-(taui*((wa1(i-2)*cc(:,i,:,2) &
          -wa1(i-1)*cc(:,i-1,:,2))-(wa2(i-2)*cc(:,i,:,3) &
          -wa2(i-1)*cc(:,i-1,:,3))))
      ch(:,i,3,:) = &
          (cc(:,i,:,1)+taur*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))) &
          +(taui*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))))
      ch(:,ic,2,:) = &
          (taui*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)))) &
          -(cc(:,i,:,1)+taur*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix3f
