!
! fftpk, version 3, sept. 2000
!
module Radix4f
  implicit none
  private
  public radf4
  interface radf4
    module procedure sradf4,dradf4,svradf4,dvradf4
  end interface
contains
!
!    single precision scalar version
!
  subroutine sradf4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr
    real(kr), dimension(ido,4,l1) :: ch
    real(kr), dimension(ido,l1,4) :: cc
    real(kr) hsqt2
    integer n,idp2,i,ic
!
    hsqt2=sqrt(two)/two
    n=size(cci)
!
    cc = reshape(cci,(/ido,l1,4/))
    ch(1,1,:) = (cc(1,:,2)+cc(1,:,4))+(cc(1,:,1)+cc(1,:,3))
    ch(ido,4,:) = (cc(1,:,1)+cc(1,:,3))-(cc(1,:,2)+cc(1,:,4))
    ch(ido,2,:) = cc(1,:,1)-cc(1,:,3)
    ch(1,3,:) = cc(1,:,4)-cc(1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          ((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4))) &
          +(cc(i-1,:,1)+(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(ic-1,4,:) = &
          (cc(i-1,:,1)+(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))) &
          -((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))
      ch(i,1,:) =  &
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          +(cc(i,:,1)+(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(ic,4,:) = & 
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          -(cc(i,:,1)+(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(i-1,3,:) = &
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          +(cc(i-1,:,1)-(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(ic-1,2,:) = &
          (cc(i-1,:,1)-(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))) &
          -((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(i,3,:) =  &
          ((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +(cc(i,:,1)-(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(ic,2,:) = &
          ((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -(cc(i,:,1)-(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
    enddo
    if (mod(ido,2)/=1) then
      ch(ido,1,:) = (hsqt2*(cc(ido,:,2)-cc(ido,:,4)))+cc(ido,:,1)
      ch(ido,3,:) = cc(ido,:,1)-(hsqt2*(cc(ido,:,2)-cc(ido,:,4)))
      ch(1,2,:) = (-hsqt2*(cc(ido,:,2)+cc(ido,:,4)))-cc(ido,:,3)
      ch(1,4,:) = (-hsqt2*(cc(ido,:,2)+cc(ido,:,4)))+cc(ido,:,3)
    endif
    chi = reshape(ch,(/n/))
  end subroutine 
!
!    double precision scalar version
!
  subroutine dradf4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr
    real(kr), dimension(ido,4,l1) :: ch
    real(kr), dimension(ido,l1,4) :: cc
    real(kr) hsqt2
    integer n,idp2,i,ic
!
    hsqt2=sqrt(two)/two
    n=size(cci)
!
    cc = reshape(cci,(/ido,l1,4/))
    ch(1,1,:) = (cc(1,:,2)+cc(1,:,4))+(cc(1,:,1)+cc(1,:,3))
    ch(ido,4,:) = (cc(1,:,1)+cc(1,:,3))-(cc(1,:,2)+cc(1,:,4))
    ch(ido,2,:) = cc(1,:,1)-cc(1,:,3)
    ch(1,3,:) = cc(1,:,4)-cc(1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          ((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4))) &
          +(cc(i-1,:,1)+(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(ic-1,4,:) = &
          (cc(i-1,:,1)+(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))) &
          -((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))
      ch(i,1,:) =  &
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          +(cc(i,:,1)+(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(ic,4,:) = & 
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          -(cc(i,:,1)+(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(i-1,3,:) = &
          ((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))) &
          +(cc(i-1,:,1)-(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))
      ch(ic-1,2,:) = &
          (cc(i-1,:,1)-(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))) &
          -((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(i,3,:) =  &
          ((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +(cc(i,:,1)-(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
      ch(ic,2,:) = &
          ((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -(cc(i,:,1)-(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)))
    enddo
    if (mod(ido,2)/=1) then
      ch(ido,1,:) = (hsqt2*(cc(ido,:,2)-cc(ido,:,4)))+cc(ido,:,1)
      ch(ido,3,:) = cc(ido,:,1)-(hsqt2*(cc(ido,:,2)-cc(ido,:,4)))
      ch(1,2,:) = (-hsqt2*(cc(ido,:,2)+cc(ido,:,4)))-cc(ido,:,3)
      ch(1,4,:) = (-hsqt2*(cc(ido,:,2)+cc(ido,:,4)))+cc(ido,:,3)
    endif
    chi = reshape(ch,(/n/))
  end subroutine 
!
!    single precision vector version
!
  subroutine svradf4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr
    real(kr), dimension(size(cci,1),ido,4,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,4) :: cc
    real(kr) hsqt2
    integer m,n,idp2,i,ic
!
    hsqt2=sqrt(c2)/c2
    m=size(cci,1) 
    n=size(cci,2)
!
    cc = reshape(cci,(/m,ido,l1,4/))
    ch(:,1,1,:) = (cc(:,1,:,2)+cc(:,1,:,4))+(cc(:,1,:,1)+cc(:,1,:,3))
    ch(:,ido,4,:) = (cc(:,1,:,1)+cc(:,1,:,3))-(cc(:,1,:,2)+cc(:,1,:,4))
    ch(:,ido,2,:) = cc(:,1,:,1)-cc(:,1,:,3)
    ch(:,1,3,:) = cc(:,1,:,4)-cc(:,1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          ((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4))) &
          +(cc(:,i-1,:,1)+(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,ic-1,4,:) = &
          (cc(:,i-1,:,1)+(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))) &
          -((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))
      ch(:,i,1,:) =  &
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          +(cc(:,i,:,1)+(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,ic,4,:) = & 
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          -(cc(:,i,:,1)+(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,i-1,3,:) = &
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          +(cc(:,i-1,:,1)-(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,ic-1,2,:) = &
          (cc(:,i-1,:,1)-(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))) &
          -((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,i,3,:) =  &
          ((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +(cc(:,i,:,1)-(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,ic,2,:) = &
          ((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -(cc(:,i,:,1)-(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
    enddo
    if (mod(ido,2)/=1) then
      ch(:,ido,1,:) = (hsqt2*(cc(:,ido,:,2)-cc(:,ido,:,4)))+cc(:,ido,:,1)
      ch(:,ido,3,:) = cc(:,ido,:,1)-(hsqt2*(cc(:,ido,:,2)-cc(:,ido,:,4)))
      ch(:,1,2,:) = (-hsqt2*(cc(:,ido,:,2)+cc(:,ido,:,4)))-cc(:,ido,:,3)
      ch(:,1,4,:) = (-hsqt2*(cc(:,ido,:,2)+cc(:,ido,:,4)))+cc(:,ido,:,3)
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine 
!
!    double precision vector version
!
  subroutine dvradf4 (ido,l1,cci,chi,wa1,wa2,wa3)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr
    real(kr), dimension(size(cci,1),ido,4,l1) :: ch
    real(kr), dimension(size(cci,1),ido,l1,4) :: cc
    real(kr) hsqt2
    integer m,n,idp2,i,ic
!
    hsqt2=sqrt(c2)/c2
    m=size(cci,1) 
    n=size(cci,2)
!
    cc = reshape(cci,(/m,ido,l1,4/))
    ch(:,1,1,:) = (cc(:,1,:,2)+cc(:,1,:,4))+(cc(:,1,:,1)+cc(:,1,:,3))
    ch(:,ido,4,:) = (cc(:,1,:,1)+cc(:,1,:,3))-(cc(:,1,:,2)+cc(:,1,:,4))
    ch(:,ido,2,:) = cc(:,1,:,1)-cc(:,1,:,3)
    ch(:,1,3,:) = cc(:,1,:,4)-cc(:,1,:,2)
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          ((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4))) &
          +(cc(:,i-1,:,1)+(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,ic-1,4,:) = &
          (cc(:,i-1,:,1)+(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))) &
          -((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))
      ch(:,i,1,:) =  &
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          +(cc(:,i,:,1)+(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,ic,4,:) = & 
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          -(cc(:,i,:,1)+(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,i-1,3,:) = &
          ((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))) &
          +(cc(:,i-1,:,1)-(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))
      ch(:,ic-1,2,:) = &
          (cc(:,i-1,:,1)-(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))) &
          -((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,i,3,:) =  &
          ((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +(cc(:,i,:,1)-(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
      ch(:,ic,2,:) = &
          ((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -(cc(:,i,:,1)-(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)))
    enddo
    if (mod(ido,2)/=1) then
      ch(:,ido,1,:) = (hsqt2*(cc(:,ido,:,2)-cc(:,ido,:,4)))+cc(:,ido,:,1)
      ch(:,ido,3,:) = cc(:,ido,:,1)-(hsqt2*(cc(:,ido,:,2)-cc(:,ido,:,4)))
      ch(:,1,2,:) = (-hsqt2*(cc(:,ido,:,2)+cc(:,ido,:,4)))-cc(:,ido,:,3)
      ch(:,1,4,:) = (-hsqt2*(cc(:,ido,:,2)+cc(:,ido,:,4)))+cc(:,ido,:,3)
    endif
    chi = reshape(ch,(/m,n/))
  end subroutine 
end module Radix4f
