!
! fftpk, version 3, sept. 2000
!
module Radix5f
  use PiMachine
  implicit none
  private
  public radf5
  interface radf5
    module procedure sradf5,dradf5,svradf5,dvradf5
  end interface
contains
!
!   single precision scalar version
!
  subroutine sradf5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,five=5._kr
    real(kr), dimension(ido,l1,5) :: cc
    real(kr), dimension(ido,5,l1) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer n,idp2,i,ic

    arg=two*pimach(.0_kr)/five 
    darg=two*arg
    tr11=cos(arg)
    ti11=sin(arg)
    tr12=cos(darg)
    ti12=sin(darg)
    n=size(cci)
!
    cc = reshape(cci,(/ido,l1,5/))
    ch(1,1,:) = cc(1,:,1)+(cc(1,:,5)+cc(1,:,2)) &
                  +(cc(1,:,4)+cc(1,:,3))
    ch(ido,2,:) = cc(1,:,1)+tr11*(cc(1,:,5)+cc(1,:,2)) &
                    +tr12*(cc(1,:,4)+cc(1,:,3))
    ch(1,3,:) = ti11*(cc(1,:,5)-cc(1,:,2)) &
                  +ti12*(cc(1,:,4)-cc(1,:,3))
    ch(ido,4,:) = cc(1,:,1)+tr12*(cc(1,:,5)+cc(1,:,2)) &
                    +tr11*(cc(1,:,4)+cc(1,:,3))
    ch(1,5,:) = ti12*(cc(1,:,5)-cc(1,:,2)) &
                  -ti11*(cc(1,:,4)-cc(1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          cc(i-1,:,1)+((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))
      ch(i,1,:) = &
          cc(i,:,1)+((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(i-1,3,:) = &
          cc(i-1,:,1)+tr11*(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2) &
         +wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
         +tr12*(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3) &
         +wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
         +ti11*(wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2) &
         -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
         +ti12*(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3) &
         -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(ic-1,2,:) = &
          cc(i-1,:,1)+tr11*(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2) &
          +wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          +tr12*(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3) &
          +wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(ti11*(wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +ti12*(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i,3,:) = & 
          (cc(i,:,1)+tr11*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))) &
          +(ti11*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +ti12*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))))
      ch(ic,2,:) = &
          (ti11*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +ti12*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))) &
          -(cc(i,:,1)+tr11*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i-1,5,:) = &
          (cc(i-1,:,1)+tr12*((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +tr11*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))) &
          +(ti12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(ic-1,4,:) = &
          (cc(i-1,:,1)+tr12*((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +tr11*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))) &
          -(ti12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i,5,:) = &
          (cc(i,:,1)+tr12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))) &
          +(ti12*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -ti11*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))))
      ch(ic,4,:) = &
          (ti12*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -ti11*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))) &
          -(cc(i,:,1)+tr12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!   double precision scalar version
!
  subroutine dradf5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:), intent(in) :: cci
    real(kr), dimension(:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: two=2._kr,five=5._kr
    real(kr), dimension(ido,l1,5) :: cc
    real(kr), dimension(ido,5,l1) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer n,idp2,i,ic

    arg=two*pimach(.0_kr)/five
    darg=two*arg
    tr11=cos(arg)
    ti11=sin(arg)
    tr12=cos(darg)
    ti12=sin(darg)
    n=size(cci)
!
    cc = reshape(cci,(/ido,l1,5/))
    ch(1,1,:) = cc(1,:,1)+(cc(1,:,5)+cc(1,:,2)) &
                  +(cc(1,:,4)+cc(1,:,3))
    ch(ido,2,:) = cc(1,:,1)+tr11*(cc(1,:,5)+cc(1,:,2)) &
                    +tr12*(cc(1,:,4)+cc(1,:,3))
    ch(1,3,:) = ti11*(cc(1,:,5)-cc(1,:,2)) &
                  +ti12*(cc(1,:,4)-cc(1,:,3))
    ch(ido,4,:) = cc(1,:,1)+tr12*(cc(1,:,5)+cc(1,:,2)) &
                    +tr11*(cc(1,:,4)+cc(1,:,3))
    ch(1,5,:) = ti12*(cc(1,:,5)-cc(1,:,2)) &
                  -ti11*(cc(1,:,4)-cc(1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(i-1,1,:) = &
          cc(i-1,:,1)+((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))
      ch(i,1,:) = &
          cc(i,:,1)+((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(i-1,3,:) = &
          cc(i-1,:,1)+tr11*(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2) &
         +wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
         +tr12*(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3) &
         +wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
         +ti11*(wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2) &
         -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
         +ti12*(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3) &
         -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))
      ch(ic-1,2,:) = &
          cc(i-1,:,1)+tr11*(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2) &
          +wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          +tr12*(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3) &
          +wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(ti11*(wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +ti12*(wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i,3,:) = & 
          (cc(i,:,1)+tr11*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))) &
          +(ti11*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +ti12*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))))
      ch(ic,2,:) = &
          (ti11*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          +ti12*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))) &
          -(cc(i,:,1)+tr11*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i-1,5,:) = &
          (cc(i-1,:,1)+tr12*((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +tr11*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))) &
          +(ti12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(ic-1,4,:) = &
          (cc(i-1,:,1)+tr12*((wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2)) &
          +(wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5))) &
          +tr11*((wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)) &
          +(wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)))) &
          -(ti12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          -(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          -(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
      ch(i,5,:) = &
          (cc(i,:,1)+tr12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4)))) &
          +(ti12*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -ti11*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3))))
      ch(ic,4,:) = &
          (ti12*((wa4(i-2)*cc(i-1,:,5)+wa4(i-1)*cc(i,:,5)) &
          -(wa1(i-2)*cc(i-1,:,2)+wa1(i-1)*cc(i,:,2))) &
          -ti11*((wa3(i-2)*cc(i-1,:,4)+wa3(i-1)*cc(i,:,4)) &
          -(wa2(i-2)*cc(i-1,:,3)+wa2(i-1)*cc(i,:,3)))) &
          -(cc(i,:,1)+tr12*((wa1(i-2)*cc(i,:,2)-wa1(i-1)*cc(i-1,:,2)) &
          +(wa4(i-2)*cc(i,:,5)-wa4(i-1)*cc(i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(i,:,3)-wa2(i-1)*cc(i-1,:,3)) &
          +(wa3(i-2)*cc(i,:,4)-wa3(i-1)*cc(i-1,:,4))))
    enddo
    chi = reshape(ch,(/n/))
  end subroutine
!
!   single precision vector version
!
  subroutine svradf5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c5=5._kr
    real(kr), dimension(size(cci,1),ido,l1,5) :: cc
    real(kr), dimension(size(cci,1),ido,5,l1) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer m,n,idp2,i,ic

    arg=c2*pimach(.0_kr)/c5 
    darg=c2*arg
    tr11=cos(arg) 
    ti11=sin(arg) 
    tr12=cos(darg) 
    ti12=sin(darg)
    m=size(cci,1) 
    n=size(cci,2)
!
    cc = reshape(cci,(/m,ido,l1,5/))
    ch(:,1,1,:) = cc(:,1,:,1)+(cc(:,1,:,5)+cc(:,1,:,2)) &
                  +(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,ido,2,:) = cc(:,1,:,1)+tr11*(cc(:,1,:,5)+cc(:,1,:,2)) &
                    +tr12*(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,1,3,:) = ti11*(cc(:,1,:,5)-cc(:,1,:,2)) &
                  +ti12*(cc(:,1,:,4)-cc(:,1,:,3))
    ch(:,ido,4,:) = cc(:,1,:,1)+tr12*(cc(:,1,:,5)+cc(:,1,:,2)) &
                    +tr11*(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,1,5,:) = ti12*(cc(:,1,:,5)-cc(:,1,:,2)) &
                  -ti11*(cc(:,1,:,4)-cc(:,1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          cc(:,i-1,:,1)+((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))
      ch(:,i,1,:) = &
          cc(:,i,:,1)+((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,i-1,3,:) = &
          cc(:,i-1,:,1)+tr11*(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2) &
         +wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
         +tr12*(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3) &
         +wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
         +ti11*(wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2) &
         -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
         +ti12*(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3) &
         -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,ic-1,2,:) = &
          cc(:,i-1,:,1)+tr11*(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2) &
          +wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          +tr12*(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3) &
          +wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(ti11*(wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +ti12*(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i,3,:) = & 
          (cc(:,i,:,1)+tr11*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))) &
          +(ti11*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +ti12*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))))
      ch(:,ic,2,:) = &
          (ti11*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +ti12*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))) &
          -(cc(:,i,:,1)+tr11*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i-1,5,:) = &
          (cc(:,i-1,:,1)+tr12*((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))) &
          +(ti12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,ic-1,4,:) = &
          (cc(:,i-1,:,1)+tr12*((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))) &
          -(ti12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i,5,:) = &
          (cc(:,i,:,1)+tr12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))) &
          +(ti12*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -ti11*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))))
      ch(:,ic,4,:) = &
          (ti12*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -ti11*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))) &
          -(cc(:,i,:,1)+tr12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
!
!   double precision vector version
!
  subroutine dvradf5 (ido,l1,cci,chi,wa1,wa2,wa3,wa4)
    integer, parameter :: kr=kind(.0d0)
    real(kr), dimension(:,:), intent(in) :: cci
    real(kr), dimension(:,:), intent(inout) :: chi
    real(kr), dimension(:), intent(in) :: wa1,wa2,wa3,wa4
    integer, intent(in) :: ido,l1
!
    real(kr), parameter :: c2=2._kr,c5=5._kr
    real(kr), dimension(size(cci,1),ido,l1,5) :: cc
    real(kr), dimension(size(cci,1),ido,5,l1) :: ch
    real(kr) arg,darg,tr11,ti11,tr12,ti12
    integer m,n,idp2,i,ic

    arg=c2*pimach(.0_kr)/c5 
    darg=c2*arg
    tr11=cos(arg) 
    ti11=sin(arg) 
    tr12=cos(darg) 
    ti12=sin(darg)
    m=size(cci,1) 
    n=size(cci,2)
!
    cc = reshape(cci,(/m,ido,l1,5/))
    ch(:,1,1,:) = cc(:,1,:,1)+(cc(:,1,:,5)+cc(:,1,:,2)) &
                  +(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,ido,2,:) = cc(:,1,:,1)+tr11*(cc(:,1,:,5)+cc(:,1,:,2)) &
                    +tr12*(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,1,3,:) = ti11*(cc(:,1,:,5)-cc(:,1,:,2)) &
                  +ti12*(cc(:,1,:,4)-cc(:,1,:,3))
    ch(:,ido,4,:) = cc(:,1,:,1)+tr12*(cc(:,1,:,5)+cc(:,1,:,2)) &
                    +tr11*(cc(:,1,:,4)+cc(:,1,:,3))
    ch(:,1,5,:) = ti12*(cc(:,1,:,5)-cc(:,1,:,2)) &
                  -ti11*(cc(:,1,:,4)-cc(:,1,:,3))
    idp2 = ido+2
    do i=3,ido,2
      ic = idp2-i
      ch(:,i-1,1,:) = &
          cc(:,i-1,:,1)+((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))
      ch(:,i,1,:) = &
          cc(:,i,:,1)+((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,i-1,3,:) = &
          cc(:,i-1,:,1)+tr11*(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2) &
         +wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
         +tr12*(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3) &
         +wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
         +ti11*(wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2) &
         -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
         +ti12*(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3) &
         -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))
      ch(:,ic-1,2,:) = &
          cc(:,i-1,:,1)+tr11*(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2) &
          +wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          +tr12*(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3) &
          +wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(ti11*(wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +ti12*(wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i,3,:) = & 
          (cc(:,i,:,1)+tr11*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))) &
          +(ti11*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +ti12*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))))
      ch(:,ic,2,:) = &
          (ti11*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          +ti12*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))) &
          -(cc(:,i,:,1)+tr11*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr12*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i-1,5,:) = &
          (cc(:,i-1,:,1)+tr12*((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))) &
          +(ti12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,ic-1,4,:) = &
          (cc(:,i-1,:,1)+tr12*((wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2)) &
          +(wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)) &
          +(wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)))) &
          -(ti12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          -(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          -ti11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          -(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
      ch(:,i,5,:) = &
          (cc(:,i,:,1)+tr12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4)))) &
          +(ti12*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -ti11*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3))))
      ch(:,ic,4,:) = &
          (ti12*((wa4(i-2)*cc(:,i-1,:,5)+wa4(i-1)*cc(:,i,:,5)) &
          -(wa1(i-2)*cc(:,i-1,:,2)+wa1(i-1)*cc(:,i,:,2))) &
          -ti11*((wa3(i-2)*cc(:,i-1,:,4)+wa3(i-1)*cc(:,i,:,4)) &
          -(wa2(i-2)*cc(:,i-1,:,3)+wa2(i-1)*cc(:,i,:,3)))) &
          -(cc(:,i,:,1)+tr12*((wa1(i-2)*cc(:,i,:,2)-wa1(i-1)*cc(:,i-1,:,2)) &
          +(wa4(i-2)*cc(:,i,:,5)-wa4(i-1)*cc(:,i-1,:,5))) &
          +tr11*((wa2(i-2)*cc(:,i,:,3)-wa2(i-1)*cc(:,i-1,:,3)) &
          +(wa3(i-2)*cc(:,i,:,4)-wa3(i-1)*cc(:,i-1,:,4))))
    enddo
    chi = reshape(ch,(/m,n/))
  end subroutine
end module Radix5f
