!
!     fftpk, version 3, sept. 2000
!
module Radixgf
  use PiMachine
  implicit none
  private
  public radfg
  interface radfg
    module procedure sradfg,dradfg,svradfg,dvradfg
  end interface
contains
!
!  single precision scalar version
!
  subroutine sradfg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: two=2.0_kr
    real(kr), dimension(ido,l1,ip) :: ch,c1
    real(kr), dimension(ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc
 
    n=size(cci)
    ch = reshape(chi,(/ido,l1,ip/))
    c1 = reshape(cci,(/ido,l1,ip/))

    arg = two*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    ipph = (ip+1)/2
    ipp2 = ip+2
    idp2 = ido+2
    nbd = (ido-1)/2
    select case (ido)
    case (1)
      c1(:,:,1) = ch(:,:,1)
    case default
      ch(:,:,1) = c1(:,:,1)
      ch(1,:,2:ip) = c1(1,:,2:ip)
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          ch(i-1,:,j) = wa(idij-1)*c1(i-1,:,j)+wa(idij)*c1(i,:,j)
          ch(i,:,j) = wa(idij-1)*c1(i,:,j)-wa(idij)*c1(i-1,:,j)
        enddo
      enddo
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          c1(i-1,:,j) = ch(i-1,:,j)+ch(i-1,:,jc)
          c1(i-1,:,jc) = ch(i,:,j)-ch(i,:,jc)
          c1(i,:,j) = ch(i,:,j)+ch(i,:,jc)
          c1(i,:,jc) = ch(i-1,:,jc)-ch(i-1,:,j)
        enddo
      enddo
    end select
    do j=2,ipph
      jc = ipp2-j
      c1(1,:,j) = ch(1,:,j)+ch(1,:,jc)
      c1(1,:,jc) = ch(1,:,jc)-ch(1,:,j)
    enddo
!
    ar1 = 1._kr
    ai1 = 0._kr
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      ch(:,:,l) = c1(:,:,1)+ar1*c1(:,:,2)
      ch(:,:,lc) = ai1*c1(:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        ch(:,:,l) = ch(:,:,l)+ar2*c1(:,:,j)
        ch(:,:,lc) = ch(:,:,lc)+ai2*c1(:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,1) = ch(:,:,1)+c1(:,:,j)
    enddo
!
    cc = reshape(c1,(/ido,ip,l1/))
    cc(:,1,:) = ch(:,:,1)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      cc(ido,j2-2,:) = ch(1,:,j)
      cc(1,j2-1,:) = ch(1,:,jc)
      do i=3,ido,2
        ic = idp2-i
        cc(i-1,j2-1,:) = ch(i-1,:,j)+ch(i-1,:,jc)
        cc(ic-1,j2-2,:) = ch(i-1,:,j)-ch(i-1,:,jc)
        cc(i,j2-1,:) = ch(i,:,j)+ch(i,:,jc)
        cc(ic,j2-2,:) = ch(i,:,jc)-ch(i,:,j)
      enddo
    enddo
    chi = reshape(ch,(/n/))
    cci = reshape(cc,(/n/))
  end subroutine
!
!  double precision scalar version
!
  subroutine dradfg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: two=2.0_kr
    real(kr), dimension(ido,l1,ip) :: ch,c1
    real(kr), dimension(ido,ip,l1) :: cc
    real(kr) arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc
 
    n=size(cci)
    ch = reshape(chi,(/ido,l1,ip/))
    c1 = reshape(cci,(/ido,l1,ip/))

    arg = two*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    ipph = (ip+1)/2
    ipp2 = ip+2
    idp2 = ido+2
    nbd = (ido-1)/2
    select case (ido)
    case (1)
      c1(:,:,1) = ch(:,:,1)
    case default
      ch(:,:,1) = c1(:,:,1)
      ch(1,:,2:ip) = c1(1,:,2:ip)
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          ch(i-1,:,j) = wa(idij-1)*c1(i-1,:,j)+wa(idij)*c1(i,:,j)
          ch(i,:,j) = wa(idij-1)*c1(i,:,j)-wa(idij)*c1(i-1,:,j)
        enddo
      enddo
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          c1(i-1,:,j) = ch(i-1,:,j)+ch(i-1,:,jc)
          c1(i-1,:,jc) = ch(i,:,j)-ch(i,:,jc)
          c1(i,:,j) = ch(i,:,j)+ch(i,:,jc)
          c1(i,:,jc) = ch(i-1,:,jc)-ch(i-1,:,j)
        enddo
      enddo
    end select
    do j=2,ipph
      jc = ipp2-j
      c1(1,:,j) = ch(1,:,j)+ch(1,:,jc)
      c1(1,:,jc) = ch(1,:,jc)-ch(1,:,j)
    enddo
!
    ar1 = 1._kr
    ai1 = 0._kr
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      ch(:,:,l) = c1(:,:,1)+ar1*c1(:,:,2)
      ch(:,:,lc) = ai1*c1(:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        ch(:,:,l) = ch(:,:,l)+ar2*c1(:,:,j)
        ch(:,:,lc) = ch(:,:,lc)+ai2*c1(:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,1) = ch(:,:,1)+c1(:,:,j)
    enddo
!
    cc = reshape(c1,(/ido,ip,l1/))
    cc(:,1,:) = ch(:,:,1)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      cc(ido,j2-2,:) = ch(1,:,j)
      cc(1,j2-1,:) = ch(1,:,jc)
      do i=3,ido,2
        ic = idp2-i
        cc(i-1,j2-1,:) = ch(i-1,:,j)+ch(i-1,:,jc)
        cc(ic-1,j2-2,:) = ch(i-1,:,j)-ch(i-1,:,jc)
        cc(i,j2-1,:) = ch(i,:,j)+ch(i,:,jc)
        cc(ic,j2-2,:) = ch(i,:,jc)-ch(i,:,j)
      enddo
    enddo
    chi = reshape(ch,(/n/))
    cci = reshape(cc,(/n/))
  end subroutine
!
!  single precision vector version
!
  subroutine svradfg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0)
    real(kr), dimension(:,:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: c2=2.0_kr
    real(kr), dimension(size(cci,1),ido,l1,ip) :: ch,c1
    real(kr), dimension(size(cci,1),ido,ip,l1) :: cc
    real(kr) tpi,arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer m,n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc
 
    m=size(cci,1) 
    n=size(cci,2)
    ch = reshape(chi,(/m,ido,l1,ip/))
    c1 = reshape(cci,(/m,ido,l1,ip/))

    arg = c2*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    ipph = (ip+1)/2
    ipp2 = ip+2
    idp2 = ido+2
    nbd = (ido-1)/2
    select case (ido)
    case (1)
      c1(:,:,:,1) = ch(:,:,:,1)
    case default
      ch(:,:,:,1) = c1(:,:,:,1)
      ch(:,1,:,2:ip) = c1(:,1,:,2:ip)
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          ch(:,i-1,:,j) = wa(idij-1)*c1(:,i-1,:,j)+wa(idij)*c1(:,i,:,j)
          ch(:,i,:,j) = wa(idij-1)*c1(:,i,:,j)-wa(idij)*c1(:,i-1,:,j)
        enddo
      enddo
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          c1(:,i-1,:,j) = ch(:,i-1,:,j)+ch(:,i-1,:,jc)
          c1(:,i-1,:,jc) = ch(:,i,:,j)-ch(:,i,:,jc)
          c1(:,i,:,j) = ch(:,i,:,j)+ch(:,i,:,jc)
          c1(:,i,:,jc) = ch(:,i-1,:,jc)-ch(:,i-1,:,j)
        enddo
      enddo
    end select
    do j=2,ipph
      jc = ipp2-j
      c1(:,1,:,j) = ch(:,1,:,j)+ch(:,1,:,jc)
      c1(:,1,:,jc) = ch(:,1,:,jc)-ch(:,1,:,j)
    enddo
!
    ar1 = 1.
    ai1 = 0.
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      ch(:,:,:,l) = c1(:,:,:,1)+ar1*c1(:,:,:,2)
      ch(:,:,:,lc) = ai1*c1(:,:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        ch(:,:,:,l) = ch(:,:,:,l)+ar2*c1(:,:,:,j)
        ch(:,:,:,lc) = ch(:,:,:,lc)+ai2*c1(:,:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,:,1) = ch(:,:,:,1)+c1(:,:,:,j)
    enddo
!
    cc = reshape(c1,(/m,ido,ip,l1/))
    cc(:,:,1,:) = ch(:,:,:,1)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      cc(:,ido,j2-2,:) = ch(:,1,:,j)
      cc(:,1,j2-1,:) = ch(:,1,:,jc)
      do i=3,ido,2
        ic = idp2-i
        cc(:,i-1,j2-1,:) = ch(:,i-1,:,j)+ch(:,i-1,:,jc)
        cc(:,ic-1,j2-2,:) = ch(:,i-1,:,j)-ch(:,i-1,:,jc)
        cc(:,i,j2-1,:) = ch(:,i,:,j)+ch(:,i,:,jc)
        cc(:,ic,j2-2,:) = ch(:,i,:,jc)-ch(:,i,:,j)
      enddo
    enddo
    chi = reshape(ch,(/m,n/))
    cci = reshape(cc,(/m,n/))
  end subroutine
!
!  double precision vector version
!
  subroutine dvradfg (ido,ip,l1,cci,chi,wa)
    integer, parameter :: kr=kind(0.0d0)
    real(kr), dimension(:,:), intent(inout) :: chi,cci
    real(kr), dimension(:), intent(in) :: wa
    integer, intent(in) :: ido,ip,l1
!
    real(kr), parameter :: c2=2.0_kr
    real(kr), dimension(size(cci,1),ido,l1,ip) :: ch,c1
    real(kr), dimension(size(cci,1),ido,ip,l1) :: cc
    real(kr) tpi,arg,dcp,dsp,ar1,ai1,ar1h,dc2,ds2,ar2,ai2,ar2h
    integer m,n,ipph,ipp2,idp2,nbd,i,ic,is,idij,j,j2,jc,l,lc
 
    m=size(cci,1) 
    n=size(cci,2)
    ch = reshape(chi,(/m,ido,l1,ip/))
    c1 = reshape(cci,(/m,ido,l1,ip/))

    arg = c2*pimach(.0_kr)/real(ip,kr)
    dcp = cos(arg)
    dsp = sin(arg)
    ipph = (ip+1)/2
    ipp2 = ip+2
    idp2 = ido+2
    nbd = (ido-1)/2
    select case (ido)
    case (1)
      c1(:,:,:,1) = ch(:,:,:,1)
    case default
      ch(:,:,:,1) = c1(:,:,:,1)
      ch(:,1,:,2:ip) = c1(:,1,:,2:ip)
      is = -ido
      do j=2,ip
        is = is+ido
        idij = is
        do i=3,ido,2
          idij = idij+2
          ch(:,i-1,:,j) = wa(idij-1)*c1(:,i-1,:,j)+wa(idij)*c1(:,i,:,j)
          ch(:,i,:,j) = wa(idij-1)*c1(:,i,:,j)-wa(idij)*c1(:,i-1,:,j)
        enddo
      enddo
      do j=2,ipph
        jc = ipp2-j
        do i=3,ido,2
          c1(:,i-1,:,j) = ch(:,i-1,:,j)+ch(:,i-1,:,jc)
          c1(:,i-1,:,jc) = ch(:,i,:,j)-ch(:,i,:,jc)
          c1(:,i,:,j) = ch(:,i,:,j)+ch(:,i,:,jc)
          c1(:,i,:,jc) = ch(:,i-1,:,jc)-ch(:,i-1,:,j)
        enddo
      enddo
    end select
    do j=2,ipph
      jc = ipp2-j
      c1(:,1,:,j) = ch(:,1,:,j)+ch(:,1,:,jc)
      c1(:,1,:,jc) = ch(:,1,:,jc)-ch(:,1,:,j)
    enddo
!
    ar1 = 1.
    ai1 = 0.
    do l=2,ipph
      lc = ipp2-l
      ar1h = dcp*ar1-dsp*ai1
      ai1 = dcp*ai1+dsp*ar1
      ar1 = ar1h
      ch(:,:,:,l) = c1(:,:,:,1)+ar1*c1(:,:,:,2)
      ch(:,:,:,lc) = ai1*c1(:,:,:,ip)
      dc2 = ar1
      ds2 = ai1
      ar2 = ar1
      ai2 = ai1
      do j=3,ipph
        jc = ipp2-j
        ar2h = dc2*ar2-ds2*ai2
        ai2 = dc2*ai2+ds2*ar2
        ar2 = ar2h
        ch(:,:,:,l) = ch(:,:,:,l)+ar2*c1(:,:,:,j)
        ch(:,:,:,lc) = ch(:,:,:,lc)+ai2*c1(:,:,:,jc)
      enddo
    enddo
    do j=2,ipph
      ch(:,:,:,1) = ch(:,:,:,1)+c1(:,:,:,j)
    enddo
!
    cc = reshape(c1,(/m,ido,ip,l1/))
    cc(:,:,1,:) = ch(:,:,:,1)
    do j=2,ipph
      jc = ipp2-j
      j2 = j+j
      cc(:,ido,j2-2,:) = ch(:,1,:,j)
      cc(:,1,j2-1,:) = ch(:,1,:,jc)
      do i=3,ido,2
        ic = idp2-i
        cc(:,i-1,j2-1,:) = ch(:,i-1,:,j)+ch(:,i-1,:,jc)
        cc(:,ic-1,j2-2,:) = ch(:,i-1,:,j)-ch(:,i-1,:,jc)
        cc(:,i,j2-1,:) = ch(:,i,:,j)+ch(:,i,:,jc)
        cc(:,ic,j2-2,:) = ch(:,i,:,jc)-ch(:,i,:,j)
      enddo
    enddo
    chi = reshape(ch,(/m,n/))
    cci = reshape(cc,(/m,n/))
  end subroutine
end module Radixgf
