program sctest 
!                                                                   
!     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
!                                                                   
!                   version 3  sept 2000                           
!                                                                   
!                     a test driver for                             
!      a package of fortran subprograms for the fast fourier        
!       transform of periodic and other symmetric sequences         
!                                                                  
!                                                                   
!     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
!                                                                   
!                                                                   
!         this program tests the package of fast fourier            
!     transforms for both complex and real periodic sequences and   
!     certian other symmetric sequences that are listed below.      
!                                                                   
!     1.   fti      initialize  ftrf, ftrb,  ftcf and ftcb                   
!     2.   ftrf     forward transform of a real periodic sequence  
!     3.   ftrb     backward transform of a real coefficient array     
!                                                                   
!     4.   ftcf     forward transform of a complex periodic sequence  
!     5.   ftcb     backward transform of a complex coefficient array     
!                                                                   
!     7.   fthsi    initialize fths                                
!     8.   fths     sine transform of a real odd sequence              
!                                                                   
!     9.   fthci    initialize fthc                                
!     10.  fthc     cosine transform of a real even sequence           
!                                                                   
!     11.  ftqi      initialize ftqsf, ftqsb, ftqcf and ftqcb                   
!     12.  ftqsf     forward sine transform with odd wave numbers   
!     13.  ftqsb     normalized inverse of ftqsf                  
!                                                                   
!     15.  ftqcf     forward cosine transform with odd wave numbers     
!     16.  ftqcb     normalized inverse of ftqcf                  
!                                                                   
!	to change:
!             precision of the test, change k
!
!	this program is for scalar sequences
!                                                                   
  use fftpk90
  use PiMachine
  implicit none
  integer, parameter :: kr=kind(0.d0)
  integer, parameter :: nns=6
  integer, dimension(nns) :: ndata=(/840,7,5,4,3,2/)
  real(kr), dimension(:), allocatable :: x,y,xh
  real(kr), dimension(:), allocatable :: w,ri,args
  real(kr), parameter :: half=.5_kr,one=1._kr,two=2._kr,four=4._kr
  real(kr) pi,sqrt2,sqrth,fn,cf,dt,arg1,sum1,sum2,arg
  real(kr) ftqsft,ftqsfb,fthcfb,ftqsbt,ftqcfb,rftf,ftqcbt,ftqcft, &
           rftb,fthsfb,fthct,fthst,rftfb,cftb,cftf,cftfb
  integer n,np1,nm1,ns2,k,i,nh,nz,nd
  logical modn

  pi = pimach(.0_kr)
  sqrt2 = sqrt(two) 
  sqrth = one/sqrt2
  do nz=1,nns 
    n = ndata(nz) 
    modn = mod(n,2) == 0 
    fn = real(n,kr) 
    np1 = n+1 
    nm1 = n-1 
    ns2 = (n+1)/2 
    nh = ns2-1
    nd = 2*n
    allocate(ri(np1))
    allocate(args(np1))
    ri = (/ (real(i,kr),i=1,np1) /)
    args = sqrt2*ri
!                                                                   
!     test subroutines fti,ftrf and ftrb                        
!                                                                   
    allocate(x(n),y(n),xh(n))
    allocate(w(ftiq(n)))
    call random_number(x)
    y = x
    xh = x
    dt = two*pi/fn
    cf = one/sqrt(fn)
    call fti (w) 
    do k=2,ns2 
      args(:n) = (ri(:n)-one)*real(k-1,kr)*dt
      y(2*k-2) = sum(x(:)*cos(args(:n)))
      y(2*k-1) = -sum(x(:)*sin(args(:n)))
    enddo
    sum1 = sum(x(1:nm1:2))
    sum2 = sum(x(2:n:2))
    if (.not. modn) sum1 = sum1+x(n)
    y(1) = sum1+sum2 
    if (modn) y(n) = sum1-sum2
    call ftrf (x,w) 
    rftf = maxval(abs(x-cf*y))
    x = xh
    do i=1,n 
      args(:nh) = ri(:nh)*real(i-1,kr)*dt 
      y(i) = x(1)+two*sum(x(2:nm1:2)*cos(args(:nh)) &
                            -x(3:n:2)*sin(args(:nh)))
      if (modn) y(i) = y(i)+real((-1)**(i-1),kr)*x(n) 
    enddo
    call ftrb (x,w) 
    rftb = maxval(abs(x-cf*y))
    x = xh
    y = xh
    call ftrb (y,w) 
    call ftrf (y,w) 
    rftfb = maxval(abs(y-x))
    deallocate(x,y,xh)
    deallocate(w)
!                                                                   
!     test subroutines ftcf and ftcb                        
!                                                                   
    allocate(x(nd),y(nd),xh(nd))
    allocate(w(ftiq(n)))
    call random_number(x)
    xh = x
    dt = two*pi/fn
    cf = one/sqrt(fn)
    call fti (w)
    do k=1,n 
      args(:n) = (ri(:n)-one)*real(k-1,kr)*dt
      y(2*k-1) = sum(x(1::2)*cos(args(:n))+x(2::2)*sin(args(:n)))
      y(2*k) = sum(x(2::2)*cos(args(:n))-x(1::2)*sin(args(:n)))
    enddo
    call ftcf (x,w) 
    cftf = maxval(abs(x-cf*y))
    x = xh
    do i=1,n 
      args(:n) = (ri(:n)-one)*real(i-1,kr)*dt
      y(2*i-1) = sum(x(1::2)*cos(args(:n))-x(2::2)*sin(args(:n)))
      y(2*i) = sum(x(2::2)*cos(args(:n))+x(1::2)*sin(args(:n)))
    enddo
    call ftcb (x,w) 
    cftb = maxval(abs(x-cf*y))
    x = xh
    y = xh
    call ftcb (y,w) 
    call ftcf (y,w) 
    cftfb = maxval(abs(y-x))
    deallocate(x,y,xh)
    deallocate(w)
!                                                                   
!     test subroutines fthsi and fths                               
!                                                                   
    allocate(x(nm1),y(nm1),xh(nm1))
    allocate(w(fthsiq(nm1)))
    call random_number(x)
    dt = half*dt
    cf = sqrth*cf
    xh = x
    do i=1,nm1 
      args(:nm1) = ri(:nm1)*real(i,kr)*dt
      y(i) = two*sum(x(:)*sin(args(:nm1)))
    enddo
    call fthsi (w) 
    call fths (x,w) 
    fthst = maxval(abs(x-cf*y))
    x = xh
    y = xh
    call fths (x,w) 
    call fths (x,w) 
    fthsfb = maxval(abs(x-y))
    deallocate(x,y,xh)
    deallocate(w)
!                                                                   
!     test subroutines fthci and fthc                               
!                                                                   
    allocate(x(np1),y(np1),xh(np1))
    allocate(w(fthciq(np1)))
    call random_number(x)
    xh = x
    do i=1,np1 
      args = ri*real(i-1,kr)*dt
      y(i) = x(1)+real((-1)**(i+1),kr)*x(n+1) &
                +two*sum(x(2:n)*cos(args(:nm1)))
    enddo
    call fthci (w) 
    call fthc (x,w) 
    fthct = maxval(abs(x-cf*y))
    x = xh
    y = xh
    call fthc (x,w) 
    call fthc (x,w) 
    fthcfb = maxval(abs(x-y))
    deallocate(x,y,xh)
    deallocate(w)
!                                                                   
!     test subroutines ftqsi,ftqsf and ftqsb                        
!                                                                   
    allocate(x(n),y(n),xh(n))
    allocate(w(ftqiq(n)))
    call random_number(y)
    dt = half*dt
    cf = sqrth*cf
    xh = y
    do i=1,n 
      args(:n) = (two*ri(:n)-one)*dt*real(i,kr)
      x(i) = four*sum(y(:)*sin(args(:n)))
    enddo
    call ftqi (w) 
    call ftqsb (y,w) 
    ftqsbt = maxval(abs(y-cf*x)) 
    x = xh
    do i=1,n 
      args(:nm1) = ri(:nm1)*real(2*i-1,kr)*dt
      y(i) = real((-1)**(i+1),kr)*x(n) &
                +two*sum(x(:nm1)*sin(args(:nm1)))
    enddo
    call ftqsf (x,w) 
    ftqsft = maxval(abs(x-cf*y))
    y = xh
    x = xh
    call ftqsf (y,w) 
    call ftqsb (y,w) 
    ftqsfb = maxval(abs(y-x))
!                                                                   
!     test subroutines ftqci,ftqcf and ftqcb                        
!                                                                   
    y = xh
    do i=1,n 
      args(:n) = (two*ri(:n)-one)*real(i-1,kr)*dt
      x(i) = four*sum(y(:)*cos(args(:n)))
    enddo
    call ftqi (w) 
    call ftqcb (y,w) 
    ftqcbt = maxval(abs(cf*x-y))
    x = xh
    do i=1,n 
      args(2:n) = ri(:nm1)*real(2*i-1,kr)*dt
      y(i) =x(1)+two*sum(x(2:n)*cos(args(2:n)))
    enddo
    call ftqcf (x,w) 
    ftqcft = maxval(abs(cf*y-x))
    x = xh
    y = x
    call ftqcb (x,w) 
    call ftqcf (x,w)
    ftqcfb = maxval(abs(x-y)) 
    deallocate(x,y,xh)
    deallocate(w)
!
    deallocate(ri)
    deallocate(args)
    write (6,1001) n,' ftrf ',rftf,' ftrb ',rftb,' ftrfb ',rftfb, &
                   ' ftcf ',cftf,' ftcb ',cftb,' ftcfb ',cftfb, &
                   ' fths ',fthst,' fthsfb ',fthsfb, &
                   ' fthc ',fthct,' fthcfb ',fthcfb, &
                   ' ftqsf ',ftqsft,' ftqsb ',ftqsbt,' ftqsfb ',ftqsfb, &
                    ' ftqcf ',ftqcft,' ftqcb ',ftqcbt,' ftqcfb ',ftqcfb
  enddo
!
stop 
!                                                                   
1001 format (i5/,a,e10.3,a,e10.3,a,e10.3/ &
             a,e10.3,a,e10.3,a,e10.3/ &
             a,e10.3,a,e10.3/ &
             a,e10.3,a,e10.3/ &
             a,e10.3,a,e10.3,a,e10.3/ &
             a,e10.3,a,e10.3,a,e10.3)
!                                                                   
end program
