########################################
# libdca
########################################
MACRO(checkDca)
	IF(NOT LIBDCA_CHECKED)
		OPTION(LIBDCA "" ON)

		MESSAGE(STATUS "Checking for libdca")
		MESSAGE(STATUS "*******************")

		IF(LIBDCA)
			IF(UNIX)
				SET(LIBDCA_REQUIRED_FLAGS "-lm")
			ENDIF()

			SET(LIBDCA_VERSION 005)
		        MESSAGE(STATUS "Trying libdca 0.5")

			FIND_HEADER_AND_LIB(LIBDCA_005 dca.h dca dca_init ${LIBDCA_REQUIRED_FLAGS})

			IF(NOT LIBDCA_005_FOUND)
		                MESSAGE(STATUS "Trying libdca 0.2")
				SET(LIBDCA_VERSION 002)
				FIND_HEADER_AND_LIB(LIBDCA_002 dts.h dts dts_init ${LIBDCA_REQUIRED_FLAGS})
			ENDIF()

			IF(LIBDCA_${LIBDCA_VERSION}_FOUND)
				SET(LIBDCA_FOUND 1)
				SET(USE_LIBDCA_${LIBDCA_VERSION} 1)
				SET(LIBDCA_INCLUDE_DIR "${LIBDCA_${LIBDCA_VERSION}_INCLUDE_DIR}")
				SET(LIBDCA_LIBRARY_DIR "${LIBDCA_${LIBDCA_VERSION}_LIBRARY_DIR}")
			ENDIF()

			PRINT_LIBRARY_INFO("libdca" LIBDCA_FOUND "${LIBDCA_INCLUDE_DIR}" "${LIBDCA_LIBRARY_DIR}")
		ELSE()
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF()

		SET(LIBDCA_CHECKED 1)

		MESSAGE("")
	ENDIF()

	APPEND_SUMMARY_LIST("Audio Decoder" "libdca" "${LIBDCA_FOUND}")
ENDMACRO()
