macro(INITIALISE_SUMMARY_LISTS)
	FOREACH(componentType ${SUMMARY_LIST})
		GET_SUMMARY_LIST_NAME(listName ${componentType})
		unSET(${listName} CACHE)
	ENDFOREACH(componentType)

	SET(SUMMARY_LIST "" CACHE INTERNAL "")
ENDMACRO()

macro(GET_SUMMARY_LIST_NAME outVariable componentType)
	string(REPLACE " " "_" safeComponentType "${componentType}")
	SET(${outVariable} "SUMMARY_${safeComponentType}")
ENDMACRO()

macro(APPEND_SUMMARY_LIST componentType componentName componentFound)
	GET_SUMMARY_LIST_NAME(listName ${componentType})

	IF(${listName})
		SET(${listName} ${${listName}} "${componentName}=${componentFound}" CACHE INTERNAL "")
	ELSE()
		IF(SUMMARY_LIST)
			SET(SUMMARY_LIST ${componentType} ${SUMMARY_LIST} CACHE INTERNAL "")
		ELSE()
			SET(SUMMARY_LIST ${componentType} CACHE INTERNAL "")
		ENDIF()

		SET(${listName} "${componentName}=${componentFound}" CACHE INTERNAL "")
	ENDIF()
ENDMACRO()

function(padString outVariable length padCharacter value)
    string(LENGTH "${value}" valueLength)
    math(EXPR padLength "${length} - ${valueLength} - 1")
    SET(paddedValue ${value})

    IF(padLength GREATER -1)
        FOREACH(dummy RANGE ${padLength})
            SET(paddedValue "${paddedValue}${padCharacter}")
        ENDFOREACH(dummy)
    ENDIF()

    SET(${outVariable} "${paddedValue}" PARENT_SCOPE)
endfunction(padString)

macro(COMPONENT_YESNO incoming componentName outgoing)
        SET(tmp ${incoming})
        string(REGEX REPLACE "=.*$" "" tmp2 ${tmp} )
        string(COMPARE EQUAL ${tmp} ${tmp2} match)
        if(${match})
                SET(${componentName} ${incoming})
                SET(${outgoing}      "No")
        ELSE()
                SET(${componentName} "${tmp2}")
                string(REGEX REPLACE "^.*=" "" tmp3 ${tmp})
                string(COMPARE EQUAL "${tmp3}" "1" match)
                string(COMPARE EQUAL "${tmp3}" "True" match2)
                if(${match} OR ${match2})
                        SET(${outgoing}      "Yes")
                ELSE()
                        SET(${outgoing}      "No")
                ENDIF()
        ENDIF()
ENDMACRO()

macro(DISPLAY_SUMMARY_LIST)
	MESSAGE("")
	MESSAGE("**************************")
	MESSAGE("***  Optional Library  ***")
	MESSAGE("***      Summary       ***")
	MESSAGE("**************************")

	FOREACH(componentType ${SUMMARY_LIST})
		GET_SUMMARY_LIST_NAME(listName ${componentType})

		padString(componentType 18 " " "${componentType}")
		MESSAGE("*** ${componentType} ***")

		FOREACH(component ${${listName}})
                        COMPONENT_YESNO( ${component} componentName componentSummary) 
			padString(componentName 14 " " "${componentName}")
			MESSAGE("    ${componentName} ${componentSummary}")
		ENDFOREACH(component)
	ENDFOREACH(componentType)

	MESSAGE("**************************")

	IF(CMAKE_BUILD_TYPE STREQUAL "Debug")
		MESSAGE("***    Debug Build     ***")
	ELSE()
		MESSAGE("***   Release Build    ***")
	ENDIF()

	MESSAGE("**************************")
	MESSAGE("")
ENDMACRO()
