/***************************************************************************
 $RCSfile: aqminteractor.h,v $
                             -------------------
    cvs         : $Id: aqminteractor.h,v 1.8 2003/04/03 14:15:47 aquamaniac Exp $
    begin       : Tue Jul 16 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AQMINTERACTOR_H
#define AQMINTERACTOR_H

#include <openhbci.h>
using namespace HBCI;

/**
 *
 */
class AQMInteractor: public HBCI::Interactor {
private:
  bool _inputPin(string &pin, bool r);

public:
    AQMInteractor();
    ~AQMInteractor();

    /**
     * Ask the user for the pin of a security medium. This method is called
     * by the default HBCI::Authentifikator.
     * @author Martin Preuss<martin@libchipcard.de>
     * @return true if ok, false if the user aborted
     * @param user user for whom the pin is to be asked for
     * @param pin reference to a variable to receive the pin
     * @param minsize minimum size of the pin.
     * @param newPin if true then the user should be asked for a new pin.
     * Most implementations will ask the user for the pin and then ask him
     * to confirm it (thus making the user doubly enter the pin).
     */
    virtual bool msgInputPin(HBCI::Pointer<HBCI::User> user,
                             string &pin,
                             int minsize,
                             bool newPin);
    /**
     * This method is called directly before the user is supposed to enter the
     * pin into the keypad of a card reader. This is used to inform the user
     * that OpenHBCI started secure pin verification. A graphical application
     * might want to open a window that tells the user about this.
     * (new since 0.9.5)
     * @author Martin Preuss<martin@libchipcard.de>
     * @param user user for whom the pin is to be asked for.
     * Please note that this pointer may be invalid.
     */
    virtual void msgStartInputPinViaKeypad(Pointer<HBCI::User> user);

    /**
     * This method is called directly after the secure pin verification (via
     * the card readers keypad) is finished. A graphical applicatition most
     * likely closes the notification window opened at
     * @ref msgStartInputPinViaKeypad().
     * (new since 0.9.5)
     * @author Martin Preuss<martin@libchipcard.de>
     * @param user user for whom the pin is to be asked for.
     * Please note that this pointer may be invalid.
     */
    virtual void msgFinishedInputPinViaKeypad(Pointer<HBCI::User> user);

    /**
     * Tell the user to insert a card.
     * @author Martin Preuss<martin@libchipcard.de>
     * @return true if ok, false if user wants to abort.
     */
    virtual bool msgInsertMediumOrAbort(HBCI::Pointer<HBCI::User> user,
                                        MediumType t);

    /**
     * Tell the user that:<ul>
     * <li>the currently inserted card is not the right one</li>
     * <li>he should now insert the correct card</li>
     * </ul>
     * @author Martin Preuss<martin@libchipcard.de>
     * @return true if ok, false if user wants to abort.
     */
    virtual bool
        msgInsertCorrectMediumOrAbort(HBCI::Pointer<HBCI::User> user,
                                      MediumType t);

    /**
     * Prints a message that might be used for logging purpose. Does not
     * require interaction
     * This method should be overwritten by your application !
     * @param msg the message to show
     */
    virtual void msgStateResponse(const string &msg);
    /*bool keepAlive()
     {
     return true;
     }*/


    
};





#endif // AQMINTERACTOR_H



